/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.ActionConvertor;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.ActionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.BucketId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.buckets.Bucket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.buckets.BucketBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.buckets.BucketKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.desc.stats.reply.GroupDescStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.desc.stats.reply.GroupDescStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.desc.stats.reply.GroupDescStatsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.BucketsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.DurationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.buckets.BucketCounter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.buckets.BucketCounterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.buckets.BucketCounterKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.reply.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.reply.GroupStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.reply.GroupStatsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.BucketsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc.GroupDesc;

public class GroupStatsResponseConvertor {
    public List<GroupStats> toSALGroupStatsList(List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStats> allGroupStats) {
        ArrayList<GroupStats> convertedSALGroups = new ArrayList<GroupStats>();
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStats group : allGroupStats) {
            convertedSALGroups.add(this.toSALGroupStats(group));
        }
        return convertedSALGroups;
    }

    public GroupStats toSALGroupStats(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStats groupStats) {
        GroupStatsBuilder salGroupStats = new GroupStatsBuilder();
        salGroupStats.setBuckets(this.toSALBuckets(groupStats.getBucketStats()));
        salGroupStats.setByteCount(new Counter64(groupStats.getByteCount()));
        DurationBuilder time = new DurationBuilder();
        time.setSecond(new Counter32(groupStats.getDurationSec()));
        time.setNanosecond(new Counter32(groupStats.getDurationNsec()));
        salGroupStats.setDuration(time.build());
        salGroupStats.setGroupId(new GroupId(groupStats.getGroupId().getValue()));
        salGroupStats.setPacketCount(new Counter64(groupStats.getPacketCount()));
        salGroupStats.setRefCount(new Counter32(groupStats.getRefCount()));
        salGroupStats.setKey(new GroupStatsKey(salGroupStats.getGroupId()));
        return salGroupStats.build();
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.Buckets toSALBuckets(List<BucketStats> bucketStats) {
        BucketsBuilder salBuckets = new BucketsBuilder();
        ArrayList<BucketCounter> allBucketStats = new ArrayList<BucketCounter>();
        int bucketKey = 0;
        for (BucketStats bucketStat : bucketStats) {
            BucketCounterBuilder bucketCounter = new BucketCounterBuilder();
            bucketCounter.setByteCount(new Counter64(bucketStat.getByteCount()));
            bucketCounter.setPacketCount(new Counter64(bucketStat.getPacketCount()));
            BucketId bucketId = new BucketId(Long.valueOf(bucketKey));
            bucketCounter.setKey(new BucketCounterKey(bucketId));
            bucketCounter.setBucketId(bucketId);
            ++bucketKey;
            allBucketStats.add(bucketCounter.build());
        }
        salBuckets.setBucketCounter(allBucketStats);
        return salBuckets.build();
    }

    public List<GroupDescStats> toSALGroupDescStatsList(List<GroupDesc> allGroupDescStats) {
        ArrayList<GroupDescStats> convertedSALGroupsDesc = new ArrayList<GroupDescStats>();
        for (GroupDesc groupDesc : allGroupDescStats) {
            convertedSALGroupsDesc.add(this.toSALGroupDescStats(groupDesc));
        }
        return convertedSALGroupsDesc;
    }

    public GroupDescStats toSALGroupDescStats(GroupDesc groupDesc) {
        GroupDescStatsBuilder salGroupDescStats = new GroupDescStatsBuilder();
        salGroupDescStats.setBuckets(this.toSALBucketsDesc(groupDesc.getBucketsList()));
        salGroupDescStats.setGroupId(new GroupId(groupDesc.getGroupId().getValue()));
        salGroupDescStats.setGroupType(GroupTypes.forValue((int)groupDesc.getType().getIntValue()));
        salGroupDescStats.setKey(new GroupDescStatsKey(salGroupDescStats.getGroupId()));
        return salGroupDescStats.build();
    }

    public Buckets toSALBucketsDesc(List<BucketsList> bucketDescStats) {
        org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.BucketsBuilder salBucketsDesc = new org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.BucketsBuilder();
        ArrayList<Bucket> allBuckets = new ArrayList<Bucket>();
        int bucketKey = 0;
        for (BucketsList bucketDetails : bucketDescStats) {
            BucketBuilder bucketDesc = new BucketBuilder();
            List<Action> convertedSalActions = ActionConvertor.toMDSalActions(bucketDetails.getActionsList());
            ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> actions = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action>();
            int actionKey = 0;
            for (Action action : convertedSalActions) {
                ActionBuilder wrappedAction = new ActionBuilder();
                wrappedAction.setAction(action);
                wrappedAction.setKey(new ActionKey(Integer.valueOf(actionKey)));
                wrappedAction.setOrder(Integer.valueOf(actionKey));
                actions.add(wrappedAction.build());
                ++actionKey;
            }
            bucketDesc.setAction(actions);
            bucketDesc.setWeight(bucketDetails.getWeight());
            bucketDesc.setWatchPort(bucketDetails.getWatchPort().getValue());
            bucketDesc.setWatchGroup(bucketDetails.getWatchGroup());
            BucketId bucketId = new BucketId(Long.valueOf(bucketKey));
            bucketDesc.setBucketId(bucketId);
            bucketDesc.setKey(new BucketKey(bucketId));
            ++bucketKey;
            allBuckets.add(bucketDesc.build());
        }
        salBucketsDesc.setBucket(allBuckets);
        return salBucketsDesc.build();
    }
}

