/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.util.BinContent;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.ActionConvertor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.AddGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.RemoveGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.UpdatedGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.buckets.Bucket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.BucketsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.BucketsListBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupConvertor {
    private static final Logger logger = LoggerFactory.getLogger(GroupConvertor.class);
    private static final String PREFIX_SEPARATOR = "/";
    private static final Integer DEFAULT_WEIGHT = new Integer(0);
    private static final Long OFPP_ANY;
    private static final Long DEFAULT_WATCH_PORT;
    private static final Long OFPG_ANY;
    private static final Long DEFAULT_WATCH_GROUP;

    private GroupConvertor() {
    }

    public static GroupModInputBuilder toGroupModInput(Group source, short version, BigInteger datapathid) {
        ArrayList<BucketsList> bucketLists = null;
        GroupModInputBuilder groupModInputBuilder = new GroupModInputBuilder();
        if (source instanceof AddGroupInput) {
            groupModInputBuilder.setCommand(GroupModCommand.OFPGCADD);
        } else if (source instanceof RemoveGroupInput) {
            groupModInputBuilder.setCommand(GroupModCommand.OFPGCDELETE);
        } else if (source instanceof UpdatedGroup) {
            groupModInputBuilder.setCommand(GroupModCommand.OFPGCMODIFY);
        }
        if (source.getGroupType().getIntValue() == 0) {
            groupModInputBuilder.setType(GroupType.OFPGTALL);
        }
        if (source.getGroupType().getIntValue() == 1) {
            groupModInputBuilder.setType(GroupType.OFPGTSELECT);
        }
        if (source.getGroupType().getIntValue() == 2) {
            groupModInputBuilder.setType(GroupType.OFPGTINDIRECT);
        }
        if (source.getGroupType().getIntValue() == 3) {
            groupModInputBuilder.setType(GroupType.OFPGTFF);
        }
        groupModInputBuilder.setGroupId(new GroupId(source.getGroupId().getValue()));
        if (source.getBuckets() != null && source.getBuckets().getBucket().size() != 0) {
            bucketLists = new ArrayList<BucketsList>();
            GroupConvertor.getbucketList(source.getBuckets(), bucketLists, version, source.getGroupType().getIntValue(), datapathid);
            groupModInputBuilder.setBucketsList(bucketLists);
        }
        groupModInputBuilder.setVersion(Short.valueOf(version));
        return groupModInputBuilder;
    }

    private static void getbucketList(Buckets buckets, List<BucketsList> bucketLists, short version, int groupType, BigInteger datapathid) {
        for (Bucket groupBucket : buckets.getBucket()) {
            BucketsListBuilder bucketBuilder = new BucketsListBuilder();
            if (groupType == GroupType.OFPGTSELECT.getIntValue() && groupBucket.getWeight() == null) {
                logger.error("Weight value required for this OFPGT_SELECT");
            }
            if (null != groupBucket.getWeight()) {
                bucketBuilder.setWeight(Integer.valueOf(groupBucket.getWeight()));
            } else {
                bucketBuilder.setWeight(DEFAULT_WEIGHT);
            }
            if (groupType == GroupType.OFPGTFF.getIntValue() && groupBucket.getWatchGroup() == null) {
                logger.error("WatchGroup required for this OFPGT_FF");
            }
            if (null != groupBucket.getWatchGroup()) {
                bucketBuilder.setWatchGroup(groupBucket.getWatchGroup());
            } else {
                bucketBuilder.setWatchGroup(Long.valueOf(BinContent.intToUnsignedLong((int)DEFAULT_WATCH_GROUP.intValue())));
            }
            if (groupType == GroupType.OFPGTFF.getIntValue() && groupBucket.getWatchPort() == null) {
                logger.error("WatchPort required for this OFPGT_FF");
            }
            if (null != groupBucket.getWatchPort()) {
                bucketBuilder.setWatchPort(new PortNumber(groupBucket.getWatchPort()));
            } else {
                bucketBuilder.setWatchPort(new PortNumber(Long.valueOf(BinContent.intToUnsignedLong((int)DEFAULT_WATCH_PORT.intValue()))));
            }
            List<ActionsList> bucketActionList = ActionConvertor.getActionList(groupBucket.getAction(), version, datapathid);
            bucketBuilder.setActionsList(bucketActionList);
            BucketsList bucket = bucketBuilder.build();
            bucketLists.add(bucket);
        }
    }

    static {
        DEFAULT_WATCH_PORT = OFPP_ANY = Long.valueOf(Long.parseLong("ffffffff", 16));
        DEFAULT_WATCH_GROUP = OFPG_ANY = Long.valueOf(Long.parseLong("ffffffff", 16));
    }
}

