/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor;

import com.google.common.base.Objects;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.ActionConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.flowflag.FlowFlagReactor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match.MatchReactor;
import org.opendaylight.openflowplugin.openflow.md.util.ByteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update.UpdatedFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.ApplyActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.ClearActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.GoToTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.MeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.WriteActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.WriteMetadataCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.apply.actions._case.ApplyActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.go.to.table._case.GoToTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ActionsInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ActionsInstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataInstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MeterIdInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MeterIdInstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TableIdInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TableIdInstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.ClearActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.GotoTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.WriteActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.WriteMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.InstructionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MatchTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInputBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowConvertor {
    private static final Logger logger = LoggerFactory.getLogger(FlowConvertor.class);
    private static final BigInteger DEFAULT_COOKIE = BigInteger.ZERO;
    private static final BigInteger DEFAULT_COOKIE_MASK = BigInteger.ZERO;
    private static final TableId DEFAULT_TABLE_ID = new TableId(new Long(0L));
    private static final Integer DEFAULT_IDLE_TIMEOUT = new Integer(300);
    private static final Integer DEFAULT_HARD_TIMEOUT = new Integer(600);
    private static final Integer DEFAULT_PRIORITY = Integer.parseInt("8000", 16);
    private static final Long DEFAULT_BUFFER_ID = Long.parseLong("ffffffff", 16);
    private static final Long OFPP_ANY;
    private static final Long DEFAULT_OUT_PORT;
    private static final Long OFPG_ANY;
    private static final Long DEFAULT_OUT_GROUP;
    public static final boolean DEFAULT_OFPFF_FLOW_REM = true;
    public static final boolean DEFAULT_OFPFF_CHECK_OVERLAP = false;
    public static final boolean DEFAULT_OFPFF_RESET_COUNTS = false;
    public static final boolean DEFAULT_OFPFF_NO_PKT_COUNTS = false;
    public static final boolean DEFAULT_OFPFF_NO_BYT_COUNTS = false;
    public static final boolean DEFAULT_OFPFF_EMERGENCY = false;
    public static final Class<? extends MatchTypeBase> DEFAULT_MATCH_TYPE;
    public static final List<MatchEntries> DEFAULT_MATCH_ENTRIES;

    public static FlowModInputBuilder toFlowModInput(Flow flow, short version, BigInteger datapathid) {
        FlowModInputBuilder flowMod = new FlowModInputBuilder();
        if (flow.getCookie() != null) {
            flowMod.setCookie(flow.getCookie());
        } else {
            flowMod.setCookie(DEFAULT_COOKIE);
        }
        if (flow.getCookieMask() != null) {
            flowMod.setCookieMask(new BigInteger(flow.getCookieMask().toString()));
        } else {
            flowMod.setCookieMask(DEFAULT_COOKIE_MASK);
        }
        if (flow.getTableId() != null) {
            flowMod.setTableId(new TableId(Long.valueOf(flow.getTableId().longValue())));
        } else {
            flowMod.setTableId(DEFAULT_TABLE_ID);
        }
        if (flow instanceof AddFlowInput) {
            flowMod.setCommand(FlowModCommand.OFPFCADD);
        } else if (flow instanceof RemoveFlowInput) {
            if (((Boolean)Objects.firstNonNull((Object)flow.isStrict(), (Object)Boolean.FALSE)).booleanValue()) {
                flowMod.setCommand(FlowModCommand.OFPFCDELETESTRICT);
            } else {
                flowMod.setCommand(FlowModCommand.OFPFCDELETE);
            }
        } else if (flow instanceof UpdatedFlow) {
            if (((Boolean)Objects.firstNonNull((Object)flow.isStrict(), (Object)Boolean.FALSE)).booleanValue()) {
                flowMod.setCommand(FlowModCommand.OFPFCMODIFYSTRICT);
            } else {
                flowMod.setCommand(FlowModCommand.OFPFCMODIFY);
            }
        }
        if (flow.getIdleTimeout() != null) {
            flowMod.setIdleTimeout(flow.getIdleTimeout());
        } else {
            flowMod.setIdleTimeout(DEFAULT_IDLE_TIMEOUT);
        }
        if (flow.getHardTimeout() != null) {
            flowMod.setHardTimeout(flow.getHardTimeout());
        } else {
            flowMod.setHardTimeout(DEFAULT_HARD_TIMEOUT);
        }
        if (flow.getPriority() != null) {
            flowMod.setPriority(flow.getPriority());
        } else {
            flowMod.setPriority(DEFAULT_PRIORITY);
        }
        if (flow.getBufferId() != null) {
            flowMod.setBufferId(flow.getBufferId());
        } else {
            flowMod.setBufferId(DEFAULT_BUFFER_ID);
        }
        if (flow.getOutPort() != null) {
            flowMod.setOutPort(new PortNumber(Long.valueOf(flow.getOutPort().longValue())));
        } else {
            flowMod.setOutPort(new PortNumber(DEFAULT_OUT_PORT));
        }
        if (flow.getOutGroup() != null) {
            flowMod.setOutGroup(flow.getOutGroup());
        } else {
            flowMod.setOutGroup(DEFAULT_OUT_GROUP);
        }
        FlowFlagReactor.getInstance().convert(flow.getFlags(), version, flowMod, datapathid);
        MatchReactor.getInstance().convert(flow.getMatch(), version, flowMod, datapathid);
        if (flow.getInstructions() != null) {
            flowMod.setInstructions(FlowConvertor.toInstructions(flow.getInstructions(), version, datapathid));
            flowMod.setActionsList(FlowConvertor.getActionsList(flow.getInstructions(), version, datapathid));
        }
        flowMod.setVersion(Short.valueOf(version));
        return flowMod;
    }

    private static List<Instructions> toInstructions(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Instructions instructions, short version, BigInteger datapathid) {
        ArrayList<Instructions> instructionsList = new ArrayList<Instructions>();
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction instruction : instructions.getInstruction()) {
            ActionsInstructionBuilder actionsInstructionBuilder;
            InstructionsBuilder instructionBuilder = new InstructionsBuilder();
            Instruction curInstruction = instruction.getInstruction();
            if (curInstruction instanceof GoToTableCase) {
                GoToTableCase goToTablecase = (GoToTableCase)curInstruction;
                GoToTable goToTable = goToTablecase.getGoToTable();
                instructionBuilder.setType(GotoTable.class);
                TableIdInstructionBuilder tableBuilder = new TableIdInstructionBuilder();
                tableBuilder.setTableId(goToTable.getTableId());
                instructionBuilder.addAugmentation(TableIdInstruction.class, (Augmentation)tableBuilder.build());
                instructionsList.add(instructionBuilder.build());
                continue;
            }
            if (curInstruction instanceof WriteMetadataCase) {
                WriteMetadataCase writeMetadatacase = (WriteMetadataCase)curInstruction;
                org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.write.metadata._case.WriteMetadata writeMetadata = writeMetadatacase.getWriteMetadata();
                instructionBuilder.setType(WriteMetadata.class);
                MetadataInstructionBuilder metadataBuilder = new MetadataInstructionBuilder();
                metadataBuilder.setMetadata(ByteUtil.convertBigIntegerToNBytes(writeMetadata.getMetadata(), 8));
                metadataBuilder.setMetadataMask(ByteUtil.convertBigIntegerToNBytes(writeMetadata.getMetadataMask(), 8));
                instructionBuilder.addAugmentation(MetadataInstruction.class, (Augmentation)metadataBuilder.build());
                instructionsList.add(instructionBuilder.build());
                continue;
            }
            if (curInstruction instanceof WriteActionsCase) {
                WriteActionsCase writeActionscase = (WriteActionsCase)curInstruction;
                org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.write.actions._case.WriteActions writeActions = writeActionscase.getWriteActions();
                instructionBuilder.setType(WriteActions.class);
                actionsInstructionBuilder = new ActionsInstructionBuilder();
                actionsInstructionBuilder.setActionsList(ActionConvertor.getActionList(writeActions.getAction(), version, datapathid));
                instructionBuilder.addAugmentation(ActionsInstruction.class, (Augmentation)actionsInstructionBuilder.build());
                instructionsList.add(instructionBuilder.build());
                continue;
            }
            if (curInstruction instanceof ApplyActionsCase) {
                ApplyActionsCase applyActionscase = (ApplyActionsCase)curInstruction;
                ApplyActions applyActions = applyActionscase.getApplyActions();
                instructionBuilder.setType(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.ApplyActions.class);
                actionsInstructionBuilder = new ActionsInstructionBuilder();
                actionsInstructionBuilder.setActionsList(ActionConvertor.getActionList(applyActions.getAction(), version, datapathid));
                instructionBuilder.addAugmentation(ActionsInstruction.class, (Augmentation)actionsInstructionBuilder.build());
                instructionsList.add(instructionBuilder.build());
                continue;
            }
            if (curInstruction instanceof ClearActionsCase) {
                ClearActionsCase clearActionscase = (ClearActionsCase)curInstruction;
                org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.clear.actions._case.ClearActions clearActions = clearActionscase.getClearActions();
                instructionBuilder.setType(ClearActions.class);
                actionsInstructionBuilder = new ActionsInstructionBuilder();
                actionsInstructionBuilder.setActionsList(ActionConvertor.getActionList(clearActions.getAction(), version, datapathid));
                instructionBuilder.addAugmentation(ActionsInstruction.class, (Augmentation)actionsInstructionBuilder.build());
                instructionsList.add(instructionBuilder.build());
                continue;
            }
            if (!(curInstruction instanceof MeterCase)) continue;
            MeterCase metercase = (MeterCase)curInstruction;
            org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.meter._case.Meter meter = metercase.getMeter();
            instructionBuilder.setType(Meter.class);
            MeterIdInstructionBuilder meterBuilder = new MeterIdInstructionBuilder();
            Long meterId = meter.getMeterId().getValue();
            meterBuilder.setMeterId(meterId);
            instructionBuilder.addAugmentation(MeterIdInstruction.class, (Augmentation)meterBuilder.build());
            instructionsList.add(instructionBuilder.build());
        }
        return instructionsList;
    }

    private static List<ActionsList> getActionsList(org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Instructions instructions, short version, BigInteger datapathid) {
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction instruction : instructions.getInstruction()) {
            Instruction curInstruction = instruction.getInstruction();
            if (!(curInstruction instanceof ApplyActionsCase)) continue;
            ApplyActionsCase applyActionscase = (ApplyActionsCase)curInstruction;
            ApplyActions applyActions = applyActionscase.getApplyActions();
            return ActionConvertor.getActionList(applyActions.getAction(), version, datapathid);
        }
        return null;
    }

    static {
        DEFAULT_OUT_PORT = OFPP_ANY = Long.valueOf(Long.parseLong("ffffffff", 16));
        DEFAULT_OUT_GROUP = OFPG_ANY = Long.valueOf(Long.parseLong("ffffffff", 16));
        DEFAULT_MATCH_TYPE = OxmMatchType.class;
        DEFAULT_MATCH_ENTRIES = new ArrayList<MatchEntries>();
    }
}

