/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal.convertor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.util.BinContent;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match.MatchConvertorImpl;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match.MatchReactor;
import org.opendaylight.openflowplugin.openflow.md.util.InventoryDataServiceUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Dscp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.CopyTtlInCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.CopyTtlInCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.CopyTtlOutCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.CopyTtlOutCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.DecMplsTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.DecMplsTtlCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.DecNwTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.DecNwTtlCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.GroupActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.GroupActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.OutputActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopMplsActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopMplsActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopPbbActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopPbbActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopVlanActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PopVlanActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushMplsActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushMplsActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushPbbActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushPbbActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushVlanActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.PushVlanActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetDlDstActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetDlSrcActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetFieldCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetFieldCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetMplsTtlActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetMplsTtlActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNwDstActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNwSrcActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNwTosActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNwTtlActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetNwTtlActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetQueueActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetQueueActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetTpDstActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetTpSrcActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetVlanIdActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.SetVlanPcpActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.StripVlanActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.copy.ttl.in._case.CopyTtlInBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.copy.ttl.out._case.CopyTtlOutBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.dec.mpls.ttl._case.DecMplsTtlBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.dec.nw.ttl._case.DecNwTtlBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.group.action._case.GroupAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.group.action._case.GroupActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.output.action._case.OutputAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.output.action._case.OutputActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.pop.mpls.action._case.PopMplsActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.pop.pbb.action._case.PopPbbActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.pop.vlan.action._case.PopVlanActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.push.mpls.action._case.PushMplsActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.push.pbb.action._case.PushPbbActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.push.vlan.action._case.PushVlanAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.push.vlan.action._case.PushVlanActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.dl.dst.action._case.SetDlDstAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.dl.src.action._case.SetDlSrcAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.field._case.SetField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.mpls.ttl.action._case.SetMplsTtlAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.mpls.ttl.action._case.SetMplsTtlActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.nw.dst.action._case.SetNwDstAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.nw.src.action._case.SetNwSrcAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.nw.tos.action._case.SetNwTosAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.nw.ttl.action._case.SetNwTtlActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.queue.action._case.SetQueueAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.queue.action._case.SetQueueActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.tp.dst.action._case.SetTpDstAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.tp.src.action._case.SetTpSrcAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.vlan.id.action._case.SetVlanIdAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.set.vlan.pcp.action._case.SetVlanPcpAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.address.Ipv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.OutputPortValues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DlAddressAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DlAddressActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthertypeAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthertypeActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.GroupIdAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.GroupIdActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IpAddressAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IpAddressActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv4AddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv4AddressMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsTtlAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsTtlActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTosAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTosActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTtlAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTtlActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OxmFieldsAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OxmFieldsActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.QueueIdAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.QueueIdActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.CopyTtlIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.CopyTtlOut;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.DecMplsTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.DecNwTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Output;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopMpls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopPbb;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushMpls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushPbb;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetDlDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetDlSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetMplsTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwTos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetTpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetTpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetVlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetVlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.StripVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumberValues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumberValuesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntriesBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionConvertor {
    private static final Logger logger = LoggerFactory.getLogger(ActionConvertor.class);
    private static final String PREFIX_SEPARATOR = "/";
    private static final Long MAXPortOF13 = new Long(0xFFFFFF00L);
    private static final Long MAXPortOF10 = new Long(65280L);

    private ActionConvertor() {
    }

    public static List<ActionsList> getActionList(List<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action> actions, short version, BigInteger datapathid) {
        ActionsListBuilder actionsListBuilder = new ActionsListBuilder();
        ArrayList<ActionsList> actionsList = new ArrayList<ActionsList>();
        for (int actionItem = 0; actionItem < actions.size(); ++actionItem) {
            ActionsList list = null;
            org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action = actions.get(actionItem).getAction();
            if (action instanceof OutputActionCase) {
                list = ActionConvertor.salToOFOutputAction(action, actionsListBuilder, version);
            } else if (action instanceof GroupActionCase) {
                list = ActionConvertor.SalToOFGroupAction(action, actionsListBuilder);
            } else if (action instanceof CopyTtlOutCase) {
                list = ActionConvertor.SalToOFCopyTTLIOut(actionsListBuilder);
            } else if (action instanceof CopyTtlInCase) {
                list = ActionConvertor.SalToOFCopyTTLIIn(actionsListBuilder);
            } else if (action instanceof SetMplsTtlActionCase) {
                list = ActionConvertor.SalToOFSetMplsTtl(action, actionsListBuilder);
            } else if (action instanceof DecMplsTtlCase) {
                list = ActionConvertor.SalToOFDecMplsTtl(actionsListBuilder);
            } else if (action instanceof PushVlanActionCase) {
                list = ActionConvertor.SalToOFPushVlanAction(action, actionsListBuilder);
            } else if (action instanceof PopVlanActionCase) {
                list = ActionConvertor.SalToOFPopVlan(action, actionsListBuilder);
            } else if (action instanceof PushMplsActionCase) {
                list = ActionConvertor.SalToOFPushMplsAction(action, actionsListBuilder);
            } else if (action instanceof PopMplsActionCase) {
                list = ActionConvertor.SalToOFPopMpls(action, actionsListBuilder);
            } else if (action instanceof SetQueueActionCase) {
                list = ActionConvertor.SalToOFSetQueue(action, actionsListBuilder);
            } else if (action instanceof SetNwTtlActionCase) {
                list = ActionConvertor.SalToOFSetNwTtl(action, actionsListBuilder);
            } else if (action instanceof DecNwTtlCase) {
                list = ActionConvertor.SalToOFDecNwTtl(action, actionsListBuilder);
            } else if (action instanceof SetFieldCase) {
                list = ActionConvertor.SalToOFSetField(action, actionsListBuilder, version, datapathid);
            } else if (action instanceof PushPbbActionCase) {
                list = ActionConvertor.SalToOFPushPbbAction(action, actionsListBuilder);
            } else if (action instanceof PopPbbActionCase) {
                list = ActionConvertor.SalToOFPopPBB(action, actionsListBuilder);
            } else if (action instanceof ExperimenterAction) {
                list = ActionConvertor.SalToOFExperimenter(action, actionsListBuilder);
            } else if (action instanceof SetVlanIdActionCase) {
                list = ActionConvertor.SalToOFSetVlanId(action, actionsListBuilder, version);
            } else if (action instanceof SetVlanPcpActionCase) {
                list = ActionConvertor.SalToOFSetVlanpcp(action, actionsListBuilder, version);
            } else if (action instanceof StripVlanActionCase) {
                list = ActionConvertor.SalToOFStripVlan(action, actionsListBuilder, version);
            } else if (action instanceof SetDlSrcActionCase) {
                list = ActionConvertor.SalToOFSetDlSrc(action, actionsListBuilder, version);
            } else if (action instanceof SetDlDstActionCase) {
                list = ActionConvertor.SalToOFSetDlDst(action, actionsListBuilder, version);
            } else if (action instanceof SetNwSrcActionCase) {
                list = ActionConvertor.SalToOFSetNwSrc(action, actionsListBuilder, version);
            } else if (action instanceof SetNwDstActionCase) {
                list = ActionConvertor.SalToOFSetNwDst(action, actionsListBuilder, version);
            } else if (action instanceof SetTpSrcActionCase) {
                list = ActionConvertor.SalToOFSetTpSrc(action, actionsListBuilder, version);
            } else if (action instanceof SetTpDstActionCase) {
                list = ActionConvertor.SalToOFSetTpDst(action, actionsListBuilder, version);
            } else if (action instanceof SetNwTosActionCase) {
                list = ActionConvertor.SalToOFSetNwTos(action, actionsListBuilder, version);
            }
            if (list == null) continue;
            actionsList.add(list);
        }
        return actionsList;
    }

    private static ActionsList SalToOFSetField(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version, BigInteger datapathid) {
        SetFieldCase setFieldCase = (SetFieldCase)action;
        SetField match = setFieldCase.getSetField();
        OxmFieldsActionBuilder oxmFieldsActionBuilder = new OxmFieldsActionBuilder();
        MatchReactor.getInstance().convert(match, version, oxmFieldsActionBuilder, datapathid);
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField.class);
        actionBuilder.addAugmentation(OxmFieldsAction.class, (Augmentation)oxmFieldsActionBuilder.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList SalToOFDecNwTtl(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(DecNwTtl.class);
        return ActionConvertor.emtpyAction(actionBuilder, actionsListBuilder);
    }

    private static ActionsList SalToOFPushMplsAction(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        PushMplsActionCase pushMplsActionCase = (PushMplsActionCase)action;
        actionBuilder.setType(PushMpls.class);
        return ActionConvertor.SalToOFPushAction(pushMplsActionCase.getPushMplsAction().getEthernetType(), actionBuilder, actionsListBuilder);
    }

    private static ActionsList SalToOFPushPbbAction(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        PushPbbActionCase pushPbbActionCase = (PushPbbActionCase)action;
        actionBuilder.setType(PushPbb.class);
        return ActionConvertor.SalToOFPushAction(pushPbbActionCase.getPushPbbAction().getEthernetType(), actionBuilder, actionsListBuilder);
    }

    private static ActionsList SalToOFPushVlanAction(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        PushVlanActionCase pushVlanActionCase = (PushVlanActionCase)action;
        PushVlanAction pushVlanAction = pushVlanActionCase.getPushVlanAction();
        actionBuilder.setType(PushVlan.class);
        return ActionConvertor.SalToOFPushAction(pushVlanAction.getEthernetType(), actionBuilder, actionsListBuilder);
    }

    private static ActionsList SalToOFSetNwTtl(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        SetNwTtlActionCase nwTtlActionCase = (SetNwTtlActionCase)action;
        NwTtlActionBuilder nwTtlActionBuilder = new NwTtlActionBuilder();
        nwTtlActionBuilder.setNwTtl(nwTtlActionCase.getSetNwTtlAction().getNwTtl());
        actionBuilder.setType(SetNwTtl.class);
        actionBuilder.addAugmentation(NwTtlAction.class, (Augmentation)nwTtlActionBuilder.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList SalToOFSetQueue(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        SetQueueActionCase setQueueActionCase = (SetQueueActionCase)action;
        SetQueueAction setQueueAction = setQueueActionCase.getSetQueueAction();
        QueueIdActionBuilder queueIdActionBuilder = new QueueIdActionBuilder();
        queueIdActionBuilder.setQueueId(setQueueAction.getQueueId());
        actionBuilder.setType(SetQueue.class);
        actionBuilder.addAugmentation(QueueIdAction.class, (Augmentation)queueIdActionBuilder.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList SalToOFPopMpls(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        PopMplsActionCase popMplsActionCase = (PopMplsActionCase)action;
        actionBuilder.setType(PopMpls.class);
        return ActionConvertor.SalToOFPushAction(popMplsActionCase.getPopMplsAction().getEthernetType(), actionBuilder, actionsListBuilder);
    }

    private static ActionsList SalToOFPopVlan(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(PopVlan.class);
        return ActionConvertor.emtpyAction(actionBuilder, actionsListBuilder);
    }

    private static ActionsList SalToOFPopPBB(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(PopPbb.class);
        return ActionConvertor.emtpyAction(actionBuilder, actionsListBuilder);
    }

    private static ActionsList SalToOFExperimenter(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        ExperimenterActionBuilder experimenterActionBuilder = new ExperimenterActionBuilder();
        experimenterActionBuilder.setExperimenter(((ExperimenterAction)action).getExperimenter());
        actionBuilder.setType(Experimenter.class);
        actionBuilder.addAugmentation(ExperimenterAction.class, (Augmentation)experimenterActionBuilder);
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList SalToOFSetVlanId(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        SetVlanIdActionCase setvlanidcase = (SetVlanIdActionCase)action;
        SetVlanIdAction setvlanidaction = setvlanidcase.getSetVlanIdAction();
        if (version == 1) {
            ActionBuilder actionBuilder = new ActionBuilder();
            VlanVidActionBuilder vlanidActionBuilder = new VlanVidActionBuilder();
            vlanidActionBuilder.setVlanVid(setvlanidaction.getVlanId().getValue());
            actionBuilder.setType(SetVlanVid.class);
            actionBuilder.addAugmentation(VlanVidAction.class, (Augmentation)vlanidActionBuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        if (version >= 4) {
            OxmFieldsActionBuilder oxmFieldsActionBuilder = new OxmFieldsActionBuilder();
            ActionBuilder actionBuilder = new ActionBuilder();
            actionBuilder.setType(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField.class);
            ArrayList<MatchEntries> matchEntriesList = new ArrayList<MatchEntries>();
            MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
            matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
            matchEntriesBuilder.setOxmMatchField(VlanVid.class);
            VlanVidMatchEntryBuilder vlanVidBuilder = new VlanVidMatchEntryBuilder();
            vlanVidBuilder.setCfiBit(Boolean.valueOf(true));
            vlanVidBuilder.setVlanVid(setvlanidaction.getVlanId().getValue());
            matchEntriesBuilder.addAugmentation(VlanVidMatchEntry.class, (Augmentation)vlanVidBuilder.build());
            matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
            matchEntriesList.add(matchEntriesBuilder.build());
            oxmFieldsActionBuilder.setMatchEntries(matchEntriesList);
            actionBuilder.addAugmentation(OxmFieldsAction.class, (Augmentation)oxmFieldsActionBuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        logger.error("Unknown Action Type for the Version", (Object)version);
        return null;
    }

    private static ActionsList SalToOFSetVlanpcp(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        SetVlanPcpActionCase setvlanpcpcase = (SetVlanPcpActionCase)action;
        SetVlanPcpAction setvlanpcpaction = setvlanpcpcase.getSetVlanPcpAction();
        if (version == 1) {
            ActionBuilder actionBuilder = new ActionBuilder();
            VlanPcpActionBuilder vlanpcpActionBuilder = new VlanPcpActionBuilder();
            vlanpcpActionBuilder.setVlanPcp(setvlanpcpaction.getVlanPcp().getValue());
            actionBuilder.setType(SetVlanPcp.class);
            actionBuilder.addAugmentation(VlanPcpAction.class, (Augmentation)vlanpcpActionBuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        if (version >= 4) {
            OxmFieldsActionBuilder oxmFieldsActionBuilder = new OxmFieldsActionBuilder();
            ActionBuilder actionBuilder = new ActionBuilder();
            actionBuilder.setType(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField.class);
            ArrayList<MatchEntries> matchEntriesList = new ArrayList<MatchEntries>();
            matchEntriesList.add(MatchConvertorImpl.toOfVlanPcp(setvlanpcpaction.getVlanPcp()));
            oxmFieldsActionBuilder.setMatchEntries(matchEntriesList);
            actionBuilder.addAugmentation(OxmFieldsAction.class, (Augmentation)oxmFieldsActionBuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        logger.error("Unknown Action Type for the Version", (Object)version);
        return null;
    }

    private static ActionsList SalToOFStripVlan(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        if (version == 1) {
            ActionBuilder actionBuilder = new ActionBuilder();
            actionBuilder.setType(StripVlan.class);
            return ActionConvertor.emtpyAction(actionBuilder, actionsListBuilder);
        }
        if (version >= 4) {
            OxmFieldsActionBuilder oxmFieldsActionBuilder = new OxmFieldsActionBuilder();
            ActionBuilder actionBuilder = new ActionBuilder();
            actionBuilder.setType(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField.class);
            ArrayList<MatchEntries> matchEntriesList = new ArrayList<MatchEntries>();
            MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
            matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
            matchEntriesBuilder.setOxmMatchField(VlanVid.class);
            VlanVidMatchEntryBuilder vlanVidBuilder = new VlanVidMatchEntryBuilder();
            vlanVidBuilder.setCfiBit(Boolean.valueOf(true));
            vlanVidBuilder.setVlanVid(new Integer(0));
            matchEntriesBuilder.addAugmentation(VlanVidMatchEntry.class, (Augmentation)vlanVidBuilder.build());
            matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
            matchEntriesList.add(matchEntriesBuilder.build());
            oxmFieldsActionBuilder.setMatchEntries(matchEntriesList);
            actionBuilder.addAugmentation(OxmFieldsAction.class, (Augmentation)oxmFieldsActionBuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        logger.error("Unknown Action Type for the Version", (Object)version);
        return null;
    }

    private static ActionsList SalToOFSetDlSrc(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        SetDlSrcActionCase setdlsrccase = (SetDlSrcActionCase)action;
        SetDlSrcAction setdlsrcaction = setdlsrccase.getSetDlSrcAction();
        if (version == 1) {
            ActionBuilder actionBuilder = new ActionBuilder();
            DlAddressActionBuilder dladdressactionbuilder = new DlAddressActionBuilder();
            dladdressactionbuilder.setDlAddress(setdlsrcaction.getAddress());
            actionBuilder.setType(SetDlSrc.class);
            actionBuilder.addAugmentation(DlAddressAction.class, (Augmentation)dladdressactionbuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        if (version >= 4) {
            OxmFieldsActionBuilder oxmFieldsActionBuilder = new OxmFieldsActionBuilder();
            ActionBuilder actionBuilder = new ActionBuilder();
            actionBuilder.setType(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField.class);
            ArrayList<MatchEntries> matchEntriesList = new ArrayList<MatchEntries>();
            matchEntriesList.add(MatchConvertorImpl.toOfMacAddress(EthSrc.class, setdlsrcaction.getAddress(), null));
            oxmFieldsActionBuilder.setMatchEntries(matchEntriesList);
            actionBuilder.addAugmentation(OxmFieldsAction.class, (Augmentation)oxmFieldsActionBuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        logger.error("Unknown Action Type for the Version", (Object)version);
        return null;
    }

    private static ActionsList SalToOFSetDlDst(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        SetDlDstActionCase setdldstcase = (SetDlDstActionCase)action;
        SetDlDstAction setdldstaction = setdldstcase.getSetDlDstAction();
        if (version == 1) {
            ActionBuilder actionBuilder = new ActionBuilder();
            DlAddressActionBuilder dladdressactionbuilder = new DlAddressActionBuilder();
            dladdressactionbuilder.setDlAddress(setdldstaction.getAddress());
            actionBuilder.setType(SetDlDst.class);
            actionBuilder.addAugmentation(DlAddressAction.class, (Augmentation)dladdressactionbuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        if (version >= 4) {
            OxmFieldsActionBuilder oxmFieldsActionBuilder = new OxmFieldsActionBuilder();
            ActionBuilder actionBuilder = new ActionBuilder();
            actionBuilder.setType(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField.class);
            ArrayList<MatchEntries> matchEntriesList = new ArrayList<MatchEntries>();
            matchEntriesList.add(MatchConvertorImpl.toOfMacAddress(EthDst.class, setdldstaction.getAddress(), null));
            oxmFieldsActionBuilder.setMatchEntries(matchEntriesList);
            actionBuilder.addAugmentation(OxmFieldsAction.class, (Augmentation)oxmFieldsActionBuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        logger.error("Unknown Action Type for the Version", (Object)version);
        return null;
    }

    private static ActionsList SalToOFSetNwSrc(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        SetNwSrcActionCase setnwsrccase = (SetNwSrcActionCase)action;
        SetNwSrcAction setnwsrcaction = setnwsrccase.getSetNwSrcAction();
        Ipv4 address_ipv4 = (Ipv4)setnwsrcaction.getAddress();
        if (version == 1) {
            ActionBuilder actionBuilder = new ActionBuilder();
            IpAddressActionBuilder ipvaddress = new IpAddressActionBuilder();
            Ipv4Address address = new Ipv4Address(address_ipv4.getIpv4Address().getValue());
            ipvaddress.setIpAddress(address);
            actionBuilder.setType(SetNwSrc.class);
            actionBuilder.addAugmentation(IpAddressAction.class, (Augmentation)ipvaddress.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        if (version >= 4) {
            OxmFieldsActionBuilder oxmFieldsActionBuilder = new OxmFieldsActionBuilder();
            ActionBuilder actionBuilder = new ActionBuilder();
            actionBuilder.setType(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField.class);
            ArrayList<MatchEntries> matchEntriesList = new ArrayList<MatchEntries>();
            String[] addressParts = address_ipv4.getIpv4Address().getValue().split(PREFIX_SEPARATOR);
            MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
            matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
            matchEntriesBuilder.setOxmMatchField(Ipv4Src.class);
            Ipv4Address ipv4Address = new Ipv4Address(addressParts[0]);
            Ipv4AddressMatchEntryBuilder ipv4AddressBuilder = new Ipv4AddressMatchEntryBuilder();
            ipv4AddressBuilder.setIpv4Address(ipv4Address);
            matchEntriesBuilder.addAugmentation(Ipv4AddressMatchEntry.class, (Augmentation)ipv4AddressBuilder.build());
            matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
            matchEntriesList.add(matchEntriesBuilder.build());
            oxmFieldsActionBuilder.setMatchEntries(matchEntriesList);
            actionBuilder.addAugmentation(OxmFieldsAction.class, (Augmentation)oxmFieldsActionBuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        logger.error("Unknown Action Type for the Version", (Object)version);
        return null;
    }

    private static ActionsList SalToOFSetNwDst(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        SetNwDstActionCase setnwdstcase = (SetNwDstActionCase)action;
        SetNwDstAction setnwdstaction = setnwdstcase.getSetNwDstAction();
        Ipv4 address_ipv4 = (Ipv4)setnwdstaction.getAddress();
        if (version == 1) {
            ActionBuilder actionBuilder = new ActionBuilder();
            IpAddressActionBuilder ipvaddress = new IpAddressActionBuilder();
            Ipv4Address address = new Ipv4Address(address_ipv4.getIpv4Address().getValue());
            ipvaddress.setIpAddress(address);
            actionBuilder.setType(SetNwDst.class);
            actionBuilder.addAugmentation(IpAddressAction.class, (Augmentation)ipvaddress.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        if (version >= 4) {
            OxmFieldsActionBuilder oxmFieldsActionBuilder = new OxmFieldsActionBuilder();
            ActionBuilder actionBuilder = new ActionBuilder();
            actionBuilder.setType(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField.class);
            ArrayList<MatchEntries> matchEntriesList = new ArrayList<MatchEntries>();
            String[] addressParts = address_ipv4.getIpv4Address().getValue().split(PREFIX_SEPARATOR);
            MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
            matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
            matchEntriesBuilder.setOxmMatchField(Ipv4Dst.class);
            Ipv4Address ipv4Address = new Ipv4Address(addressParts[0]);
            Ipv4AddressMatchEntryBuilder ipv4AddressBuilder = new Ipv4AddressMatchEntryBuilder();
            ipv4AddressBuilder.setIpv4Address(ipv4Address);
            matchEntriesBuilder.addAugmentation(Ipv4AddressMatchEntry.class, (Augmentation)ipv4AddressBuilder.build());
            matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
            matchEntriesList.add(matchEntriesBuilder.build());
            oxmFieldsActionBuilder.setMatchEntries(matchEntriesList);
            actionBuilder.addAugmentation(OxmFieldsAction.class, (Augmentation)oxmFieldsActionBuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        logger.error("Unknown Action Type for the Version", (Object)version);
        return null;
    }

    private static ActionsList SalToOFSetNwTos(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        SetNwTosActionCase setnwtoscase = (SetNwTosActionCase)action;
        SetNwTosAction setnwtosaction = setnwtoscase.getSetNwTosAction();
        if (version == 1) {
            ActionBuilder actionBuilder = new ActionBuilder();
            NwTosActionBuilder tosBuilder = new NwTosActionBuilder();
            tosBuilder.setNwTos(Short.valueOf(setnwtosaction.getTos().shortValue()));
            actionBuilder.addAugmentation(NwTosAction.class, (Augmentation)tosBuilder.build());
            actionBuilder.setType(SetNwTos.class);
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        if (version >= 4) {
            OxmFieldsActionBuilder oxmFieldsActionBuilder = new OxmFieldsActionBuilder();
            ActionBuilder actionBuilder = new ActionBuilder();
            actionBuilder.setType(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField.class);
            ArrayList<MatchEntries> matchEntriesList = new ArrayList<MatchEntries>();
            matchEntriesList.add(MatchConvertorImpl.toOfIpDscp(new Dscp(Short.valueOf(setnwtosaction.getTos().shortValue()))));
            oxmFieldsActionBuilder.setMatchEntries(matchEntriesList);
            actionBuilder.addAugmentation(OxmFieldsAction.class, (Augmentation)oxmFieldsActionBuilder.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        logger.error("Unknown Action Type for the Version", (Object)version);
        return null;
    }

    private static ActionsList SalToOFSetTpSrc(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        if (version == 1) {
            ActionBuilder actionBuilder = new ActionBuilder();
            SetTpSrcActionCase settpsrccase = (SetTpSrcActionCase)action;
            SetTpSrcAction settpsrcaction = settpsrccase.getSetTpSrcAction();
            PortActionBuilder settpsrc = new PortActionBuilder();
            PortNumber port = new PortNumber(Long.valueOf(settpsrcaction.getPort().getValue().longValue()));
            settpsrc.setPort(port);
            actionBuilder.setType(SetTpSrc.class);
            actionBuilder.addAugmentation(PortAction.class, (Augmentation)settpsrc.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        logger.error("Unknown Action Type for the Version", (Object)version);
        return null;
    }

    private static ActionsList SalToOFSetTpDst(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        if (version == 1) {
            ActionBuilder actionBuilder = new ActionBuilder();
            SetTpDstActionCase settpdstcase = (SetTpDstActionCase)action;
            SetTpDstAction settpdstaction = settpdstcase.getSetTpDstAction();
            PortActionBuilder settpdst = new PortActionBuilder();
            PortNumber port = new PortNumber(Long.valueOf(settpdstaction.getPort().getValue().longValue()));
            settpdst.setPort(port);
            actionBuilder.setType(SetTpDst.class);
            actionBuilder.addAugmentation(PortAction.class, (Augmentation)settpdst.build());
            actionsListBuilder.setAction(actionBuilder.build());
            return actionsListBuilder.build();
        }
        logger.error("Unknown Action Type for the Version", (Object)version);
        return null;
    }

    private static ActionsList SalToOFGroupAction(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        GroupActionCase groupActionCase = (GroupActionCase)action;
        GroupAction groupAction = groupActionCase.getGroupAction();
        GroupIdActionBuilder groupIdBuilder = new GroupIdActionBuilder();
        groupIdBuilder.setGroupId(groupAction.getGroupId());
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(Group.class);
        actionBuilder.addAugmentation(GroupIdAction.class, (Augmentation)groupIdBuilder.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList SalToOFPushAction(Integer ethernetType, ActionBuilder actionBuilder, ActionsListBuilder actionsListBuilder) {
        EthertypeActionBuilder ethertypeActionBuilder = new EthertypeActionBuilder();
        ethertypeActionBuilder.setEthertype(new EtherType(ethernetType));
        actionBuilder.addAugmentation(EthertypeAction.class, (Augmentation)ethertypeActionBuilder.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList SalToOFDecMplsTtl(ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(DecMplsTtl.class);
        return ActionConvertor.emtpyAction(actionBuilder, actionsListBuilder);
    }

    private static ActionsList SalToOFSetMplsTtl(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        SetMplsTtlActionCase mplsTtlActionCase = (SetMplsTtlActionCase)action;
        SetMplsTtlAction mplsTtlAction = mplsTtlActionCase.getSetMplsTtlAction();
        MplsTtlActionBuilder mplsTtlActionBuilder = new MplsTtlActionBuilder();
        mplsTtlActionBuilder.setMplsTtl(mplsTtlAction.getMplsTtl());
        actionBuilder.setType(SetMplsTtl.class);
        actionBuilder.addAugmentation(MplsTtlAction.class, (Augmentation)mplsTtlActionBuilder.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList SalToOFCopyTTLIIn(ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(CopyTtlIn.class);
        return ActionConvertor.emtpyAction(actionBuilder, actionsListBuilder);
    }

    private static ActionsList SalToOFCopyTTLIOut(ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(CopyTtlOut.class);
        return ActionConvertor.emtpyAction(actionBuilder, actionsListBuilder);
    }

    private static ActionsList emtpyAction(ActionBuilder actionBuilder, ActionsListBuilder actionsListBuilder) {
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList salToOFOutputAction(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action action, ActionsListBuilder actionsListBuilder, short version) {
        OutputActionCase outputActionCase = (OutputActionCase)action;
        OutputAction outputAction = outputActionCase.getOutputAction();
        PortActionBuilder portAction = new PortActionBuilder();
        MaxLengthActionBuilder maxLenActionBuilder = new MaxLengthActionBuilder();
        if (outputAction.getMaxLength() != null) {
            maxLenActionBuilder.setMaxLength(outputAction.getMaxLength());
        } else {
            maxLenActionBuilder.setMaxLength(new Integer(0));
        }
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.addAugmentation(MaxLengthAction.class, (Augmentation)maxLenActionBuilder.build());
        Uri uri = outputAction.getOutputNodeConnector();
        if (version >= 4) {
            if (uri.getValue().equals(OutputPortValues.CONTROLLER.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(BinContent.intToUnsignedLong((int)PortNumberValues.CONTROLLER.getIntValue()))));
            } else if (uri.getValue().equals(OutputPortValues.ALL.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(BinContent.intToUnsignedLong((int)PortNumberValues.ALL.getIntValue()))));
            } else if (uri.getValue().equals(OutputPortValues.ANY.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(BinContent.intToUnsignedLong((int)PortNumberValues.ANY.getIntValue()))));
            } else if (uri.getValue().equals(OutputPortValues.FLOOD.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(BinContent.intToUnsignedLong((int)PortNumberValues.FLOOD.getIntValue()))));
            } else if (uri.getValue().equals(OutputPortValues.INPORT.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(BinContent.intToUnsignedLong((int)PortNumberValues.INPORT.getIntValue()))));
            } else if (uri.getValue().equals(OutputPortValues.LOCAL.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(BinContent.intToUnsignedLong((int)PortNumberValues.LOCAL.getIntValue()))));
            } else if (uri.getValue().equals(OutputPortValues.NORMAL.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(BinContent.intToUnsignedLong((int)PortNumberValues.NORMAL.getIntValue()))));
            } else if (uri.getValue().equals(OutputPortValues.TABLE.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(BinContent.intToUnsignedLong((int)PortNumberValues.TABLE.getIntValue()))));
            } else if (uri.getValue().equals(OutputPortValues.NONE.toString())) {
                logger.error("Unknown Port Type for the Version");
            } else if (InventoryDataServiceUtil.portNumberfromNodeConnectorId(outputAction.getOutputNodeConnector().getValue()) < MAXPortOF13) {
                portAction.setPort(new PortNumber(InventoryDataServiceUtil.portNumberfromNodeConnectorId(outputAction.getOutputNodeConnector().getValue())));
            } else {
                logger.error("Invalid Port for Output Action");
            }
        } else if (version == 1) {
            if (uri.getValue().equals(OutputPortValues.CONTROLLER.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(PortNumberValuesV10.CONTROLLER.getIntValue())));
            } else if (uri.getValue().equals(OutputPortValues.ALL.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(PortNumberValuesV10.ALL.getIntValue())));
            } else if (uri.getValue().equals(OutputPortValues.FLOOD.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(PortNumberValuesV10.FLOOD.getIntValue())));
            } else if (uri.getValue().equals(OutputPortValues.INPORT.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(PortNumberValuesV10.INPORT.getIntValue())));
            } else if (uri.getValue().equals(OutputPortValues.LOCAL.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(PortNumberValuesV10.LOCAL.getIntValue())));
            } else if (uri.getValue().equals(OutputPortValues.NORMAL.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(PortNumberValuesV10.NORMAL.getIntValue())));
            } else if (uri.getValue().equals(OutputPortValues.TABLE.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(PortNumberValuesV10.TABLE.getIntValue())));
            } else if (uri.getValue().equals(OutputPortValues.NONE.toString())) {
                portAction.setPort(new PortNumber(Long.valueOf(PortNumberValuesV10.NONE.getIntValue())));
            } else if (uri.getValue().equals(OutputPortValues.ANY.toString())) {
                logger.error("Unknown Port Type for the Version");
            } else if (InventoryDataServiceUtil.portNumberfromNodeConnectorId(outputAction.getOutputNodeConnector().getValue()) < MAXPortOF10) {
                portAction.setPort(new PortNumber(InventoryDataServiceUtil.portNumberfromNodeConnectorId(outputAction.getOutputNodeConnector().getValue())));
            } else {
                logger.error("Invalid Port for Output Action");
            }
        }
        actionBuilder.setType(Output.class);
        actionBuilder.addAugmentation(PortAction.class, (Augmentation)portAction.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    public static List<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action> toMDSalActions(List<ActionsList> actionList) {
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action> bucketActions = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action>();
        for (ActionsList actionDesc : actionList) {
            Action action = actionDesc.getAction();
            if (action.getType().equals(Output.class)) {
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)ActionConvertor.ofToSALOutputAction(action));
                continue;
            }
            if (action.getType().equals(Group.class)) {
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)ActionConvertor.ofToSALGroupAction(action));
                continue;
            }
            if (action.getType().equals(CopyTtlOut.class)) {
                CopyTtlOutBuilder copyTtlOutaction = new CopyTtlOutBuilder();
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)new CopyTtlOutCaseBuilder().setCopyTtlOut(copyTtlOutaction.build()).build());
                continue;
            }
            if (action.getType().equals(CopyTtlIn.class)) {
                CopyTtlInBuilder copyTtlInaction = new CopyTtlInBuilder();
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)new CopyTtlInCaseBuilder().setCopyTtlIn(copyTtlInaction.build()).build());
                continue;
            }
            if (action.getType().equals(SetMplsTtl.class)) {
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)ActionConvertor.ofToSALSetMplsTtl(action));
                continue;
            }
            if (action.getType().equals(DecMplsTtl.class)) {
                DecMplsTtlBuilder decMplsTtl = new DecMplsTtlBuilder();
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)new DecMplsTtlCaseBuilder().setDecMplsTtl(decMplsTtl.build()).build());
                continue;
            }
            if (action.getType().equals(PushVlan.class)) {
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)ActionConvertor.ofToSALPushVlanAction(action));
                continue;
            }
            if (action.getType().equals(PopVlan.class)) {
                PopVlanActionBuilder popVlan = new PopVlanActionBuilder();
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)new PopVlanActionCaseBuilder().setPopVlanAction(popVlan.build()).build());
                continue;
            }
            if (action.getType().equals(PushMpls.class)) {
                PushMplsActionBuilder pushMpls = new PushMplsActionBuilder();
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)new PushMplsActionCaseBuilder().setPushMplsAction(pushMpls.build()).build());
                continue;
            }
            if (action.getType().equals(PopMpls.class)) {
                PopMplsActionBuilder popMpls = new PopMplsActionBuilder();
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)new PopMplsActionCaseBuilder().setPopMplsAction(popMpls.build()).build());
                continue;
            }
            if (action.getType().equals(SetQueue.class)) {
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)ActionConvertor.ofToSALSetQueue(action));
                continue;
            }
            if (action.getType().equals(SetNwTtl.class)) {
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)ActionConvertor.ofToSALSetNwTtl(action));
                continue;
            }
            if (action.getType().equals(DecNwTtl.class)) {
                DecNwTtlBuilder decNwTtl = new DecNwTtlBuilder();
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)new DecNwTtlCaseBuilder().setDecNwTtl(decNwTtl.build()).build());
                continue;
            }
            if (action.getType().equals(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField.class)) {
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)new SetFieldCaseBuilder().setSetField(MatchConvertorImpl.ofToSALSetField(action)).build());
                continue;
            }
            if (action.getType().equals(PushPbb.class)) {
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)ActionConvertor.ofToSALPushPbbAction(action));
                continue;
            }
            if (action.getType().equals(PopPbb.class)) {
                PopPbbActionBuilder popPbb = new PopPbbActionBuilder();
                bucketActions.add((org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action)new PopPbbActionCaseBuilder().setPopPbbAction(popPbb.build()).build());
                continue;
            }
            if (!action.getType().equals(Experimenter.class)) continue;
        }
        return bucketActions;
    }

    public static OutputActionCase ofToSALOutputAction(Action action) {
        OutputActionBuilder outputAction = new OutputActionBuilder();
        PortAction port = (PortAction)action.getAugmentation(PortAction.class);
        if (port != null) {
            outputAction.setOutputNodeConnector(new Uri(port.getPort().getValue().toString()));
        } else {
            logger.error("Provided action is not OF Output action, no associated port found!");
        }
        MaxLengthAction length = (MaxLengthAction)action.getAugmentation(MaxLengthAction.class);
        if (length != null) {
            outputAction.setMaxLength(length.getMaxLength());
        } else {
            logger.error("Provided action is not OF Output action, no associated length found!");
        }
        return new OutputActionCaseBuilder().setOutputAction(outputAction.build()).build();
    }

    public static GroupActionCase ofToSALGroupAction(Action action) {
        GroupActionBuilder groupAction = new GroupActionBuilder();
        GroupIdAction groupId = (GroupIdAction)action.getAugmentation(GroupIdAction.class);
        groupAction.setGroupId(groupId.getGroupId());
        return new GroupActionCaseBuilder().setGroupAction(groupAction.build()).build();
    }

    public static SetMplsTtlActionCase ofToSALSetMplsTtl(Action action) {
        SetMplsTtlActionBuilder mplsTtlAction = new SetMplsTtlActionBuilder();
        MplsTtlAction mplsTtl = (MplsTtlAction)action.getAugmentation(MplsTtlAction.class);
        mplsTtlAction.setMplsTtl(mplsTtl.getMplsTtl());
        return new SetMplsTtlActionCaseBuilder().setSetMplsTtlAction(mplsTtlAction.build()).build();
    }

    public static PushVlanActionCase ofToSALPushVlanAction(Action action) {
        PushVlanActionBuilder pushVlanAction = new PushVlanActionBuilder();
        EthertypeAction etherType = (EthertypeAction)action.getAugmentation(EthertypeAction.class);
        pushVlanAction.setVlanId(new VlanId(etherType.getEthertype().getValue()));
        return new PushVlanActionCaseBuilder().setPushVlanAction(pushVlanAction.build()).build();
    }

    public static SetQueueActionCase ofToSALSetQueue(Action action) {
        SetQueueActionBuilder setQueueAction = new SetQueueActionBuilder();
        QueueIdAction queueId = (QueueIdAction)action.getAugmentation(QueueIdAction.class);
        setQueueAction.setQueueId(queueId.getQueueId());
        return new SetQueueActionCaseBuilder().setSetQueueAction(setQueueAction.build()).build();
    }

    public static SetNwTtlActionCase ofToSALSetNwTtl(Action action) {
        SetNwTtlActionBuilder setNwTtl = new SetNwTtlActionBuilder();
        NwTtlAction nwTtl = (NwTtlAction)action.getAugmentation(NwTtlAction.class);
        setNwTtl.setNwTtl(nwTtl.getNwTtl());
        return new SetNwTtlActionCaseBuilder().setSetNwTtlAction(setNwTtl.build()).build();
    }

    public static PushPbbActionCase ofToSALPushPbbAction(Action action) {
        PushPbbActionBuilder pushPbbAction = new PushPbbActionBuilder();
        EthertypeAction etherType = (EthertypeAction)action.getAugmentation(EthertypeAction.class);
        pushPbbAction.setEthernetType(etherType.getEthertype().getValue());
        return new PushPbbActionCaseBuilder().setPushPbbAction(pushPbbAction.build()).build();
    }

    public static Object ofToSALExperimenter(Action action) {
        ExperimenterAction ExperimenterAction2 = (ExperimenterAction)action.getAugmentation(ExperimenterAction.class);
        return null;
    }
}

