/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.openflowplugin.openflow.md.core.sal.BuildSwitchCapabilitiesOF10;
import org.opendaylight.openflowplugin.openflow.md.core.sal.BuildSwitchCapabilitiesOF13;
import org.opendaylight.openflowplugin.openflow.md.core.sal.BuildSwitchFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchFeaturesUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(SwitchFeaturesUtil.class);
    private static SwitchFeaturesUtil instance = new SwitchFeaturesUtil();
    private Map<Short, BuildSwitchFeatures> swFeaturesBuilders = new HashMap<Short, BuildSwitchFeatures>();

    private SwitchFeaturesUtil() {
        this.swFeaturesBuilders.put((short)1, BuildSwitchCapabilitiesOF10.getInstance());
        this.swFeaturesBuilders.put((short)4, BuildSwitchCapabilitiesOF13.getInstance());
    }

    public static SwitchFeaturesUtil getInstance() {
        return instance;
    }

    public SwitchFeatures buildSwitchFeatures(GetFeaturesOutput features) {
        if (this.swFeaturesBuilders.containsKey(features.getVersion())) {
            LOG.debug("map contains version {}", (Object)features.getVersion());
            try {
                return this.swFeaturesBuilders.get(features.getVersion()).build(features);
            }
            catch (NullPointerException e) {
                LOG.error("error while building switch features {}", (Throwable)e);
            }
        } else {
            LOG.warn("unknown version: {}", (Object)features.getVersion());
        }
        return null;
    }
}

