/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal;

import java.util.Collection;
import java.util.Collections;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.openflowjava.protocol.spi.connection.SwitchConnectionProvider;
import org.opendaylight.openflowplugin.openflow.md.core.MDController;
import org.opendaylight.openflowplugin.openflow.md.core.cmd.MessageCountCommandProvider;
import org.opendaylight.openflowplugin.openflow.md.core.sal.SalRegistrationManager;
import org.opendaylight.openflowplugin.openflow.md.queue.MessageObservatory;
import org.opendaylight.openflowplugin.openflow.md.queue.MessageSpyCounterImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.osgi.framework.BundleContext;

public class OpenflowPluginProvider
implements BindingAwareProvider,
AutoCloseable {
    private BindingAwareBroker broker;
    private BundleContext context;
    private SwitchConnectionProvider switchConnectionProvider;
    private MDController mdController;
    private MessageCountCommandProvider messageCountCommandProvider;
    private MessageObservatory<OfHeader, DataObject> messageCountProvider;
    SalRegistrationManager registrationManager = new SalRegistrationManager();

    public void unsetSwitchConnectionProvider() {
        this.switchConnectionProvider = null;
    }

    public void setSwitchConnectionProvider(SwitchConnectionProvider switchConnectionProvider) {
        this.switchConnectionProvider = switchConnectionProvider;
        this.registerProvider();
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        this.messageCountProvider = new MessageSpyCounterImpl();
        this.registrationManager.onSessionInitiated(session);
        this.mdController = new MDController();
        this.mdController.setSwitchConnectionProvider(this.switchConnectionProvider);
        this.mdController.setMessageSpyCounter(this.messageCountProvider);
        this.mdController.init();
        this.mdController.start();
        this.messageCountCommandProvider = new MessageCountCommandProvider(this.context, this.messageCountProvider);
        this.messageCountCommandProvider.onSessionInitiated(session);
    }

    @Override
    public void close() {
        this.mdController.stop();
    }

    public void onSessionInitialized(BindingAwareBroker.ConsumerContext session) {
    }

    public Collection<? extends BindingAwareProvider.ProviderFunctionality> getFunctionality() {
        return Collections.emptySet();
    }

    public Collection<? extends RpcService> getImplementations() {
        return Collections.emptySet();
    }

    public BindingAwareBroker getBroker() {
        return this.broker;
    }

    public void setBroker(BindingAwareBroker broker) {
        this.broker = broker;
        this.registerProvider();
    }

    public void unsetBroker(BindingAwareBroker broker) {
        this.broker = null;
    }

    private boolean hasAllDependencies() {
        return this.broker != null && this.switchConnectionProvider != null;
    }

    private void registerProvider() {
        if (this.hasAllDependencies()) {
            this.broker.registerProvider((BindingAwareProvider)this, this.context);
        }
    }
}

