/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.Futures;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.openflowjava.protocol.api.util.BinContent;
import org.opendaylight.openflowplugin.openflow.md.OFConstants;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.sal.AbstractModelDrivenSwitch;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.FlowConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.GroupConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.MeterConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.PacketOutConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.PortConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.TableFeaturesConvertor;
import org.opendaylight.openflowplugin.openflow.md.core.sal.convertor.match.MatchReactor;
import org.opendaylight.openflowplugin.openflow.md.core.session.IMessageDispatchService;
import org.opendaylight.openflowplugin.openflow.md.core.session.OFSessionUtil;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.openflowplugin.openflow.md.util.FlowCreatorUtil;
import org.opendaylight.openflowplugin.openflow.md.util.InventoryDataServiceUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowAddedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForAllFlowsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForAllFlowsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForAllFlowsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForGivenMatchInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForGivenMatchOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForGivenMatchOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowStatisticsFromFlowTableInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowStatisticsFromFlowTableOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowStatisticsFromFlowTableOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetFlowStatisticsFromFlowTableInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetFlowStatisticsFromFlowTableOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetFlowStatisticsFromFlowTableOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.GetFlowTablesStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.GetFlowTablesStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.GetFlowTablesStatisticsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.port.mod.port.Port;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.AddGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.AddGroupOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.AddGroupOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupAddedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.RemoveGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.RemoveGroupOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.RemoveGroupOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.UpdateGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.UpdateGroupOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.UpdateGroupOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetAllGroupStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetAllGroupStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetAllGroupStatisticsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupDescriptionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupDescriptionOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupDescriptionOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupFeaturesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupFeaturesOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupStatisticsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.AddMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.AddMeterOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.AddMeterOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.MeterAddedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.MeterRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.MeterUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.RemoveMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.RemoveMeterOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.RemoveMeterOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.UpdateMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.UpdateMeterOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.UpdateMeterOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterConfigStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterConfigStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterConfigStatisticsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterStatisticsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetMeterFeaturesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetMeterFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetMeterFeaturesOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetMeterStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetMeterStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetMeterStatisticsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterConfigCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.aggregate._case.MultipartRequestAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.group._case.MultipartRequestGroupBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter._case.MultipartRequestMeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter.config._case.MultipartRequestMeterConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.stats._case.MultipartRequestPortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case.MultipartRequestQueueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table._case.MultipartRequestTableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.MultipartRequestTableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacketInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.GetPortOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.UpdatePortInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.UpdatePortOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.UpdatePortOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetAllNodeConnectorsStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetAllNodeConnectorsStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetAllNodeConnectorsStatisticsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetNodeConnectorStatisticsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetNodeConnectorStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetNodeConnectorStatisticsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetAllQueuesStatisticsFromAllPortsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetAllQueuesStatisticsFromAllPortsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetAllQueuesStatisticsFromAllPortsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetAllQueuesStatisticsFromGivenPortInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetAllQueuesStatisticsFromGivenPortOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetAllQueuesStatisticsFromGivenPortOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetQueueStatisticsFromGivenPortInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetQueueStatisticsFromGivenPortOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetQueueStatisticsFromGivenPortOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.UpdateTableInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.UpdateTableOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.UpdateTableOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelDrivenSwitchImpl
extends AbstractModelDrivenSwitch {
    private static final Logger LOG = LoggerFactory.getLogger(ModelDrivenSwitchImpl.class);
    private final NodeId nodeId;
    private final IMessageDispatchService messageService;
    private short version = 0;
    private SessionContext session;
    NotificationProviderService rpcNotificationProviderService;

    protected ModelDrivenSwitchImpl(NodeId nodeId, InstanceIdentifier<Node> identifier, SessionContext context) {
        super(identifier, context);
        this.nodeId = nodeId;
        this.messageService = this.sessionContext.getMessageDispatchService();
        this.version = context.getPrimaryConductor().getVersion();
        this.session = context;
        this.rpcNotificationProviderService = OFSessionUtil.getSessionManager().getNotificationProviderService();
    }

    @Override
    public Future<RpcResult<AddFlowOutput>> addFlow(AddFlowInput input) {
        LOG.debug("Calling the FlowMod RPC method on MessageDispatchService");
        Long xId = null;
        SwitchConnectionDistinguisher cookie = null;
        if (((Boolean)Objects.firstNonNull((Object)input.isBarrier(), (Object)Boolean.FALSE)).booleanValue()) {
            xId = this.session.getNextXid();
            BarrierInputBuilder barrierInput = new BarrierInputBuilder();
            barrierInput.setVersion(Short.valueOf(this.version));
            barrierInput.setXid(xId);
            Future<RpcResult<BarrierOutput>> barrierOFLib = this.messageService.barrier(barrierInput.build(), cookie);
        }
        FlowModInputBuilder ofFlowModInput = FlowConvertor.toFlowModInput((Flow)input, this.version, this.getSessionContext().getFeatures().getDatapathId());
        xId = this.session.getNextXid();
        ofFlowModInput.setXid(xId);
        if (null != this.rpcNotificationProviderService) {
            FlowAddedBuilder newFlow = new FlowAddedBuilder((Flow)input);
            newFlow.setTransactionId(new TransactionId(BigInteger.valueOf(xId.intValue())));
            newFlow.setFlowRef(input.getFlowRef());
            this.rpcNotificationProviderService.publish((Notification)newFlow.build());
        }
        Future<RpcResult<UpdateFlowOutput>> resultFromOFLib = this.messageService.flowMod(ofFlowModInput.build(), cookie);
        RpcResult<UpdateFlowOutput> rpcResultFromOFLib = null;
        try {
            rpcResultFromOFLib = resultFromOFLib.get();
        }
        catch (Exception ex) {
            LOG.error(" Error while getting result for AddFlow RPC" + ex.getMessage());
        }
        UpdateFlowOutput updateFlowOutput = (UpdateFlowOutput)rpcResultFromOFLib.getResult();
        AddFlowOutputBuilder addFlowOutput = new AddFlowOutputBuilder();
        addFlowOutput.setTransactionId(updateFlowOutput.getTransactionId());
        AddFlowOutput result = addFlowOutput.build();
        Collection errors = rpcResultFromOFLib.getErrors();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, (Collection)errors);
        LOG.debug("Returning the Add Flow RPC result to MD-SAL");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<AddGroupOutput>> addGroup(AddGroupInput input) {
        LOG.debug("Calling the GroupMod RPC method on MessageDispatchService");
        Long xId = null;
        SwitchConnectionDistinguisher cookie = null;
        if (((Boolean)Objects.firstNonNull((Object)input.isBarrier(), (Object)Boolean.FALSE)).booleanValue()) {
            xId = this.session.getNextXid();
            BarrierInputBuilder barrierInput = new BarrierInputBuilder();
            barrierInput.setVersion(Short.valueOf(this.version));
            barrierInput.setXid(xId);
            Future<RpcResult<BarrierOutput>> barrierOFLib = this.messageService.barrier(barrierInput.build(), cookie);
        }
        GroupModInputBuilder ofGroupModInput = GroupConvertor.toGroupModInput((Group)input, this.version, this.getSessionContext().getFeatures().getDatapathId());
        xId = this.session.getNextXid();
        ofGroupModInput.setXid(xId);
        if (null != this.rpcNotificationProviderService) {
            GroupAddedBuilder groupMod = new GroupAddedBuilder((Group)input);
            groupMod.setTransactionId(new TransactionId(BigInteger.valueOf(xId.intValue())));
            groupMod.setGroupRef(input.getGroupRef());
            this.rpcNotificationProviderService.publish((Notification)groupMod.build());
        }
        Future<RpcResult<UpdateGroupOutput>> resultFromOFLib = this.messageService.groupMod(ofGroupModInput.build(), cookie);
        RpcResult<UpdateGroupOutput> rpcResultFromOFLib = null;
        try {
            rpcResultFromOFLib = resultFromOFLib.get();
        }
        catch (Exception ex) {
            LOG.error(" Error while getting result for AddGroup RPC" + ex.getMessage());
        }
        UpdateGroupOutput updateGroupOutput = (UpdateGroupOutput)rpcResultFromOFLib.getResult();
        AddGroupOutputBuilder addGroupOutput = new AddGroupOutputBuilder();
        addGroupOutput.setTransactionId(updateGroupOutput.getTransactionId());
        AddGroupOutput result = addGroupOutput.build();
        Collection errors = rpcResultFromOFLib.getErrors();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, (Collection)errors);
        LOG.debug("Returning the Add Group RPC result to MD-SAL");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<AddMeterOutput>> addMeter(AddMeterInput input) {
        LOG.debug("Calling the MeterMod RPC method on MessageDispatchService");
        Long xId = null;
        SwitchConnectionDistinguisher cookie = null;
        if (((Boolean)Objects.firstNonNull((Object)input.isBarrier(), (Object)Boolean.FALSE)).booleanValue()) {
            xId = this.session.getNextXid();
            BarrierInputBuilder barrierInput = new BarrierInputBuilder();
            barrierInput.setVersion(Short.valueOf(this.version));
            barrierInput.setXid(xId);
            Future<RpcResult<BarrierOutput>> barrierOFLib = this.messageService.barrier(barrierInput.build(), cookie);
        }
        MeterModInputBuilder ofMeterModInput = MeterConvertor.toMeterModInput((Meter)input, this.version);
        xId = this.session.getNextXid();
        ofMeterModInput.setXid(xId);
        if (null != this.rpcNotificationProviderService) {
            MeterAddedBuilder meterMod = new MeterAddedBuilder((Meter)input);
            meterMod.setTransactionId(new TransactionId(BigInteger.valueOf(xId.intValue())));
            meterMod.setMeterRef(input.getMeterRef());
            this.rpcNotificationProviderService.publish((Notification)meterMod.build());
        }
        Future<RpcResult<UpdateMeterOutput>> resultFromOFLib = this.messageService.meterMod(ofMeterModInput.build(), cookie);
        RpcResult<UpdateMeterOutput> rpcResultFromOFLib = null;
        try {
            rpcResultFromOFLib = resultFromOFLib.get();
        }
        catch (Exception ex) {
            LOG.error(" Error while getting result for AddMeter RPC" + ex.getMessage());
        }
        UpdateMeterOutput updateMeterOutput = (UpdateMeterOutput)rpcResultFromOFLib.getResult();
        AddMeterOutputBuilder addMeterOutput = new AddMeterOutputBuilder();
        addMeterOutput.setTransactionId(updateMeterOutput.getTransactionId());
        AddMeterOutput result = addMeterOutput.build();
        Collection errors = rpcResultFromOFLib.getErrors();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, (Collection)errors);
        LOG.debug("Returning the Add Meter RPC result to MD-SAL");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<RemoveFlowOutput>> removeFlow(RemoveFlowInput input) {
        LOG.debug("Calling the removeFlow RPC method on MessageDispatchService");
        Long xId = null;
        SwitchConnectionDistinguisher cookie = null;
        if (((Boolean)Objects.firstNonNull((Object)input.isBarrier(), (Object)Boolean.FALSE)).booleanValue()) {
            BarrierInputBuilder barrierInput = new BarrierInputBuilder();
            xId = this.session.getNextXid();
            barrierInput.setXid(xId);
            barrierInput.setVersion(Short.valueOf(this.version));
            Future<RpcResult<BarrierOutput>> barrierOFLib = this.messageService.barrier(barrierInput.build(), cookie);
        }
        FlowModInputBuilder ofFlowModInput = FlowConvertor.toFlowModInput((Flow)input, this.version, this.getSessionContext().getFeatures().getDatapathId());
        xId = this.session.getNextXid();
        ofFlowModInput.setXid(xId);
        if (null != this.rpcNotificationProviderService) {
            FlowRemovedBuilder removeFlow = new FlowRemovedBuilder((Flow)input);
            removeFlow.setTransactionId(new TransactionId(BigInteger.valueOf(xId.intValue())));
            removeFlow.setFlowRef(input.getFlowRef());
            this.rpcNotificationProviderService.publish((Notification)removeFlow.build());
        }
        Future<RpcResult<UpdateFlowOutput>> resultFromOFLib = this.messageService.flowMod(ofFlowModInput.build(), cookie);
        RpcResult<UpdateFlowOutput> rpcResultFromOFLib = null;
        try {
            rpcResultFromOFLib = resultFromOFLib.get();
        }
        catch (Exception ex) {
            LOG.error(" Error while getting result for remove Flow RPC" + ex.getMessage());
        }
        UpdateFlowOutput updateFlowOutput = (UpdateFlowOutput)rpcResultFromOFLib.getResult();
        RemoveFlowOutputBuilder removeFlowOutput = new RemoveFlowOutputBuilder();
        removeFlowOutput.setTransactionId(updateFlowOutput.getTransactionId());
        RemoveFlowOutput result = removeFlowOutput.build();
        Collection errors = rpcResultFromOFLib.getErrors();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, (Collection)errors);
        LOG.debug("Returning the Remove Flow RPC result to MD-SAL");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<RemoveGroupOutput>> removeGroup(RemoveGroupInput input) {
        LOG.debug("Calling the Remove Group RPC method on MessageDispatchService");
        Long xId = null;
        SwitchConnectionDistinguisher cookie = null;
        if (((Boolean)Objects.firstNonNull((Object)input.isBarrier(), (Object)Boolean.FALSE)).booleanValue()) {
            xId = this.session.getNextXid();
            BarrierInputBuilder barrierInput = new BarrierInputBuilder();
            barrierInput.setVersion(Short.valueOf(this.version));
            barrierInput.setXid(xId);
            Future<RpcResult<BarrierOutput>> barrierOFLib = this.messageService.barrier(barrierInput.build(), cookie);
        }
        GroupModInputBuilder ofGroupModInput = GroupConvertor.toGroupModInput((Group)input, this.version, this.getSessionContext().getFeatures().getDatapathId());
        xId = this.session.getNextXid();
        ofGroupModInput.setXid(xId);
        if (null != this.rpcNotificationProviderService) {
            GroupRemovedBuilder groupMod = new GroupRemovedBuilder((Group)input);
            groupMod.setTransactionId(new TransactionId(BigInteger.valueOf(xId.intValue())));
            groupMod.setGroupRef(input.getGroupRef());
            this.rpcNotificationProviderService.publish((Notification)groupMod.build());
        }
        Future<RpcResult<UpdateGroupOutput>> resultFromOFLib = this.messageService.groupMod(ofGroupModInput.build(), cookie);
        RpcResult<UpdateGroupOutput> rpcResultFromOFLib = null;
        try {
            rpcResultFromOFLib = resultFromOFLib.get();
        }
        catch (Exception ex) {
            LOG.error(" Error while getting result for RemoveGroup RPC" + ex.getMessage());
        }
        UpdateGroupOutput updateGroupOutput = (UpdateGroupOutput)rpcResultFromOFLib.getResult();
        RemoveGroupOutputBuilder removeGroupOutput = new RemoveGroupOutputBuilder();
        removeGroupOutput.setTransactionId(updateGroupOutput.getTransactionId());
        RemoveGroupOutput result = removeGroupOutput.build();
        Collection errors = rpcResultFromOFLib.getErrors();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, (Collection)errors);
        LOG.debug("Returning the Remove Group RPC result to MD-SAL");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<RemoveMeterOutput>> removeMeter(RemoveMeterInput input) {
        LOG.debug("Calling the Remove MeterMod RPC method on MessageDispatchService");
        Long xId = null;
        SwitchConnectionDistinguisher cookie = null;
        if (((Boolean)Objects.firstNonNull((Object)input.isBarrier(), (Object)Boolean.FALSE)).booleanValue()) {
            xId = this.session.getNextXid();
            BarrierInputBuilder barrierInput = new BarrierInputBuilder();
            barrierInput.setVersion(Short.valueOf(this.version));
            barrierInput.setXid(xId);
            Future<RpcResult<BarrierOutput>> barrierOFLib = this.messageService.barrier(barrierInput.build(), cookie);
        }
        MeterModInputBuilder ofMeterModInput = MeterConvertor.toMeterModInput((Meter)input, this.version);
        xId = this.session.getNextXid();
        ofMeterModInput.setXid(xId);
        if (null != this.rpcNotificationProviderService) {
            MeterRemovedBuilder meterMod = new MeterRemovedBuilder((Meter)input);
            meterMod.setTransactionId(new TransactionId(BigInteger.valueOf(xId.intValue())));
            meterMod.setMeterRef(input.getMeterRef());
            this.rpcNotificationProviderService.publish((Notification)meterMod.build());
        }
        Future<RpcResult<UpdateMeterOutput>> resultFromOFLib = this.messageService.meterMod(ofMeterModInput.build(), cookie);
        RpcResult<UpdateMeterOutput> rpcResultFromOFLib = null;
        try {
            rpcResultFromOFLib = resultFromOFLib.get();
        }
        catch (Exception ex) {
            LOG.error(" Error while getting result for RemoveMeter RPC" + ex.getMessage());
        }
        UpdateMeterOutput updatemeterOutput = (UpdateMeterOutput)rpcResultFromOFLib.getResult();
        RemoveMeterOutputBuilder removeMeterOutput = new RemoveMeterOutputBuilder();
        removeMeterOutput.setTransactionId(updatemeterOutput.getTransactionId());
        RemoveMeterOutput result = removeMeterOutput.build();
        Collection errors = rpcResultFromOFLib.getErrors();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, (Collection)errors);
        LOG.debug("Returning the Remove Meter RPC result to MD-SAL");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<Void>> transmitPacket(TransmitPacketInput input) {
        LOG.debug("TransmitPacket - {}", (Object)input);
        PacketOutInput message = PacketOutConvertor.toPacketOutInput(input, this.version, this.sessionContext.getNextXid());
        SwitchConnectionDistinguisher cookie = null;
        LOG.debug("Calling the transmitPacket RPC method");
        return this.messageService.packetOut(message, cookie);
    }

    private FlowModInputBuilder toFlowModInputBuilder(Flow source) {
        FlowModInputBuilder target = new FlowModInputBuilder();
        target.setCookie(source.getCookie());
        target.setIdleTimeout(source.getIdleTimeout());
        target.setHardTimeout(source.getHardTimeout());
        target.setMatch(this.toMatch(source.getMatch()));
        return target;
    }

    private org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match toMatch(Match match) {
        MatchBuilder target = new MatchBuilder();
        target.setMatchEntries(this.toMatchEntries(match));
        return null;
    }

    private List<MatchEntries> toMatchEntries(Match match) {
        ArrayList entries = new ArrayList();
        return null;
    }

    @Override
    public Future<RpcResult<UpdateFlowOutput>> updateFlow(UpdateFlowInput input) {
        LOG.debug("Calling the updateFlow RPC method on MessageDispatchService");
        Long xId = null;
        SwitchConnectionDistinguisher cookie = null;
        if (((Boolean)Objects.firstNonNull((Object)input.getUpdatedFlow().isBarrier(), (Object)Boolean.FALSE)).booleanValue()) {
            BarrierInputBuilder barrierInput = new BarrierInputBuilder();
            xId = this.session.getNextXid();
            barrierInput.setVersion(Short.valueOf(this.version));
            barrierInput.setXid(xId);
            Future<RpcResult<BarrierOutput>> barrierOFLib = this.messageService.barrier(barrierInput.build(), cookie);
        }
        FlowModInputBuilder ofFlowModInput = FlowConvertor.toFlowModInput((Flow)input.getUpdatedFlow(), this.version, this.getSessionContext().getFeatures().getDatapathId());
        xId = this.session.getNextXid();
        ofFlowModInput.setXid(xId);
        if (null != this.rpcNotificationProviderService) {
            FlowUpdatedBuilder updateFlow = new FlowUpdatedBuilder((Flow)input.getUpdatedFlow());
            updateFlow.setTransactionId(new TransactionId(BigInteger.valueOf(xId.intValue())));
            updateFlow.setFlowRef(input.getFlowRef());
            this.rpcNotificationProviderService.publish((Notification)updateFlow.build());
        }
        Future<RpcResult<UpdateFlowOutput>> resultFromOFLib = this.messageService.flowMod(ofFlowModInput.build(), cookie);
        RpcResult<UpdateFlowOutput> rpcResultFromOFLib = null;
        try {
            rpcResultFromOFLib = resultFromOFLib.get();
        }
        catch (Exception ex) {
            LOG.error(" Error while getting result for UpdateFlow RPC" + ex.getMessage());
        }
        UpdateFlowOutput updateFlowOutputOFLib = (UpdateFlowOutput)rpcResultFromOFLib.getResult();
        UpdateFlowOutputBuilder updateFlowOutput = new UpdateFlowOutputBuilder();
        updateFlowOutput.setTransactionId(updateFlowOutputOFLib.getTransactionId());
        UpdateFlowOutput result = updateFlowOutput.build();
        Collection errors = rpcResultFromOFLib.getErrors();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, (Collection)errors);
        LOG.debug("Returning the Update Flow RPC result to MD-SAL");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<UpdateGroupOutput>> updateGroup(UpdateGroupInput input) {
        LOG.debug("Calling the update Group Mod RPC method on MessageDispatchService");
        Long xId = null;
        SwitchConnectionDistinguisher cookie = null;
        if (((Boolean)Objects.firstNonNull((Object)input.getUpdatedGroup().isBarrier(), (Object)Boolean.FALSE)).booleanValue()) {
            xId = this.session.getNextXid();
            BarrierInputBuilder barrierInput = new BarrierInputBuilder();
            barrierInput.setVersion(Short.valueOf(this.version));
            barrierInput.setXid(xId);
            Future<RpcResult<BarrierOutput>> barrierOFLib = this.messageService.barrier(barrierInput.build(), cookie);
        }
        GroupModInputBuilder ofGroupModInput = GroupConvertor.toGroupModInput((Group)input.getUpdatedGroup(), this.version, this.getSessionContext().getFeatures().getDatapathId());
        xId = this.session.getNextXid();
        ofGroupModInput.setXid(xId);
        if (null != this.rpcNotificationProviderService) {
            GroupUpdatedBuilder groupMod = new GroupUpdatedBuilder((Group)input.getUpdatedGroup());
            groupMod.setTransactionId(new TransactionId(BigInteger.valueOf(xId.intValue())));
            groupMod.setGroupRef(input.getGroupRef());
            this.rpcNotificationProviderService.publish((Notification)groupMod.build());
        }
        Future<RpcResult<UpdateGroupOutput>> resultFromOFLib = this.messageService.groupMod(ofGroupModInput.build(), cookie);
        RpcResult<UpdateGroupOutput> rpcResultFromOFLib = null;
        try {
            rpcResultFromOFLib = resultFromOFLib.get();
        }
        catch (Exception ex) {
            LOG.error(" Error while getting result for updateGroup RPC" + ex.getMessage());
        }
        UpdateGroupOutput updateGroupOutputOFLib = (UpdateGroupOutput)rpcResultFromOFLib.getResult();
        UpdateGroupOutputBuilder updateGroupOutput = new UpdateGroupOutputBuilder();
        updateGroupOutput.setTransactionId(updateGroupOutputOFLib.getTransactionId());
        UpdateGroupOutput result = updateGroupOutput.build();
        Collection errors = rpcResultFromOFLib.getErrors();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, (Collection)errors);
        LOG.debug("Returning the Update Group RPC result to MD-SAL");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<UpdateMeterOutput>> updateMeter(UpdateMeterInput input) {
        LOG.debug("Calling the MeterMod RPC method on MessageDispatchService");
        Long xId = null;
        SwitchConnectionDistinguisher cookie = null;
        if (((Boolean)Objects.firstNonNull((Object)input.getUpdatedMeter().isBarrier(), (Object)Boolean.FALSE)).booleanValue()) {
            xId = this.session.getNextXid();
            BarrierInputBuilder barrierInput = new BarrierInputBuilder();
            barrierInput.setVersion(Short.valueOf(this.version));
            barrierInput.setXid(xId);
            Future<RpcResult<BarrierOutput>> barrierOFLib = this.messageService.barrier(barrierInput.build(), cookie);
        }
        MeterModInputBuilder ofMeterModInput = MeterConvertor.toMeterModInput((Meter)input.getUpdatedMeter(), this.version);
        xId = this.session.getNextXid();
        ofMeterModInput.setXid(xId);
        if (null != this.rpcNotificationProviderService) {
            MeterUpdatedBuilder meterMod = new MeterUpdatedBuilder((Meter)input.getUpdatedMeter());
            meterMod.setTransactionId(new TransactionId(BigInteger.valueOf(xId.intValue())));
            meterMod.setMeterRef(input.getMeterRef());
            this.rpcNotificationProviderService.publish((Notification)meterMod.build());
        }
        Future<RpcResult<UpdateMeterOutput>> resultFromOFLib = this.messageService.meterMod(ofMeterModInput.build(), cookie);
        RpcResult<UpdateMeterOutput> rpcResultFromOFLib = null;
        try {
            rpcResultFromOFLib = resultFromOFLib.get();
        }
        catch (Exception ex) {
            LOG.error(" Error while getting result for UpdateMeter RPC" + ex.getMessage());
        }
        UpdateMeterOutput updateMeterOutputFromOFLib = (UpdateMeterOutput)rpcResultFromOFLib.getResult();
        UpdateMeterOutputBuilder updateMeterOutput = new UpdateMeterOutputBuilder();
        updateMeterOutput.setTransactionId(updateMeterOutputFromOFLib.getTransactionId());
        UpdateMeterOutput result = updateMeterOutput.build();
        Collection errors = rpcResultFromOFLib.getErrors();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, (Collection)errors);
        LOG.debug("Returning the Update Meter RPC result to MD-SAL");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Future<RpcResult<GetAllGroupStatisticsOutput>> getAllGroupStatistics(GetAllGroupStatisticsInput input) {
        GetAllGroupStatisticsOutputBuilder output = new GetAllGroupStatisticsOutputBuilder();
        List errors = Collections.emptyList();
        if (this.version == 1) {
            output.setTransactionId(null);
            output.setGroupStats(null);
            RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
            return Futures.immediateFuture((Object)rpcResult);
        }
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare statistics request for all the groups - Transaction id - {}", (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPGROUP);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestGroupCaseBuilder caseBuilder = new MultipartRequestGroupCaseBuilder();
        MultipartRequestGroupBuilder mprGroupBuild = new MultipartRequestGroupBuilder();
        mprGroupBuild.setGroupId(new GroupId(Long.valueOf(BinContent.intToUnsignedLong((int)org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Group.OFPGALL.getIntValue()))));
        caseBuilder.setMultipartRequestGroup(mprGroupBuild.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        LOG.debug("Send group statistics request to the switch :{}", (Object)mprGroupBuild);
        this.messageService.multipartRequest(mprInput.build(), null);
        LOG.debug("Return results and transaction id back to caller");
        output.setTransactionId(this.generateTransactionId(xid));
        output.setGroupStats(null);
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetGroupDescriptionOutput>> getGroupDescription(GetGroupDescriptionInput input) {
        GetGroupDescriptionOutputBuilder output = new GetGroupDescriptionOutputBuilder();
        List errors = Collections.emptyList();
        if (this.version == 1) {
            output.setTransactionId(null);
            output.setGroupDescStats(null);
            RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
            return Futures.immediateFuture((Object)rpcResult);
        }
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare group description statistics request - Transaction id - {}", (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPGROUPDESC);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestGroupDescCaseBuilder mprGroupDescBuild = new MultipartRequestGroupDescCaseBuilder();
        mprInput.setMultipartRequestBody((MultipartRequestBody)mprGroupDescBuild.build());
        LOG.debug("Send group desciption statistics request to switch : {}", (Object)mprGroupDescBuild);
        this.messageService.multipartRequest(mprInput.build(), null);
        LOG.debug("Return results and transaction id back to caller");
        output.setTransactionId(this.generateTransactionId(xid));
        output.setGroupDescStats(null);
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetGroupFeaturesOutput>> getGroupFeatures(GetGroupFeaturesInput input) {
        GetGroupFeaturesOutputBuilder output = new GetGroupFeaturesOutputBuilder();
        List errors = Collections.emptyList();
        if (this.version == 1) {
            output.setTransactionId(null);
            RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
            return Futures.immediateFuture((Object)rpcResult);
        }
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare group features statistics request - Transaction id - {}", (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPGROUPFEATURES);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestGroupFeaturesCaseBuilder mprGroupFeaturesBuild = new MultipartRequestGroupFeaturesCaseBuilder();
        mprInput.setMultipartRequestBody((MultipartRequestBody)mprGroupFeaturesBuild.build());
        LOG.debug("Send group features statistics request :{}", (Object)mprGroupFeaturesBuild);
        this.messageService.multipartRequest(mprInput.build(), null);
        LOG.debug("Return results and transaction id back to caller");
        output.setTransactionId(this.generateTransactionId(xid));
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetGroupStatisticsOutput>> getGroupStatistics(GetGroupStatisticsInput input) {
        GetGroupStatisticsOutputBuilder output = new GetGroupStatisticsOutputBuilder();
        List errors = Collections.emptyList();
        if (this.version == 1) {
            output.setTransactionId(null);
            output.setGroupStats(null);
            RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
            return Futures.immediateFuture((Object)rpcResult);
        }
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare statistics request for node {} group ({}) - Transaction id - {}", new Object[]{input.getNode(), input.getGroupId(), xid});
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPGROUP);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestGroupCaseBuilder caseBuilder = new MultipartRequestGroupCaseBuilder();
        MultipartRequestGroupBuilder mprGroupBuild = new MultipartRequestGroupBuilder();
        mprGroupBuild.setGroupId(new GroupId(input.getGroupId().getValue()));
        caseBuilder.setMultipartRequestGroup(mprGroupBuild.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        LOG.debug("Send group statistics request :{}", (Object)mprGroupBuild);
        this.messageService.multipartRequest(mprInput.build(), null);
        LOG.debug("Return results and transaction id back to caller");
        output.setTransactionId(this.generateTransactionId(xid));
        output.setGroupStats(null);
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetAllMeterConfigStatisticsOutput>> getAllMeterConfigStatistics(GetAllMeterConfigStatisticsInput input) {
        GetAllMeterConfigStatisticsOutputBuilder output = new GetAllMeterConfigStatisticsOutputBuilder();
        List errors = Collections.emptyList();
        if (this.version == 1) {
            output.setTransactionId(null);
            output.setMeterConfigStats(null);
            RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
            return Futures.immediateFuture((Object)rpcResult);
        }
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare config request for all the meters - Transaction id - {}", (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPMETERCONFIG);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestMeterConfigCaseBuilder caseBuilder = new MultipartRequestMeterConfigCaseBuilder();
        MultipartRequestMeterConfigBuilder mprMeterConfigBuild = new MultipartRequestMeterConfigBuilder();
        mprMeterConfigBuild.setMeterId(new MeterId(Long.valueOf(BinContent.intToUnsignedLong((int)org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Meter.OFPMALL.getIntValue()))));
        caseBuilder.setMultipartRequestMeterConfig(mprMeterConfigBuild.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        LOG.debug("Send meter statistics request :{}", (Object)mprMeterConfigBuild);
        this.messageService.multipartRequest(mprInput.build(), null);
        LOG.debug("Return results and transaction id back to caller");
        output.setTransactionId(this.generateTransactionId(xid));
        output.setMeterConfigStats(null);
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetAllMeterStatisticsOutput>> getAllMeterStatistics(GetAllMeterStatisticsInput input) {
        GetAllMeterStatisticsOutputBuilder output = new GetAllMeterStatisticsOutputBuilder();
        List errors = Collections.emptyList();
        if (this.version == 1) {
            output.setTransactionId(null);
            output.setMeterStats(null);
            RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
            return Futures.immediateFuture((Object)rpcResult);
        }
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare statistics request for all the meters - Transaction id - {}", (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPMETER);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestMeterCaseBuilder caseBuilder = new MultipartRequestMeterCaseBuilder();
        MultipartRequestMeterBuilder mprMeterBuild = new MultipartRequestMeterBuilder();
        mprMeterBuild.setMeterId(new MeterId(Long.valueOf(BinContent.intToUnsignedLong((int)org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Meter.OFPMALL.getIntValue()))));
        caseBuilder.setMultipartRequestMeter(mprMeterBuild.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        LOG.debug("Send meter statistics request :{}", (Object)mprMeterBuild);
        this.messageService.multipartRequest(mprInput.build(), null);
        LOG.debug("Return results and transaction id back to caller");
        output.setTransactionId(this.generateTransactionId(xid));
        output.setMeterStats(null);
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetMeterFeaturesOutput>> getMeterFeatures(GetMeterFeaturesInput input) {
        GetMeterFeaturesOutputBuilder output = new GetMeterFeaturesOutputBuilder();
        List errors = Collections.emptyList();
        if (this.version == 1) {
            output.setTransactionId(null);
            RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
            return Futures.immediateFuture((Object)rpcResult);
        }
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare features statistics request for all the meters - Transaction id - {}", (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPMETERFEATURES);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestMeterFeaturesCaseBuilder mprMeterFeaturesBuild = new MultipartRequestMeterFeaturesCaseBuilder();
        mprInput.setMultipartRequestBody((MultipartRequestBody)mprMeterFeaturesBuild.build());
        LOG.debug("Send meter features statistics request :{}", (Object)mprMeterFeaturesBuild);
        this.messageService.multipartRequest(mprInput.build(), null);
        LOG.debug("Return results and transaction id back to caller");
        output.setTransactionId(this.generateTransactionId(xid));
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetMeterStatisticsOutput>> getMeterStatistics(GetMeterStatisticsInput input) {
        GetMeterStatisticsOutputBuilder output = new GetMeterStatisticsOutputBuilder();
        List errors = Collections.emptyList();
        if (this.version == 1) {
            output.setTransactionId(null);
            output.setMeterStats(null);
            RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
            return Futures.immediateFuture((Object)rpcResult);
        }
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Preprae statistics request for Meter ({}) - Transaction id - {}", (Object)input.getMeterId().getValue(), (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPMETER);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestMeterCaseBuilder caseBuilder = new MultipartRequestMeterCaseBuilder();
        MultipartRequestMeterBuilder mprMeterBuild = new MultipartRequestMeterBuilder();
        mprMeterBuild.setMeterId(new MeterId(input.getMeterId().getValue()));
        caseBuilder.setMultipartRequestMeter(mprMeterBuild.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        LOG.debug("Send meter statistics request :{}", (Object)mprMeterBuild);
        this.messageService.multipartRequest(mprInput.build(), null);
        LOG.debug("Return results and transaction id back to caller");
        output.setTransactionId(this.generateTransactionId(xid));
        output.setMeterStats(null);
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetAllNodeConnectorsStatisticsOutput>> getAllNodeConnectorsStatistics(GetAllNodeConnectorsStatisticsInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare port statistics request for all ports of node {} - TrasactionId - {}", (Object)arg0.getNode().getValue(), (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPPORTSTATS);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestPortStatsCaseBuilder caseBuilder = new MultipartRequestPortStatsCaseBuilder();
        MultipartRequestPortStatsBuilder mprPortStatsBuilder = new MultipartRequestPortStatsBuilder();
        mprPortStatsBuilder.setPortNo(OFConstants.OFPP_ANY);
        caseBuilder.setMultipartRequestPortStats(mprPortStatsBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        LOG.debug("Send port statistics request :{}", (Object)mprPortStatsBuilder.build().toString());
        this.messageService.multipartRequest(mprInput.build(), null);
        GetAllNodeConnectorsStatisticsOutputBuilder output = new GetAllNodeConnectorsStatisticsOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetNodeConnectorStatisticsOutput>> getNodeConnectorStatistics(GetNodeConnectorStatisticsInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare port statistics request for port {} of node {} - TrasactionId - {}", new Object[]{arg0.getNodeConnectorId(), arg0.getNode().getValue(), xid});
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPPORTSTATS);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestPortStatsCaseBuilder caseBuilder = new MultipartRequestPortStatsCaseBuilder();
        MultipartRequestPortStatsBuilder mprPortStatsBuilder = new MultipartRequestPortStatsBuilder();
        mprPortStatsBuilder.setPortNo(InventoryDataServiceUtil.portNumberfromNodeConnectorId(arg0.getNodeConnectorId()));
        caseBuilder.setMultipartRequestPortStats(mprPortStatsBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        LOG.debug("Send port statistics request :{}", (Object)mprPortStatsBuilder.build().toString());
        this.messageService.multipartRequest(mprInput.build(), null);
        GetNodeConnectorStatisticsOutputBuilder output = new GetNodeConnectorStatisticsOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    private TransactionId generateTransactionId(Long xid) {
        String stringXid = xid.toString();
        BigInteger bigIntXid = new BigInteger(stringXid);
        return new TransactionId(bigIntXid);
    }

    @Override
    public Future<RpcResult<GetPortOutput>> getPort() {
        return null;
    }

    @Override
    public Future<RpcResult<UpdatePortOutput>> updatePort(UpdatePortInput input) {
        PortModInput ofPortModInput = null;
        RpcResult<UpdatePortOutput> rpcResultFromOFLib = null;
        SwitchConnectionDistinguisher cookie = null;
        List inputPorts = input.getUpdatedPort().getPort().getPort();
        Long Xid = this.sessionContext.getNextXid();
        for (Port inputPort : inputPorts) {
            ofPortModInput = PortConvertor.toPortModInput(inputPort, this.version);
            PortModInputBuilder mdInput = new PortModInputBuilder();
            mdInput.setXid(Xid);
            mdInput.setVersion(ofPortModInput.getVersion());
            mdInput.setPortNo(ofPortModInput.getPortNo());
            mdInput.setMaskV10(ofPortModInput.getMaskV10());
            mdInput.setMask(ofPortModInput.getMask());
            mdInput.setHwAddress(ofPortModInput.getHwAddress());
            mdInput.setConfigV10(ofPortModInput.getConfigV10());
            mdInput.setConfig(ofPortModInput.getConfig());
            mdInput.setAdvertiseV10(ofPortModInput.getAdvertiseV10());
            mdInput.setAdvertise(ofPortModInput.getAdvertise());
            LOG.debug("Calling the PortMod RPC method on MessageDispatchService");
            Future<RpcResult<UpdatePortOutput>> resultFromOFLib = this.messageService.portMod(ofPortModInput, cookie);
            try {
                rpcResultFromOFLib = resultFromOFLib.get();
            }
            catch (Exception ex) {
                LOG.error(" Error while getting result for updatePort RPC" + ex.getMessage());
            }
        }
        UpdatePortOutput updatePortOutputOFLib = (UpdatePortOutput)rpcResultFromOFLib.getResult();
        UpdatePortOutputBuilder updatePortOutput = new UpdatePortOutputBuilder();
        updatePortOutput.setTransactionId(updatePortOutputOFLib.getTransactionId());
        UpdatePortOutput result = updatePortOutput.build();
        Collection errors = rpcResultFromOFLib.getErrors();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)result, (Collection)errors);
        LOG.debug("Returning the Update Group RPC result to MD-SAL");
        return Futures.immediateFuture((Object)rpcResult);
    }

    @Override
    public Future<RpcResult<UpdateTableOutput>> updateTable(UpdateTableInput input) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare the Multipart Table Mod requests for Transaction Id {} ", (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPTABLEFEATURES);
        mprInput.setVersion(Short.valueOf((short)4));
        mprInput.setXid(xid);
        List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.multipart.request.table.features.TableFeatures> ofTableFeatureList = TableFeaturesConvertor.toTableFeaturesRequest((TableFeatures)input.getUpdatedTable());
        MultipartRequestTableFeaturesCaseBuilder caseRequest = new MultipartRequestTableFeaturesCaseBuilder();
        MultipartRequestTableFeaturesBuilder tableFeaturesRequest = new MultipartRequestTableFeaturesBuilder();
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        tableFeaturesRequest.setTableFeatures(ofTableFeatureList);
        caseRequest.setMultipartRequestTableFeatures(tableFeaturesRequest.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseRequest.build());
        LOG.debug("Send Table Feature request :{}", ofTableFeatureList);
        this.messageService.multipartRequest(mprInput.build(), null);
        LOG.debug("Returning the result and transaction id to NSF");
        LOG.debug("Return results and transaction id back to caller");
        UpdateTableOutputBuilder output = new UpdateTableOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetAllFlowStatisticsFromFlowTableOutput>> getAllFlowStatisticsFromFlowTable(GetAllFlowStatisticsFromFlowTableInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare statistics request to get flow stats for switch tables {} - Transaction id - {}", (Object)arg0.getTableId().getValue(), (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPFLOW);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestFlowCaseBuilder multipartRequestFlowCaseBuilder = new MultipartRequestFlowCaseBuilder();
        MultipartRequestFlowBuilder mprFlowRequestBuilder = new MultipartRequestFlowBuilder();
        mprFlowRequestBuilder.setTableId(arg0.getTableId().getValue());
        mprFlowRequestBuilder.setOutPort(OFConstants.OFPP_ANY);
        mprFlowRequestBuilder.setOutGroup(OFConstants.OFPG_ANY);
        mprFlowRequestBuilder.setCookie(OFConstants.DEFAULT_COOKIE);
        mprFlowRequestBuilder.setCookieMask(OFConstants.DEFAULT_COOKIE_MASK);
        FlowCreatorUtil.setWildcardedFlowMatch(this.version, mprFlowRequestBuilder);
        multipartRequestFlowCaseBuilder.setMultipartRequestFlow(mprFlowRequestBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)multipartRequestFlowCaseBuilder.build());
        LOG.debug("Send flow statistics request to the switch :{}", (Object)mprFlowRequestBuilder);
        this.messageService.multipartRequest(mprInput.build(), null);
        LOG.debug("Return results and transaction id back to caller");
        GetAllFlowStatisticsFromFlowTableOutputBuilder output = new GetAllFlowStatisticsFromFlowTableOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        output.setFlowAndStatisticsMapList(null);
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetAllFlowsStatisticsFromAllFlowTablesOutput>> getAllFlowsStatisticsFromAllFlowTables(GetAllFlowsStatisticsFromAllFlowTablesInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare statistics request to get flow stats of all switch tables - Transaction id - {}", (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPFLOW);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestFlowCaseBuilder multipartRequestFlowCaseBuilder = new MultipartRequestFlowCaseBuilder();
        MultipartRequestFlowBuilder mprFlowRequestBuilder = new MultipartRequestFlowBuilder();
        mprFlowRequestBuilder.setTableId(OFConstants.OFPTT_ALL);
        mprFlowRequestBuilder.setOutPort(OFConstants.OFPP_ANY);
        mprFlowRequestBuilder.setOutGroup(OFConstants.OFPG_ANY);
        mprFlowRequestBuilder.setCookie(OFConstants.DEFAULT_COOKIE);
        mprFlowRequestBuilder.setCookieMask(OFConstants.DEFAULT_COOKIE_MASK);
        mprFlowRequestBuilder.setCookieMask(OFConstants.DEFAULT_COOKIE_MASK);
        FlowCreatorUtil.setWildcardedFlowMatch(this.version, mprFlowRequestBuilder);
        multipartRequestFlowCaseBuilder.setMultipartRequestFlow(mprFlowRequestBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)multipartRequestFlowCaseBuilder.build());
        LOG.debug("Send flow statistics request to the switch :{}", (Object)mprFlowRequestBuilder);
        this.messageService.multipartRequest(mprInput.build(), null);
        GetAllFlowsStatisticsFromAllFlowTablesOutputBuilder output = new GetAllFlowsStatisticsFromAllFlowTablesOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        output.setFlowAndStatisticsMapList(null);
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetFlowStatisticsFromFlowTableOutput>> getFlowStatisticsFromFlowTable(GetFlowStatisticsFromFlowTableInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare statistics request to get stats for flow {} for switch tables {} - Transaction id - {}", new Object[]{arg0.getMatch().toString(), arg0.getTableId(), xid});
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPFLOW);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestFlowCaseBuilder multipartRequestFlowCaseBuilder = new MultipartRequestFlowCaseBuilder();
        MultipartRequestFlowBuilder mprFlowRequestBuilder = new MultipartRequestFlowBuilder();
        mprFlowRequestBuilder.setTableId(arg0.getTableId());
        if (arg0.getOutPort() != null) {
            mprFlowRequestBuilder.setOutPort(Long.valueOf(arg0.getOutPort().longValue()));
        } else {
            mprFlowRequestBuilder.setOutPort(OFConstants.OFPP_ANY);
        }
        if (arg0.getOutGroup() != null) {
            mprFlowRequestBuilder.setOutGroup(arg0.getOutGroup());
        } else {
            mprFlowRequestBuilder.setOutGroup(OFConstants.OFPG_ANY);
        }
        if (arg0.getCookie() != null) {
            mprFlowRequestBuilder.setCookie(arg0.getCookie());
        } else {
            mprFlowRequestBuilder.setCookie(OFConstants.DEFAULT_COOKIE);
        }
        if (arg0.getCookieMask() != null) {
            mprFlowRequestBuilder.setCookieMask(arg0.getCookieMask());
        } else {
            mprFlowRequestBuilder.setCookieMask(OFConstants.DEFAULT_COOKIE_MASK);
        }
        MatchReactor.getInstance().convert(arg0.getMatch(), this.version, mprFlowRequestBuilder, this.getSessionContext().getFeatures().getDatapathId());
        multipartRequestFlowCaseBuilder.setMultipartRequestFlow(mprFlowRequestBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)multipartRequestFlowCaseBuilder.build());
        LOG.debug("Send flow statistics request to the switch :{}", (Object)mprFlowRequestBuilder);
        this.messageService.multipartRequest(mprInput.build(), null);
        GetFlowStatisticsFromFlowTableOutputBuilder output = new GetFlowStatisticsFromFlowTableOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        output.setFlowAndStatisticsMapList(null);
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetAggregateFlowStatisticsFromFlowTableForAllFlowsOutput>> getAggregateFlowStatisticsFromFlowTableForAllFlows(GetAggregateFlowStatisticsFromFlowTableForAllFlowsInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare aggregate flow statistics request to get aggregate flow stats for all the flow installed on switch table {} - Transaction id - {}", (Object)arg0.getTableId().getValue(), (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPAGGREGATE);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestAggregateCaseBuilder multipartRequestAggregateCaseBuilder = new MultipartRequestAggregateCaseBuilder();
        MultipartRequestAggregateBuilder mprAggregateRequestBuilder = new MultipartRequestAggregateBuilder();
        mprAggregateRequestBuilder.setTableId(arg0.getTableId().getValue());
        mprAggregateRequestBuilder.setOutPort(OFConstants.OFPP_ANY);
        mprAggregateRequestBuilder.setOutGroup(OFConstants.OFPG_ANY);
        mprAggregateRequestBuilder.setCookie(OFConstants.DEFAULT_COOKIE);
        mprAggregateRequestBuilder.setCookieMask(OFConstants.DEFAULT_COOKIE_MASK);
        FlowCreatorUtil.setWildcardedFlowMatch(this.version, mprAggregateRequestBuilder);
        multipartRequestAggregateCaseBuilder.setMultipartRequestAggregate(mprAggregateRequestBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)multipartRequestAggregateCaseBuilder.build());
        LOG.debug("Send request to the switch :{}", (Object)multipartRequestAggregateCaseBuilder.build().toString());
        this.messageService.multipartRequest(mprInput.build(), null);
        GetAggregateFlowStatisticsFromFlowTableForAllFlowsOutputBuilder output = new GetAggregateFlowStatisticsFromFlowTableForAllFlowsOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetAggregateFlowStatisticsFromFlowTableForGivenMatchOutput>> getAggregateFlowStatisticsFromFlowTableForGivenMatch(GetAggregateFlowStatisticsFromFlowTableForGivenMatchInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare aggregate statistics request to get aggregate stats for flows matching {} and installed in flow tables {} - Transaction id - {}", new Object[]{arg0.getMatch().toString(), arg0.getTableId(), xid});
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPAGGREGATE);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestAggregateCaseBuilder multipartRequestAggregateCaseBuilder = new MultipartRequestAggregateCaseBuilder();
        MultipartRequestAggregateBuilder mprAggregateRequestBuilder = new MultipartRequestAggregateBuilder();
        mprAggregateRequestBuilder.setTableId(arg0.getTableId());
        mprAggregateRequestBuilder.setOutPort(Long.valueOf(arg0.getOutPort().longValue()));
        mprAggregateRequestBuilder.setOutGroup(OFConstants.OFPG_ANY);
        mprAggregateRequestBuilder.setCookie(OFConstants.DEFAULT_COOKIE);
        mprAggregateRequestBuilder.setCookieMask(OFConstants.DEFAULT_COOKIE_MASK);
        MatchReactor.getInstance().convert(arg0.getMatch(), this.version, mprAggregateRequestBuilder, this.getSessionContext().getFeatures().getDatapathId());
        if (this.version == 4) {
            mprAggregateRequestBuilder.setCookie(arg0.getCookie());
            mprAggregateRequestBuilder.setCookieMask(arg0.getCookieMask());
            mprAggregateRequestBuilder.setOutGroup(arg0.getOutGroup());
        }
        multipartRequestAggregateCaseBuilder.setMultipartRequestAggregate(mprAggregateRequestBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)multipartRequestAggregateCaseBuilder.build());
        LOG.debug("Send request to the switch :{}", (Object)multipartRequestAggregateCaseBuilder.build().toString());
        this.messageService.multipartRequest(mprInput.build(), null);
        GetAggregateFlowStatisticsFromFlowTableForGivenMatchOutputBuilder output = new GetAggregateFlowStatisticsFromFlowTableForGivenMatchOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetFlowTablesStatisticsOutput>> getFlowTablesStatistics(GetFlowTablesStatisticsInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare flow table statistics request to get flow table stats for all tables from node {}- Transaction id - {}", (Object)arg0.getNode(), (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPTABLE);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestTableCaseBuilder multipartRequestTableCaseBuilder = new MultipartRequestTableCaseBuilder();
        MultipartRequestTableBuilder multipartRequestTableBuilder = new MultipartRequestTableBuilder();
        multipartRequestTableBuilder.setEmpty(Boolean.valueOf(true));
        multipartRequestTableCaseBuilder.setMultipartRequestTable(multipartRequestTableBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)multipartRequestTableCaseBuilder.build());
        LOG.debug("Send request to the switch :{}", (Object)multipartRequestTableCaseBuilder.build().toString());
        this.messageService.multipartRequest(mprInput.build(), null);
        GetFlowTablesStatisticsOutputBuilder output = new GetFlowTablesStatisticsOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetAllQueuesStatisticsFromAllPortsOutput>> getAllQueuesStatisticsFromAllPorts(GetAllQueuesStatisticsFromAllPortsInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare queue statistics request to collect stats for all queues attached to all the ports of node {} - TrasactionId - {}", (Object)arg0.getNode().getValue(), (Object)xid);
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPQUEUE);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestQueueCaseBuilder caseBuilder = new MultipartRequestQueueCaseBuilder();
        MultipartRequestQueueBuilder mprQueueBuilder = new MultipartRequestQueueBuilder();
        mprQueueBuilder.setPortNo(OFConstants.OFPP_ANY);
        mprQueueBuilder.setQueueId(OFConstants.OFPQ_ANY);
        caseBuilder.setMultipartRequestQueue(mprQueueBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        LOG.debug("Send queue statistics request :{}", (Object)mprQueueBuilder.build().toString());
        this.messageService.multipartRequest(mprInput.build(), null);
        GetAllQueuesStatisticsFromAllPortsOutputBuilder output = new GetAllQueuesStatisticsFromAllPortsOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        output.setQueueIdAndStatisticsMap(null);
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetAllQueuesStatisticsFromGivenPortOutput>> getAllQueuesStatisticsFromGivenPort(GetAllQueuesStatisticsFromGivenPortInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare queue statistics request to collect stats for all queues attached to given port {} of node {} - TrasactionId - {}", new Object[]{arg0.getNodeConnectorId().toString(), arg0.getNode().getValue(), xid});
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPQUEUE);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestQueueCaseBuilder caseBuilder = new MultipartRequestQueueCaseBuilder();
        MultipartRequestQueueBuilder mprQueueBuilder = new MultipartRequestQueueBuilder();
        mprQueueBuilder.setQueueId(OFConstants.OFPQ_ANY);
        mprQueueBuilder.setPortNo(InventoryDataServiceUtil.portNumberfromNodeConnectorId(arg0.getNodeConnectorId()));
        caseBuilder.setMultipartRequestQueue(mprQueueBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        LOG.debug("Send queue statistics request :{}", (Object)mprQueueBuilder.build().toString());
        this.messageService.multipartRequest(mprInput.build(), null);
        GetAllQueuesStatisticsFromGivenPortOutputBuilder output = new GetAllQueuesStatisticsFromGivenPortOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        output.setQueueIdAndStatisticsMap(null);
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }

    public Future<RpcResult<GetQueueStatisticsFromGivenPortOutput>> getQueueStatisticsFromGivenPort(GetQueueStatisticsFromGivenPortInput arg0) {
        Long xid = this.getSessionContext().getNextXid();
        LOG.debug("Prepare queue statistics request to collect stats for given queue attached to given port {} of node {} - TrasactionId - {}", new Object[]{arg0.getQueueId().toString(), arg0.getNodeConnectorId().toString(), arg0.getNode().getValue(), xid});
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPQUEUE);
        mprInput.setVersion(Short.valueOf(this.version));
        mprInput.setXid(xid);
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestQueueCaseBuilder caseBuilder = new MultipartRequestQueueCaseBuilder();
        MultipartRequestQueueBuilder mprQueueBuilder = new MultipartRequestQueueBuilder();
        mprQueueBuilder.setQueueId(arg0.getQueueId().getValue());
        mprQueueBuilder.setPortNo(InventoryDataServiceUtil.portNumberfromNodeConnectorId(arg0.getNodeConnectorId()));
        caseBuilder.setMultipartRequestQueue(mprQueueBuilder.build());
        mprInput.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        LOG.debug("Send queue statistics request :{}", (Object)mprQueueBuilder.build().toString());
        this.messageService.multipartRequest(mprInput.build(), null);
        GetQueueStatisticsFromGivenPortOutputBuilder output = new GetQueueStatisticsFromGivenPortOutputBuilder();
        output.setTransactionId(this.generateTransactionId(xid));
        output.setQueueIdAndStatisticsMap(null);
        List errors = Collections.emptyList();
        RpcResult rpcResult = Rpcs.getRpcResult((boolean)true, (Object)output.build(), errors);
        return Futures.immediateFuture((Object)rpcResult);
    }
}

