/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal;

import java.util.ArrayList;
import org.opendaylight.openflowplugin.openflow.md.core.sal.BuildSwitchFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityGroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityIpReasm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityPortBlocked;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityQueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityTableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;

public class BuildSwitchCapabilitiesOF13
implements BuildSwitchFeatures {
    private static BuildSwitchCapabilitiesOF13 instance = new BuildSwitchCapabilitiesOF13();

    private BuildSwitchCapabilitiesOF13() {
    }

    public static BuildSwitchCapabilitiesOF13 getInstance() {
        return instance;
    }

    @Override
    public SwitchFeatures build(GetFeaturesOutput features) {
        SwitchFeaturesBuilder builderSwFeatures = new SwitchFeaturesBuilder();
        builderSwFeatures.setMaxBuffers(features.getBuffers());
        builderSwFeatures.setMaxTables(features.getTables());
        ArrayList<Class<FlowFeatureCapabilityTableStats>> capabilities = new ArrayList<Class<FlowFeatureCapabilityTableStats>>();
        if (features.getCapabilities().isOFPCFLOWSTATS().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityFlowStats.class);
        }
        if (features.getCapabilities().isOFPCGROUPSTATS().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityGroupStats.class);
        }
        if (features.getCapabilities().isOFPCIPREASM().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityIpReasm.class);
        }
        if (features.getCapabilities().isOFPCPORTBLOCKED().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityPortBlocked.class);
        }
        if (features.getCapabilities().isOFPCPORTSTATS().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityPortStats.class);
        }
        if (features.getCapabilities().isOFPCQUEUESTATS().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityQueueStats.class);
        }
        if (features.getCapabilities().isOFPCTABLESTATS().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityTableStats.class);
        }
        builderSwFeatures.setCapabilities(capabilities);
        return builderSwFeatures.build();
    }
}

