/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.sal;

import java.util.ArrayList;
import org.opendaylight.openflowplugin.openflow.md.core.sal.BuildSwitchFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityArpMatchIp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityIpReasm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityQueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityReserved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityStp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityTableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;

public class BuildSwitchCapabilitiesOF10
implements BuildSwitchFeatures {
    private static BuildSwitchCapabilitiesOF10 instance = new BuildSwitchCapabilitiesOF10();

    private BuildSwitchCapabilitiesOF10() {
    }

    public static BuildSwitchCapabilitiesOF10 getInstance() {
        return instance;
    }

    @Override
    public SwitchFeatures build(GetFeaturesOutput features) {
        SwitchFeaturesBuilder builderSwFeatures = new SwitchFeaturesBuilder();
        builderSwFeatures.setMaxBuffers(features.getBuffers());
        builderSwFeatures.setMaxTables(features.getTables());
        ArrayList<Class> capabilities = new ArrayList<Class>();
        if (features.getCapabilitiesV10().isOFPCARPMATCHIP().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityArpMatchIp.class);
        }
        if (features.getCapabilitiesV10().isOFPCFLOWSTATS().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityFlowStats.class);
        }
        if (features.getCapabilitiesV10().isOFPCIPREASM().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityIpReasm.class);
        }
        if (features.getCapabilitiesV10().isOFPCPORTSTATS().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityPortStats.class);
        }
        if (features.getCapabilitiesV10().isOFPCQUEUESTATS().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityQueueStats.class);
        }
        if (features.getCapabilitiesV10().isOFPCRESERVED().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityReserved.class);
        }
        if (features.getCapabilitiesV10().isOFPCSTP().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityStp.class);
        }
        if (features.getCapabilitiesV10().isOFPCTABLESTATS().booleanValue()) {
            capabilities.add(FlowFeatureCapabilityTableStats.class);
        }
        builderSwFeatures.setCapabilities(capabilities);
        return builderSwFeatures.build();
    }
}

