/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core.cmd;

import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.openflowplugin.openflow.md.queue.MessageCountDumper;
import org.osgi.framework.BundleContext;

public class MessageCountCommandProvider
implements CommandProvider {
    private boolean sessionInitiated;
    private BundleContext ctx;
    private MessageCountDumper provider;

    public MessageCountCommandProvider(BundleContext ctx, MessageCountDumper provider) {
        this.ctx = ctx;
        this.provider = provider;
    }

    public String getHelp() {
        String helpString = "----------------- dumpMsgCount--------------\n dumps message counters \n";
        return helpString;
    }

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        this.ctx.registerService(CommandProvider.class.getName(), (Object)this, null);
        this.sessionInitiated = true;
    }

    public void _dumpMsgCount(CommandInterpreter ci) {
        if (this.sessionInitiated) {
            ci.println((Object)"dumping msg counts");
            for (String countItem : this.provider.dumpMessageCounts()) {
                ci.println((Object)countItem);
            }
        } else {
            ci.println((Object)"Session not initiated, try again in a few seconds");
        }
    }
}

