/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core;

import java.net.InetAddress;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionAdapter;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConductor;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConductorFactory;
import org.opendaylight.openflowplugin.openflow.md.core.ErrorHandler;
import org.opendaylight.openflowplugin.openflow.md.core.ErrorHandlerQueueImpl;
import org.opendaylight.openflowplugin.openflow.md.core.session.OFSessionUtil;
import org.opendaylight.openflowplugin.openflow.md.queue.MessageSpy;
import org.opendaylight.openflowplugin.openflow.md.queue.QueueKeeperLightImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SwitchConnectionHandlerImpl
implements SwitchConnectionHandler {
    private ScheduledThreadPoolExecutor spyPool;
    private QueueKeeperLightImpl queueKeeper = new QueueKeeperLightImpl();
    private ErrorHandler errorHandler = new ErrorHandlerQueueImpl();
    private MessageSpy<OfHeader, DataObject> messageSpy;
    private int spyRate = 10;

    public SwitchConnectionHandlerImpl() {
        new Thread(this.errorHandler).start();
        this.spyPool = new ScheduledThreadPoolExecutor(1);
    }

    public void init() {
        this.queueKeeper.setTranslatorMapping(OFSessionUtil.getTranslatorMap());
        this.queueKeeper.setPopListenersMapping(OFSessionUtil.getPopListenerMapping());
        this.queueKeeper.setMessageSpy(this.messageSpy);
        this.queueKeeper.init();
        this.spyPool.scheduleAtFixedRate(this.messageSpy, this.spyRate, this.spyRate, TimeUnit.SECONDS);
    }

    public boolean accept(InetAddress address) {
        return true;
    }

    public void onSwitchConnected(ConnectionAdapter connectionAdapter) {
        ConnectionConductor conductor = ConnectionConductorFactory.createConductor(connectionAdapter, this.queueKeeper);
        conductor.setErrorHandler(this.errorHandler);
    }

    public void setMessageSpy(MessageSpy<OfHeader, DataObject> messageSpy) {
        this.messageSpy = messageSpy;
    }
}

