/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.HelloElementType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.Elements;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.ElementsBuilder;

public abstract class MessageFactory {
    public static HelloInput createHelloInput(short helloVersion, long helloXid) {
        return MessageFactory.createHelloInput(helloVersion, helloXid, null);
    }

    private static HelloInputBuilder prepareHelloInputBuilder(short highestVersion, long xid) {
        HelloInputBuilder helloInputbuilder = new HelloInputBuilder();
        helloInputbuilder.setVersion(Short.valueOf(highestVersion));
        helloInputbuilder.setXid(Long.valueOf(xid));
        return helloInputbuilder;
    }

    public static HelloInput createHelloInput(short helloVersion, long helloXid, List<Short> versionOrder) {
        HelloInputBuilder helloInputbuilder = MessageFactory.prepareHelloInputBuilder(helloVersion, helloXid);
        if (versionOrder != null) {
            ArrayList<Elements> elementList = new ArrayList<Elements>();
            ElementsBuilder elementsBuilder = new ElementsBuilder();
            elementsBuilder.setType(HelloElementType.VERSIONBITMAP);
            ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
            int versionOrderIndex = versionOrder.size() - 1;
            while (versionOrderIndex >= 0) {
                short version = versionOrder.get(versionOrderIndex);
                if (version == booleanList.size()) {
                    booleanList.add(true);
                    --versionOrderIndex;
                    continue;
                }
                booleanList.add(false);
            }
            elementsBuilder.setVersionBitmap(booleanList);
            elementList.add(elementsBuilder.build());
            helloInputbuilder.setElements(elementList);
        }
        return helloInputbuilder.build();
    }

    public static List<Boolean> digVersions(List<Elements> elements) {
        List result = null;
        if (elements != null && !elements.isEmpty()) {
            for (Elements elm : elements) {
                if (!HelloElementType.VERSIONBITMAP.equals((Object)elm.getType())) continue;
                result = elm.getVersionBitmap();
            }
        }
        return result;
    }
}

