/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionConfiguration;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.spi.connection.SwitchConnectionProvider;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConfigurationFactory;
import org.opendaylight.openflowplugin.openflow.md.core.IMDController;
import org.opendaylight.openflowplugin.openflow.md.core.IMDMessageTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.NotificationPopListener;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionHandlerImpl;
import org.opendaylight.openflowplugin.openflow.md.core.TranslatorKey;
import org.opendaylight.openflowplugin.openflow.md.core.session.OFSessionUtil;
import org.opendaylight.openflowplugin.openflow.md.core.translator.ErrorTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.translator.ExperimenterTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.translator.FeaturesV10ToNodeConnectorUpdatedTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.translator.FlowRemovedTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.translator.MultiPartMessageDescToNodeUpdatedTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.translator.MultiPartReplyPortToNodeConnectorUpdatedTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.translator.MultipartReplyTableFeaturesToTableUpdatedTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.translator.MultipartReplyTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.translator.PacketInTranslator;
import org.opendaylight.openflowplugin.openflow.md.core.translator.PortStatusMessageToNodeConnectorUpdatedTranslator;
import org.opendaylight.openflowplugin.openflow.md.lldp.LLDPSpeakerPopListener;
import org.opendaylight.openflowplugin.openflow.md.queue.MessageSpy;
import org.opendaylight.openflowplugin.openflow.md.queue.PopListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SwitchFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.AggregateFlowStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowsStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupDescStatsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupFeaturesUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupStatisticsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterConfigStatsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterFeaturesUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterStatisticsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceived;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacketInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.NodeConnectorStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.QueueStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.TableUpdated;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDController
implements IMDController {
    private static final Logger LOG = LoggerFactory.getLogger(MDController.class);
    private SwitchConnectionProvider switchConnectionProvider;
    private ConcurrentMap<TranslatorKey, Collection<IMDMessageTranslator<OfHeader, List<DataObject>>>> messageTranslators;
    private Map<Class<? extends DataObject>, Collection<PopListener<DataObject>>> popListeners;
    private MessageSpy<OfHeader, DataObject> messageSpyCounter;
    private final int OF10 = 1;
    private final int OF13 = 4;

    public Map<TranslatorKey, Collection<IMDMessageTranslator<OfHeader, List<DataObject>>>> getMessageTranslators() {
        return this.messageTranslators;
    }

    public void init() {
        LOG.debug("Initializing!");
        this.messageTranslators = new ConcurrentHashMap<TranslatorKey, Collection<IMDMessageTranslator<OfHeader, List<DataObject>>>>();
        this.popListeners = new ConcurrentHashMap<Class<? extends DataObject>, Collection<PopListener<DataObject>>>();
        this.addMessageTranslator(ErrorMessage.class, 1, new ErrorTranslator());
        this.addMessageTranslator(ErrorMessage.class, 4, new ErrorTranslator());
        this.addMessageTranslator(FlowRemovedMessage.class, 1, new FlowRemovedTranslator());
        this.addMessageTranslator(FlowRemovedMessage.class, 4, new FlowRemovedTranslator());
        this.addMessageTranslator(PacketInMessage.class, 1, new PacketInTranslator());
        this.addMessageTranslator(PacketInMessage.class, 4, new PacketInTranslator());
        this.addMessageTranslator(PortStatusMessage.class, 1, new PortStatusMessageToNodeConnectorUpdatedTranslator());
        this.addMessageTranslator(PortStatusMessage.class, 4, new PortStatusMessageToNodeConnectorUpdatedTranslator());
        this.addMessageTranslator(MultipartReplyMessage.class, 4, new MultiPartReplyPortToNodeConnectorUpdatedTranslator());
        this.addMessageTranslator(MultipartReplyMessage.class, 1, new MultiPartMessageDescToNodeUpdatedTranslator());
        this.addMessageTranslator(MultipartReplyMessage.class, 4, new MultiPartMessageDescToNodeUpdatedTranslator());
        this.addMessageTranslator(ExperimenterMessage.class, 1, new ExperimenterTranslator());
        this.addMessageTranslator(MultipartReplyMessage.class, 1, new MultipartReplyTranslator());
        this.addMessageTranslator(MultipartReplyMessage.class, 4, new MultipartReplyTranslator());
        this.addMessageTranslator(MultipartReplyMessage.class, 4, new MultipartReplyTableFeaturesToTableUpdatedTranslator());
        this.addMessageTranslator(GetFeaturesOutput.class, 1, new FeaturesV10ToNodeConnectorUpdatedTranslator());
        NotificationPopListener<DataObject> notificationPopListener = new NotificationPopListener<DataObject>();
        this.addMessagePopListener(NodeErrorNotification.class, notificationPopListener);
        this.addMessagePopListener(NodeConnectorUpdated.class, notificationPopListener);
        this.addMessagePopListener(PacketReceived.class, notificationPopListener);
        this.addMessagePopListener(TransmitPacketInput.class, notificationPopListener);
        this.addMessagePopListener(NodeUpdated.class, notificationPopListener);
        this.addMessagePopListener(SwitchFlowRemoved.class, notificationPopListener);
        this.addMessagePopListener(TableUpdated.class, notificationPopListener);
        this.addMessagePopListener(FlowsStatisticsUpdate.class, notificationPopListener);
        this.addMessagePopListener(AggregateFlowStatisticsUpdate.class, notificationPopListener);
        this.addMessagePopListener(GroupStatisticsUpdated.class, notificationPopListener);
        this.addMessagePopListener(GroupFeaturesUpdated.class, notificationPopListener);
        this.addMessagePopListener(GroupDescStatsUpdated.class, notificationPopListener);
        this.addMessagePopListener(MeterStatisticsUpdated.class, notificationPopListener);
        this.addMessagePopListener(MeterConfigStatsUpdated.class, notificationPopListener);
        this.addMessagePopListener(MeterFeaturesUpdated.class, notificationPopListener);
        this.addMessagePopListener(NodeConnectorStatisticsUpdate.class, notificationPopListener);
        this.addMessagePopListener(FlowTableStatisticsUpdate.class, notificationPopListener);
        this.addMessagePopListener(QueueStatisticsUpdate.class, notificationPopListener);
        LLDPSpeakerPopListener<DataObject> lldpPopListener = new LLDPSpeakerPopListener<DataObject>();
        this.addMessagePopListener(NodeConnectorUpdated.class, lldpPopListener);
        OFSessionUtil.getSessionManager().setTranslatorMapping(this.messageTranslators);
        OFSessionUtil.getSessionManager().setPopListenerMapping(this.popListeners);
    }

    public void setSwitchConnectionProvider(SwitchConnectionProvider switchConnectionProvider) {
        this.switchConnectionProvider = switchConnectionProvider;
    }

    public void unsetSwitchConnectionProvider(SwitchConnectionProvider switchConnectionProviderToUnset) {
        if (this.switchConnectionProvider == switchConnectionProviderToUnset) {
            this.switchConnectionProvider = null;
        }
    }

    public void start() {
        LOG.debug("starting ..");
        LOG.debug("switchConnectionProvider: " + this.switchConnectionProvider);
        SwitchConnectionHandlerImpl switchConnectionHandler = new SwitchConnectionHandlerImpl();
        switchConnectionHandler.setMessageSpy(this.messageSpyCounter);
        switchConnectionHandler.init();
        this.switchConnectionProvider.setSwitchConnectionHandler((SwitchConnectionHandler)switchConnectionHandler);
        this.switchConnectionProvider.configure(MDController.getConnectionConfiguration());
        Future srvStarted = this.switchConnectionProvider.startup();
    }

    private static Collection<ConnectionConfiguration> getConnectionConfiguration() {
        ConnectionConfiguration configuration = ConnectionConfigurationFactory.getDefault();
        ConnectionConfiguration configurationLegacy = ConnectionConfigurationFactory.getLegacy();
        return Lists.newArrayList((Object[])new ConnectionConfiguration[]{configuration, configurationLegacy});
    }

    public void stop() {
        LOG.debug("stopping");
        Future srvStopped = this.switchConnectionProvider.shutdown();
        try {
            srvStopped.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    @Override
    public void addMessageTranslator(Class<? extends DataObject> messageType, int version, IMDMessageTranslator<OfHeader, List<DataObject>> translator) {
        TranslatorKey tKey = new TranslatorKey(version, messageType.getName());
        LinkedHashSet<IMDMessageTranslator<OfHeader, List<DataObject>>> existingValues = (LinkedHashSet<IMDMessageTranslator<OfHeader, List<DataObject>>>)this.messageTranslators.get(tKey);
        if (existingValues == null) {
            existingValues = new LinkedHashSet<IMDMessageTranslator<OfHeader, List<DataObject>>>();
            this.messageTranslators.put(tKey, existingValues);
        }
        existingValues.add(translator);
        LOG.debug("{} is now translated by {}", messageType, translator);
    }

    @Override
    public void removeMessageTranslator(Class<? extends DataObject> messageType, int version, IMDMessageTranslator<OfHeader, List<DataObject>> translator) {
        TranslatorKey tKey = new TranslatorKey(version, messageType.getName());
        Collection values = (Collection)this.messageTranslators.get(tKey);
        if (values != null) {
            values.remove(translator);
            if (values.isEmpty()) {
                this.messageTranslators.remove(tKey);
            }
            LOG.debug("{} is now removed from translators", translator);
        }
    }

    @Override
    public void addMessagePopListener(Class<? extends DataObject> messageType, PopListener<DataObject> popListener) {
        Collection<PopListener<DataObject>> existingValues = this.popListeners.get(messageType);
        if (existingValues == null) {
            existingValues = new LinkedHashSet<PopListener<DataObject>>();
            this.popListeners.put(messageType, existingValues);
        }
        existingValues.add(popListener);
        LOG.debug("{} is now popListened by {}", messageType, popListener);
    }

    @Override
    public void removeMessagePopListener(Class<? extends DataObject> messageType, PopListener<DataObject> popListener) {
        Collection<PopListener<DataObject>> values = this.popListeners.get(messageType);
        if (values != null) {
            values.remove(popListener);
            if (values.isEmpty()) {
                this.popListeners.remove(messageType);
            }
            LOG.debug("{} is now removed from popListeners", popListener);
        }
    }

    public void setMessageSpyCounter(MessageSpy<OfHeader, DataObject> messageSpyCounter) {
        this.messageSpyCounter = messageSpyCounter;
    }
}

