/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core;

import org.opendaylight.openflowjava.protocol.api.connection.ConnectionAdapter;
import org.opendaylight.openflowplugin.openflow.md.core.HandshakeManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeStepWrapper
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HandshakeStepWrapper.class);
    private HelloMessage helloMessage;
    private HandshakeManager handshakeManager;
    private ConnectionAdapter connectionAdapter;

    public HandshakeStepWrapper(HelloMessage helloMessage, HandshakeManager handshakeManager, ConnectionAdapter connectionAdapter) {
        this.helloMessage = helloMessage;
        this.handshakeManager = handshakeManager;
        this.connectionAdapter = connectionAdapter;
    }

    @Override
    public void run() {
        if (this.connectionAdapter.isAlive()) {
            this.handshakeManager.setReceivedHello(this.helloMessage);
            this.handshakeManager.shake();
        } else {
            LOG.debug("connection is down - skipping handshake step");
        }
    }
}

