/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionAdapter;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConductor;
import org.opendaylight.openflowplugin.openflow.md.core.ErrorHandler;
import org.opendaylight.openflowplugin.openflow.md.core.HandshakeListener;
import org.opendaylight.openflowplugin.openflow.md.core.HandshakeManager;
import org.opendaylight.openflowplugin.openflow.md.core.MessageFactory;
import org.opendaylight.openflowplugin.openflow.md.core.RpcUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.Elements;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeManagerImpl
implements HandshakeManager {
    private static final Logger LOG = LoggerFactory.getLogger(HandshakeManagerImpl.class);
    private Short lastProposedVersion;
    private Short lastReceivedVersion;
    private final List<Short> versionOrder;
    private HelloMessage receivedHello;
    private final ConnectionAdapter connectionAdapter;
    private GetFeaturesOutput features;
    private Short version;
    private ErrorHandler errorHandler;
    private long maxTimeout = 1000L;
    private TimeUnit maxTimeoutUnit = TimeUnit.MILLISECONDS;
    private Short highestVersion;
    private Long activeXid;
    private HandshakeListener handshakeListener;
    private boolean useVersionBitmap;

    @Override
    public void setReceivedHello(HelloMessage receivedHello) {
        this.receivedHello = receivedHello;
    }

    public HandshakeManagerImpl(ConnectionAdapter connectionAdapter, Short highestVersion, List<Short> versionOrder) {
        this.highestVersion = highestVersion;
        this.versionOrder = versionOrder;
        this.connectionAdapter = connectionAdapter;
    }

    @Override
    public void setHandshakeListener(HandshakeListener handshakeListener) {
        this.handshakeListener = handshakeListener;
    }

    @Override
    public synchronized void shake() {
        LOG.trace("handshake STARTED");
        this.setActiveXid(20L);
        HelloMessage receivedHelloLoc = this.receivedHello;
        try {
            if (receivedHelloLoc == null) {
                this.sendHelloMessage(this.highestVersion, this.getNextXid());
                this.lastProposedVersion = this.highestVersion;
                LOG.debug("ret - firstHello+wait");
                return;
            }
            Short remoteVersion = receivedHelloLoc.getVersion();
            List elements = receivedHelloLoc.getElements();
            this.setActiveXid(receivedHelloLoc.getXid());
            List<Boolean> remoteVersionBitmap = MessageFactory.digVersions(elements);
            LOG.debug("Hello message: version={}, bitmap={}, xid={}", new Object[]{remoteVersion, remoteVersionBitmap, receivedHelloLoc.getXid()});
            if (this.useVersionBitmap && remoteVersionBitmap != null) {
                this.handleVersionBitmapNegotiation(elements);
            } else {
                this.handleStepByStepVersionNegotiation(remoteVersion);
            }
        }
        catch (Throwable ex) {
            this.errorHandler.handleException(ex, null);
            this.connectionAdapter.disconnect();
            LOG.debug("ret - " + ex.getMessage());
        }
    }

    private void handleStepByStepVersionNegotiation(Short remoteVersion) throws Throwable {
        LOG.debug("remoteVersion:{} lastProposedVersion:{}, highestVersion:{}", new Object[]{remoteVersion, this.lastProposedVersion, this.highestVersion});
        if (this.lastProposedVersion == null) {
            this.lastProposedVersion = this.proposeNextVersion(remoteVersion);
            this.sendHelloMessage(this.lastProposedVersion, this.getNextXid());
        }
        if (remoteVersion == this.lastProposedVersion) {
            this.postHandshake(this.lastProposedVersion, this.getNextXid());
            LOG.debug("ret - OK - switch answered with lastProposedVersion");
        } else {
            this.checkNegotiationStalling(remoteVersion);
            if (remoteVersion > (this.lastProposedVersion == null ? this.highestVersion : this.lastProposedVersion)) {
                LOG.debug("ret - wait");
            } else {
                this.handleLowerVersionProposal(remoteVersion);
            }
        }
    }

    private void handleLowerVersionProposal(Short remoteVersion) throws Throwable {
        Short proposedVersion;
        this.lastProposedVersion = proposedVersion = Short.valueOf(this.proposeNextVersion(remoteVersion));
        this.sendHelloMessage(proposedVersion, this.getNextXid());
        if (proposedVersion != remoteVersion) {
            LOG.debug("ret - sent+wait");
        } else {
            LOG.debug("ret - sent+OK");
            this.postHandshake(proposedVersion, this.getNextXid());
        }
    }

    private void handleVersionBitmapNegotiation(List<Elements> elements) throws Throwable {
        Short proposedVersion = this.proposeCommonBitmapVersion(elements);
        if (this.lastProposedVersion == null) {
            this.sendHelloMessage(proposedVersion, this.getNextXid());
        }
        this.postHandshake(proposedVersion, this.getNextXid());
        LOG.debug("ret - OK - versionBitmap");
    }

    private Long getNextXid() {
        this.activeXid = this.activeXid + 1L;
        return this.activeXid;
    }

    private void setActiveXid(Long xid) {
        this.activeXid = xid;
    }

    private void checkNegotiationStalling(Short remoteVersion) {
        if (this.lastReceivedVersion != null && this.lastReceivedVersion.equals(remoteVersion)) {
            throw new IllegalStateException("version negotiation stalled: version = " + remoteVersion);
        }
        this.lastReceivedVersion = remoteVersion;
    }

    @Override
    public GetFeaturesOutput getFeatures() {
        return this.features;
    }

    @Override
    public Short getVersion() {
        return this.version;
    }

    protected Short proposeCommonBitmapVersion(List<Elements> list) {
        Short supportedHighestVersion = null;
        if (null != list && 0 != list.size()) {
            block0: for (Elements element : list) {
                List bitmap = element.getVersionBitmap();
                for (short bitPos : ConnectionConductor.versionOrder) {
                    if (!((Boolean)bitmap.get(bitPos % 32)).booleanValue()) continue;
                    supportedHighestVersion = bitPos;
                    continue block0;
                }
            }
            if (null == supportedHighestVersion) {
                throw new IllegalArgumentException("no common version found in versionBitmap");
            }
        }
        return supportedHighestVersion;
    }

    protected short proposeNextVersion(short remoteVersion) {
        Short proposal = null;
        for (short offer : this.versionOrder) {
            if (offer > remoteVersion) continue;
            proposal = offer;
            break;
        }
        if (proposal == null) {
            throw new IllegalArgumentException("no equal or lower version found, unsupported version: " + remoteVersion);
        }
        return proposal;
    }

    private void sendHelloMessage(Short helloVersion, Long helloXid) throws Throwable {
        HelloInput helloInput = MessageFactory.createHelloInput(helloVersion, helloXid, this.versionOrder);
        LOG.debug("sending hello message: version{}, xid={}, version bitmap={}", new Object[]{helloVersion, helloXid, MessageFactory.digVersions(helloInput.getElements())});
        try {
            RpcResult helloResult = (RpcResult)this.connectionAdapter.hello(helloInput).get(this.maxTimeout, this.maxTimeoutUnit);
            RpcUtil.smokeRpc(helloResult);
            LOG.debug("FIRST HELLO sent.");
        }
        catch (Throwable e) {
            LOG.debug("FIRST HELLO sending failed.");
            throw e;
        }
    }

    protected void postHandshake(Short proposedVersion, Long xid) throws Throwable {
        this.version = proposedVersion;
        LOG.debug("version set: " + proposedVersion);
        GetFeaturesInputBuilder featuresBuilder = new GetFeaturesInputBuilder();
        featuresBuilder.setVersion(this.version).setXid(xid);
        LOG.debug("sending feature request for version={} and xid={}", (Object)this.version, (Object)xid);
        Future featuresFuture = this.connectionAdapter.getFeatures(featuresBuilder.build());
        LOG.debug("waiting for features");
        try {
            RpcResult rpcFeatures = (RpcResult)featuresFuture.get(this.maxTimeout, this.maxTimeoutUnit);
            RpcUtil.smokeRpc(rpcFeatures);
            GetFeaturesOutput featureOutput = (GetFeaturesOutput)rpcFeatures.getResult();
            LOG.debug("obtained features: datapathId={}", (Object)featureOutput.getDatapathId());
            LOG.debug("obtained features: auxiliaryId={}", (Object)featureOutput.getAuxiliaryId());
            LOG.trace("handshake SETTLED: version={}, datapathId={}, auxiliaryId={}", new Object[]{this.version, featureOutput.getDatapathId(), featureOutput.getAuxiliaryId()});
            this.handshakeListener.onHandshakeSuccessfull(featureOutput, proposedVersion);
        }
        catch (Throwable e) {
            LOG.error("issuing disconnect during handshake, reason: " + e.getMessage());
            this.connectionAdapter.disconnect();
            throw e;
        }
        LOG.debug("postHandshake DONE");
    }

    @Override
    public void setUseVersionBitmap(boolean useVersionBitmap) {
        this.useVersionBitmap = useVersionBitmap;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

