/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core;

import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import org.opendaylight.openflowplugin.openflow.md.core.ErrorHandler;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandlerQueueImpl
implements ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorHandlerQueueImpl.class);
    private LinkedBlockingQueue<Exception> errorQueue = new LinkedBlockingQueue();

    @Override
    public void run() {
        while (true) {
            try {
                Exception error = this.errorQueue.take();
                Throwable cause = error.getCause();
                LOG.error(error.getMessage() + " -> " + cause.getMessage(), cause);
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn(e.getMessage());
                continue;
            }
            break;
        }
    }

    @Override
    public void handleException(Throwable e, SessionContext sessionContext) {
        String sessionKeyId = null;
        if (sessionContext != null) {
            sessionKeyId = Arrays.toString(sessionContext.getSessionKey().getId());
        }
        Exception causeAndThread = new Exception("IN THREAD: " + Thread.currentThread().getName() + "; session:" + sessionKeyId, e);
        try {
            this.errorQueue.put(causeAndThread);
        }
        catch (InterruptedException e1) {
            LOG.error(e1.getMessage(), (Throwable)e1);
        }
    }
}

