/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.openflow.md.core;

import com.google.common.util.concurrent.Futures;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionAdapter;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionReadyListener;
import org.opendaylight.openflowplugin.openflow.md.core.ConnectionConductor;
import org.opendaylight.openflowplugin.openflow.md.core.ErrorHandler;
import org.opendaylight.openflowplugin.openflow.md.core.HandshakeListener;
import org.opendaylight.openflowplugin.openflow.md.core.HandshakeManager;
import org.opendaylight.openflowplugin.openflow.md.core.HandshakeManagerImpl;
import org.opendaylight.openflowplugin.openflow.md.core.HandshakeStepWrapper;
import org.opendaylight.openflowplugin.openflow.md.core.SwitchConnectionDistinguisher;
import org.opendaylight.openflowplugin.openflow.md.core.session.OFSessionUtil;
import org.opendaylight.openflowplugin.openflow.md.core.session.PortFeaturesUtil;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionContext;
import org.opendaylight.openflowplugin.openflow.md.core.session.SessionManager;
import org.opendaylight.openflowplugin.openflow.md.queue.QueueKeeper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoReplyInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoRequestMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OpenflowProtocolListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Port;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.DisconnectEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SwitchIdleEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SystemNotificationsListener;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConductorImpl
implements OpenflowProtocolListener,
SystemNotificationsListener,
ConnectionConductor,
ConnectionReadyListener,
HandshakeListener {
    protected static final Logger LOG = LoggerFactory.getLogger(ConnectionConductorImpl.class);
    private boolean isBitmapNegotiationEnable = true;
    protected ErrorHandler errorHandler;
    private final ConnectionAdapter connectionAdapter;
    private ConnectionConductor.CONDUCTOR_STATE conductorState;
    private Short version;
    protected SwitchConnectionDistinguisher auxiliaryKey;
    protected SessionContext sessionContext;
    private QueueKeeper<OfHeader, DataObject> queueKeeper;
    private ExecutorService hsPool;
    private HandshakeManager handshakeManager;
    private boolean firstHelloProcessed;
    private PortFeaturesUtil portFeaturesUtils;

    public ConnectionConductorImpl(ConnectionAdapter connectionAdapter) {
        this.connectionAdapter = connectionAdapter;
        this.conductorState = ConnectionConductor.CONDUCTOR_STATE.HANDSHAKING;
        this.hsPool = Executors.newFixedThreadPool(1);
        this.firstHelloProcessed = false;
        this.handshakeManager = new HandshakeManagerImpl(connectionAdapter, ConnectionConductor.versionOrder.get(0), ConnectionConductor.versionOrder);
        this.handshakeManager.setUseVersionBitmap(this.isBitmapNegotiationEnable);
        this.handshakeManager.setHandshakeListener(this);
        this.portFeaturesUtils = PortFeaturesUtil.getInstance();
    }

    @Override
    public void init() {
        this.connectionAdapter.setMessageListener((OpenflowProtocolListener)this);
        this.connectionAdapter.setSystemListener((SystemNotificationsListener)this);
        this.connectionAdapter.setConnectionReadyListener((ConnectionReadyListener)this);
    }

    @Override
    public void setQueueKeeper(QueueKeeper<OfHeader, DataObject> queueKeeper) {
        this.queueKeeper = queueKeeper;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.handshakeManager.setErrorHandler(errorHandler);
    }

    public void onEchoRequestMessage(final EchoRequestMessage echoRequestMessage) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.debug("echo request received: " + echoRequestMessage.getXid());
                EchoReplyInputBuilder builder = new EchoReplyInputBuilder();
                builder.setVersion(echoRequestMessage.getVersion());
                builder.setXid(echoRequestMessage.getXid());
                builder.setData(echoRequestMessage.getData());
                ConnectionConductorImpl.this.getConnectionAdapter().echoReply(builder.build());
            }
        }).start();
    }

    public void onErrorMessage(ErrorMessage errorMessage) {
        this.queueKeeper.push((OfHeader)errorMessage, this);
    }

    public void onExperimenterMessage(ExperimenterMessage experimenterMessage) {
        this.queueKeeper.push((OfHeader)experimenterMessage, this);
    }

    public void onFlowRemovedMessage(FlowRemovedMessage message) {
        this.queueKeeper.push((OfHeader)message, this);
    }

    public synchronized void onHelloMessage(HelloMessage hello) {
        LOG.debug("processing HELLO.xid: {}", (Object)hello.getXid());
        this.firstHelloProcessed = true;
        this.checkState(ConnectionConductor.CONDUCTOR_STATE.HANDSHAKING);
        HandshakeStepWrapper handshakeStepWrapper = new HandshakeStepWrapper(hello, this.handshakeManager, this.connectionAdapter);
        this.hsPool.execute(handshakeStepWrapper);
    }

    protected long getMaxTimeout() {
        return 2000L;
    }

    protected TimeUnit getMaxTimeoutUnit() {
        return TimeUnit.MILLISECONDS;
    }

    public void onMultipartReplyMessage(MultipartReplyMessage message) {
        this.queueKeeper.push((OfHeader)message, this);
    }

    public void onPacketInMessage(PacketInMessage message) {
        this.queueKeeper.push((OfHeader)message, this, QueueKeeper.QueueType.UNORDERED);
    }

    public void onPortStatusMessage(PortStatusMessage message) {
        this.processPortStatusMsg((PortStatus)message);
        this.queueKeeper.push((OfHeader)message, this);
    }

    protected void processPortStatusMsg(PortStatus msg) {
        if (msg.getReason().getIntValue() == 2) {
            this.updatePort(msg);
        } else if (msg.getReason().getIntValue() == 0) {
            this.updatePort(msg);
        } else if (msg.getReason().getIntValue() == 1) {
            this.deletePort((Port)msg);
        }
    }

    protected void updatePort(PortStatus msg) {
        Long portNumber = msg.getPortNo();
        Boolean portBandwidth = this.portFeaturesUtils.getPortBandwidth(msg);
        if (portBandwidth == null) {
            LOG.debug("can't get bandwidth info from port: {}, aborting port update", (Object)msg.toString());
        } else {
            this.getSessionContext().getPhysicalPorts().put(portNumber, (Port)msg);
            this.getSessionContext().getPortsBandwidth().put(portNumber, portBandwidth);
        }
    }

    protected void deletePort(Port port) {
        Long portNumber = port.getPortNo();
        this.getSessionContext().getPhysicalPorts().remove(portNumber);
        this.getSessionContext().getPortsBandwidth().remove(portNumber);
    }

    public void onSwitchIdleEvent(SwitchIdleEvent notification) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!ConnectionConductor.CONDUCTOR_STATE.WORKING.equals((Object)ConnectionConductorImpl.this.getConductorState())) {
                    ConnectionConductorImpl.this.disconnect();
                    OFSessionUtil.getSessionManager().invalidateOnDisconnect(ConnectionConductorImpl.this);
                } else {
                    LOG.debug("first idle state occured, sessionCtx={}|auxId={}", (Object)ConnectionConductorImpl.this.sessionContext, (Object)ConnectionConductorImpl.this.auxiliaryKey);
                    EchoInputBuilder builder = new EchoInputBuilder();
                    builder.setVersion(ConnectionConductorImpl.this.getVersion());
                    builder.setXid(ConnectionConductorImpl.this.getSessionContext().getNextXid());
                    Future echoReplyFuture = ConnectionConductorImpl.this.getConnectionAdapter().echo(builder.build());
                    try {
                        RpcResult echoReplyValue = (RpcResult)echoReplyFuture.get(ConnectionConductorImpl.this.getMaxTimeout(), ConnectionConductorImpl.this.getMaxTimeoutUnit());
                        if (!echoReplyValue.isSuccessful()) {
                            for (RpcError replyError : echoReplyValue.getErrors()) {
                                Throwable cause = replyError.getCause();
                                LOG.error("while receiving echoReply in TIMEOUTING state: " + cause.getMessage(), cause);
                            }
                            throw new Exception("switch issue occurred");
                        }
                        ConnectionConductorImpl.this.setConductorState(ConnectionConductor.CONDUCTOR_STATE.WORKING);
                    }
                    catch (Exception e) {
                        LOG.error("while waiting for echoReply in TIMEOUTING state: " + e.getMessage());
                        ConnectionConductorImpl.this.errorHandler.handleException(e, ConnectionConductorImpl.this.sessionContext);
                        ConnectionConductorImpl.this.disconnect();
                        OFSessionUtil.getSessionManager().invalidateOnDisconnect(ConnectionConductorImpl.this);
                    }
                }
            }
        }).start();
    }

    @Override
    public void setConductorState(ConnectionConductor.CONDUCTOR_STATE conductorState) {
        this.conductorState = conductorState;
    }

    @Override
    public ConnectionConductor.CONDUCTOR_STATE getConductorState() {
        return this.conductorState;
    }

    protected void checkState(ConnectionConductor.CONDUCTOR_STATE expectedState) {
        if (!this.conductorState.equals((Object)expectedState)) {
            throw new IllegalStateException("Expected state: " + (Object)((Object)expectedState) + ", actual state:" + (Object)((Object)this.conductorState));
        }
    }

    public void onDisconnectEvent(DisconnectEvent arg0) {
        SessionManager sessionManager = OFSessionUtil.getSessionManager();
        sessionManager.invalidateOnDisconnect(this);
    }

    @Override
    public Short getVersion() {
        return this.version;
    }

    @Override
    public Future<Boolean> disconnect() {
        LOG.trace("disconnecting: sessionCtx={}|auxId={}", (Object)this.sessionContext, (Object)this.auxiliaryKey);
        Future result = null;
        if (this.connectionAdapter.isAlive()) {
            result = this.connectionAdapter.disconnect();
        } else {
            LOG.debug("connection already disconnected");
            result = Futures.immediateFuture((Object)true);
        }
        return result;
    }

    @Override
    public void setConnectionCookie(SwitchConnectionDistinguisher auxiliaryKey) {
        this.auxiliaryKey = auxiliaryKey;
    }

    @Override
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @Override
    public SwitchConnectionDistinguisher getAuxiliaryKey() {
        return this.auxiliaryKey;
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public ConnectionAdapter getConnectionAdapter() {
        return this.connectionAdapter;
    }

    public synchronized void onConnectionReady() {
        LOG.debug("connection is ready-to-use");
        if (!this.firstHelloProcessed) {
            HandshakeStepWrapper handshakeStepWrapper = new HandshakeStepWrapper(null, this.handshakeManager, this.connectionAdapter);
            this.hsPool.execute(handshakeStepWrapper);
            this.firstHelloProcessed = true;
        } else {
            LOG.debug("already touched by hello message");
        }
    }

    @Override
    public void onHandshakeSuccessfull(GetFeaturesOutput featureOutput, Short negotiatedVersion) {
        this.postHandshakeBasic(featureOutput, negotiatedVersion);
        if (this.version == 4) {
            this.requestGroupFeatures();
            this.requestMeterFeatures();
        } else if (this.version == 1) {
            this.queueKeeper.push((OfHeader)featureOutput, this);
        }
        this.requestDesc();
        this.requestPorts();
    }

    protected void postHandshakeBasic(GetFeaturesOutput featureOutput, Short negotiatedVersion) {
        this.version = negotiatedVersion;
        this.conductorState = ConnectionConductor.CONDUCTOR_STATE.WORKING;
        OFSessionUtil.registerSession(this, featureOutput, negotiatedVersion);
    }

    private void requestDesc() {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        builder.setType(MultipartType.OFPMPDESC);
        builder.setVersion(this.getVersion());
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        builder.setMultipartRequestBody((MultipartRequestBody)new MultipartRequestDescCaseBuilder().build());
        builder.setXid(this.getSessionContext().getNextXid());
        this.getConnectionAdapter().multipartRequest(builder.build());
    }

    private void requestPorts() {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        builder.setType(MultipartType.OFPMPPORTDESC);
        builder.setVersion(this.getVersion());
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        builder.setMultipartRequestBody((MultipartRequestBody)new MultipartRequestPortDescCaseBuilder().build());
        builder.setXid(this.getSessionContext().getNextXid());
        this.getConnectionAdapter().multipartRequest(builder.build());
    }

    private void requestGroupFeatures() {
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPGROUPFEATURES);
        mprInput.setVersion(this.getVersion());
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        mprInput.setXid(this.getSessionContext().getNextXid());
        MultipartRequestGroupFeaturesCaseBuilder mprGroupFeaturesBuild = new MultipartRequestGroupFeaturesCaseBuilder();
        mprInput.setMultipartRequestBody((MultipartRequestBody)mprGroupFeaturesBuild.build());
        LOG.debug("Send group features statistics request :{}", (Object)mprGroupFeaturesBuild);
        this.getConnectionAdapter().multipartRequest(mprInput.build());
    }

    private void requestMeterFeatures() {
        MultipartRequestInputBuilder mprInput = new MultipartRequestInputBuilder();
        mprInput.setType(MultipartType.OFPMPMETERFEATURES);
        mprInput.setVersion(this.getVersion());
        mprInput.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        mprInput.setXid(this.getSessionContext().getNextXid());
        MultipartRequestMeterFeaturesCaseBuilder mprMeterFeaturesBuild = new MultipartRequestMeterFeaturesCaseBuilder();
        mprInput.setMultipartRequestBody((MultipartRequestBody)mprMeterFeaturesBuild.build());
        LOG.debug("Send meter features statistics request :{}", (Object)mprMeterFeaturesBuild);
        this.getConnectionAdapter().multipartRequest(mprInput.build());
    }

    public void setBitmapNegotiationEnable(boolean isBitmapNegotiationEnable) {
        this.isBitmapNegotiationEnable = isBitmapNegotiationEnable;
    }

    protected void shutdownPool() {
        this.hsPool.shutdownNow();
        LOG.debug("pool is terminated: {}", (Object)this.hsPool.isTerminated());
    }
}

