/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.common.QName;

public class InstanceIdentifier
implements Path<InstanceIdentifier>,
Immutable,
Serializable {
    private static final long serialVersionUID = 8467409862384206193L;
    private final List<PathArgument> path;
    private transient String to_string_cache = null;

    public List<PathArgument> getPath() {
        return this.path;
    }

    public InstanceIdentifier(List<? extends PathArgument> path) {
        this.path = ImmutableList.copyOf(path);
    }

    private InstanceIdentifier(NodeIdentifier nodeIdentifier) {
        this.path = ImmutableList.of((Object)nodeIdentifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceIdentifier other = (InstanceIdentifier)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public static InstanceIdentifier of(QName name) {
        return new InstanceIdentifier(new NodeIdentifier(name));
    }

    public static InstanceIdentifierBuilder builder() {
        return new BuilderImpl();
    }

    public static InstanceIdentifierBuilder builder(InstanceIdentifier origin) {
        return new BuilderImpl(origin.getPath());
    }

    public boolean contains(InstanceIdentifier other) {
        if (other == null) {
            throw new IllegalArgumentException("other should not be null");
        }
        int localSize = this.path.size();
        List<PathArgument> otherPath = other.getPath();
        if (localSize > other.path.size()) {
            return false;
        }
        for (int i = 0; i < localSize; ++i) {
            if (this.path.get(i).equals(otherPath.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.to_string_cache != null) {
            return this.to_string_cache;
        }
        StringBuilder builder = new StringBuilder();
        for (PathArgument argument : this.path) {
            builder.append("/");
            builder.append(argument.toString());
        }
        this.to_string_cache = builder.toString();
        return this.to_string_cache;
    }

    public static InstanceIdentifierBuilder builder(QName node) {
        return InstanceIdentifier.builder().node(node);
    }

    private static class BuilderImpl
    implements InstanceIdentifierBuilder {
        private final ImmutableList.Builder<PathArgument> path = ImmutableList.builder();

        public BuilderImpl() {
        }

        public BuilderImpl(List<? extends PathArgument> prefix) {
            this.path.addAll(prefix);
        }

        @Override
        public InstanceIdentifierBuilder node(QName nodeType) {
            this.path.add((Object)new NodeIdentifier(nodeType));
            return this;
        }

        @Override
        public InstanceIdentifierBuilder nodeWithKey(QName nodeType, QName key, Object value) {
            this.path.add((Object)new NodeIdentifierWithPredicates(nodeType, key, value));
            return this;
        }

        @Override
        public InstanceIdentifierBuilder nodeWithKey(QName nodeType, Map<QName, Object> keyValues) {
            this.path.add((Object)new NodeIdentifierWithPredicates(nodeType, keyValues));
            return this;
        }

        public InstanceIdentifier toInstance() {
            return new InstanceIdentifier((List<? extends PathArgument>)this.path.build());
        }

        @Override
        public InstanceIdentifier getIdentifier() {
            return this.toInstance();
        }
    }

    public static final class NodeWithValue
    implements PathArgument {
        private static final long serialVersionUID = -3637456085341738431L;
        private final QName nodeType;
        private final Object value;

        public NodeWithValue(QName node, Object value) {
            this.nodeType = node;
            this.value = value;
        }

        @Override
        public QName getNodeType() {
            return this.nodeType;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeWithValue other = (NodeWithValue)obj;
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return !(this.nodeType == null ? other.nodeType != null : !this.nodeType.equals((Object)other.nodeType));
        }

        public String toString() {
            return this.nodeType + "[" + this.value + "]";
        }
    }

    public static final class NodeIdentifierWithPredicates
    implements PathArgument {
        private static final long serialVersionUID = -4787195606494761540L;
        private final QName nodeType;
        private final Map<QName, Object> keyValues;

        public NodeIdentifierWithPredicates(QName node, Map<QName, Object> keyValues) {
            this.nodeType = node;
            this.keyValues = Collections.unmodifiableMap(new HashMap<QName, Object>(keyValues));
        }

        public NodeIdentifierWithPredicates(QName node, QName key, Object value) {
            this.nodeType = node;
            this.keyValues = Collections.singletonMap(key, value);
        }

        @Override
        public QName getNodeType() {
            return this.nodeType;
        }

        public Map<QName, Object> getKeyValues() {
            return this.keyValues;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keyValues == null ? 0 : this.keyValues.hashCode());
            result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeIdentifierWithPredicates other = (NodeIdentifierWithPredicates)obj;
            if (this.keyValues == null ? other.keyValues != null : !this.keyValues.equals(other.keyValues)) {
                return false;
            }
            return !(this.nodeType == null ? other.nodeType != null : !this.nodeType.equals((Object)other.nodeType));
        }

        public String toString() {
            return this.nodeType + "[" + this.keyValues + "]";
        }
    }

    public static final class NodeIdentifier
    implements PathArgument {
        private static final long serialVersionUID = -2255888212390871347L;
        private final QName nodeType;

        public NodeIdentifier(QName node) {
            this.nodeType = node;
        }

        @Override
        public QName getNodeType() {
            return this.nodeType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeIdentifier other = (NodeIdentifier)obj;
            return !(this.nodeType == null ? other.nodeType != null : !this.nodeType.equals((Object)other.nodeType));
        }

        public String toString() {
            return this.nodeType.toString();
        }
    }

    public static interface InstanceIdentifierBuilder
    extends Builder<InstanceIdentifier> {
        public InstanceIdentifierBuilder node(QName var1);

        public InstanceIdentifierBuilder nodeWithKey(QName var1, Map<QName, Object> var2);

        public InstanceIdentifierBuilder nodeWithKey(QName var1, QName var2, Object var3);

        @Deprecated
        public InstanceIdentifier getIdentifier();
    }

    public static interface PathArgument
    extends Immutable,
    Serializable {
        public QName getNodeType();
    }
}

