/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class NeutronSubnet_IPAllocationPool
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="start")
    String poolStart;
    @XmlElement(name="end")
    String poolEnd;

    public NeutronSubnet_IPAllocationPool() {
    }

    public NeutronSubnet_IPAllocationPool(String lowAddress, String highAddress) {
        this.poolStart = lowAddress;
        this.poolEnd = highAddress;
    }

    public String getPoolStart() {
        return this.poolStart;
    }

    public void setPoolStart(String poolStart) {
        this.poolStart = poolStart;
    }

    public String getPoolEnd() {
        return this.poolEnd;
    }

    public void setPoolEnd(String poolEnd) {
        this.poolEnd = poolEnd;
    }

    public boolean contains(String inputString) {
        long inputIP = NeutronSubnet_IPAllocationPool.convert(inputString);
        long startIP = NeutronSubnet_IPAllocationPool.convert(this.poolStart);
        long endIP = NeutronSubnet_IPAllocationPool.convert(this.poolEnd);
        return inputIP >= startIP && inputIP <= endIP;
    }

    static long convert(String inputString) {
        long ans = 0L;
        if (inputString != null) {
            String[] parts;
            for (String part : parts = inputString.split("\\.")) {
                ans <<= 8;
                ans |= (long)Integer.parseInt(part);
            }
        }
        return ans;
    }

    static String longtoIP(long l) {
        String[] parts = new String[4];
        for (int i = 0; i < 4; ++i) {
            parts[3 - i] = String.valueOf(l & 0xFFL);
            l >>= 8;
        }
        return NeutronSubnet_IPAllocationPool.join(parts, ".");
    }

    public static String join(String[] r, String d) {
        int i;
        if (r.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < r.length - 1; ++i) {
            sb.append(r[i] + d);
        }
        return sb.toString() + r[i];
    }

    public List<NeutronSubnet_IPAllocationPool> splitPool(String ipAddress) {
        ArrayList<NeutronSubnet_IPAllocationPool> ans = new ArrayList<NeutronSubnet_IPAllocationPool>();
        long gIP = NeutronSubnet_IPAllocationPool.convert(ipAddress);
        long sIP = NeutronSubnet_IPAllocationPool.convert(this.poolStart);
        long eIP = NeutronSubnet_IPAllocationPool.convert(this.poolEnd);
        NeutronSubnet_IPAllocationPool p = new NeutronSubnet_IPAllocationPool();
        boolean poolStarted = false;
        for (long i = sIP; i <= eIP; ++i) {
            if (i == sIP && i != gIP) {
                p.setPoolStart(this.poolStart);
                poolStarted = true;
            }
            if (i == eIP) {
                if (i != gIP) {
                    p.setPoolEnd(this.poolEnd);
                } else {
                    p.setPoolEnd(NeutronSubnet_IPAllocationPool.longtoIP(i - 1L));
                }
                ans.add(p);
            }
            if (i == sIP || i == eIP) continue;
            if (i != gIP) {
                if (poolStarted) continue;
                p.setPoolStart(NeutronSubnet_IPAllocationPool.longtoIP(i));
                poolStarted = true;
                continue;
            }
            p.setPoolEnd(NeutronSubnet_IPAllocationPool.longtoIP(i - 1L));
            poolStarted = false;
            ans.add(p);
            p = new NeutronSubnet_IPAllocationPool();
        }
        return ans;
    }
}

