/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.net.util.SubnetUtils;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.networkconfig.neutron.NeutronPort;
import org.opendaylight.controller.networkconfig.neutron.NeutronSubnet_HostRoute;
import org.opendaylight.controller.networkconfig.neutron.NeutronSubnet_IPAllocationPool;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class NeutronSubnet
extends ConfigurationObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id")
    String subnetUUID;
    @XmlElement(name="network_id")
    String networkUUID;
    @XmlElement(name="name")
    String name;
    @XmlElement(defaultValue="4", name="ip_version")
    Integer ipVersion;
    @XmlElement(name="cidr")
    String cidr;
    @XmlElement(name="gateway_ip")
    String gatewayIP;
    @XmlElement(name="dns_nameservers")
    List<String> dnsNameservers;
    @XmlElement(name="allocation_pools")
    List<NeutronSubnet_IPAllocationPool> allocationPools;
    @XmlElement(name="host_routes")
    List<NeutronSubnet_HostRoute> hostRoutes;
    @XmlElement(defaultValue="true", name="enable_dhcp")
    Boolean enableDHCP;
    @XmlElement(name="tenant_id")
    String tenantID;
    List<NeutronPort> myPorts = new ArrayList<NeutronPort>();
    boolean gatewayIPAssigned;

    public String getID() {
        return this.subnetUUID;
    }

    public String getSubnetUUID() {
        return this.subnetUUID;
    }

    public void setSubnetUUID(String subnetUUID) {
        this.subnetUUID = subnetUUID;
    }

    public String getNetworkUUID() {
        return this.networkUUID;
    }

    public void setNetworkUUID(String networkUUID) {
        this.networkUUID = networkUUID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getIpVersion() {
        return this.ipVersion;
    }

    public void setIpVersion(Integer ipVersion) {
        this.ipVersion = ipVersion;
    }

    public String getCidr() {
        return this.cidr;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public String getGatewayIP() {
        return this.gatewayIP;
    }

    public void setGatewayIP(String gatewayIP) {
        this.gatewayIP = gatewayIP;
    }

    public List<String> getDnsNameservers() {
        return this.dnsNameservers;
    }

    public void setDnsNameservers(List<String> dnsNameservers) {
        this.dnsNameservers = dnsNameservers;
    }

    public List<NeutronSubnet_IPAllocationPool> getAllocationPools() {
        return this.allocationPools;
    }

    public void setAllocationPools(List<NeutronSubnet_IPAllocationPool> allocationPools) {
        this.allocationPools = allocationPools;
    }

    public List<NeutronSubnet_HostRoute> getHostRoutes() {
        return this.hostRoutes;
    }

    public void setHostRoutes(List<NeutronSubnet_HostRoute> hostRoutes) {
        this.hostRoutes = hostRoutes;
    }

    public boolean isEnableDHCP() {
        if (this.enableDHCP == null) {
            return true;
        }
        return this.enableDHCP;
    }

    public Boolean getEnableDHCP() {
        return this.enableDHCP;
    }

    public void setEnableDHCP(Boolean newValue) {
        this.enableDHCP = newValue;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    public NeutronSubnet extractFields(List<String> fields) {
        NeutronSubnet ans = new NeutronSubnet();
        for (String s : fields) {
            if (s.equals("id")) {
                ans.setSubnetUUID(this.getSubnetUUID());
            }
            if (s.equals("network_id")) {
                ans.setNetworkUUID(this.getNetworkUUID());
            }
            if (s.equals("name")) {
                ans.setName(this.getName());
            }
            if (s.equals("ip_version")) {
                ans.setIpVersion(this.getIpVersion());
            }
            if (s.equals("cidr")) {
                ans.setCidr(this.getCidr());
            }
            if (s.equals("gateway_ip")) {
                ans.setGatewayIP(this.getGatewayIP());
            }
            if (s.equals("dns_nameservers")) {
                ArrayList<String> nsList = new ArrayList<String>();
                nsList.addAll(this.getDnsNameservers());
                ans.setDnsNameservers(nsList);
            }
            if (s.equals("allocation_pools")) {
                ArrayList<NeutronSubnet_IPAllocationPool> aPools = new ArrayList<NeutronSubnet_IPAllocationPool>();
                aPools.addAll(this.getAllocationPools());
                ans.setAllocationPools(aPools);
            }
            if (s.equals("host_routes")) {
                ArrayList<NeutronSubnet_HostRoute> hRoutes = new ArrayList<NeutronSubnet_HostRoute>();
                hRoutes.addAll(this.getHostRoutes());
                ans.setHostRoutes(hRoutes);
            }
            if (s.equals("enable_dhcp")) {
                ans.setEnableDHCP(this.getEnableDHCP());
            }
            if (!s.equals("tenant_id")) continue;
            ans.setTenantID(this.getTenantID());
        }
        return ans;
    }

    public boolean isValidCIDR() {
        try {
            SubnetUtils util = new SubnetUtils(this.cidr);
            SubnetUtils.SubnetInfo info = util.getInfo();
            if (!info.getNetworkAddress().equals(info.getAddress())) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean gatewayIP_Pool_overlap() {
        for (NeutronSubnet_IPAllocationPool pool : this.allocationPools) {
            if (!pool.contains(this.gatewayIP)) continue;
            return true;
        }
        return false;
    }

    public boolean initDefaults() {
        if (this.enableDHCP == null) {
            this.enableDHCP = true;
        }
        if (this.ipVersion == null) {
            this.ipVersion = 4;
        }
        this.gatewayIPAssigned = false;
        this.dnsNameservers = new ArrayList<String>();
        this.allocationPools = new ArrayList<NeutronSubnet_IPAllocationPool>();
        this.hostRoutes = new ArrayList<NeutronSubnet_HostRoute>();
        try {
            SubnetUtils util = new SubnetUtils(this.cidr);
            SubnetUtils.SubnetInfo info = util.getInfo();
            if (this.gatewayIP == null) {
                this.gatewayIP = info.getLowAddress();
            }
            if (this.allocationPools.size() < 1) {
                NeutronSubnet_IPAllocationPool source = new NeutronSubnet_IPAllocationPool(info.getLowAddress(), info.getHighAddress());
                this.allocationPools = source.splitPool(this.gatewayIP);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public List<NeutronPort> getPortsInSubnet() {
        return this.myPorts;
    }

    public void addPort(NeutronPort port) {
        this.myPorts.add(port);
    }

    public void removePort(NeutronPort port) {
        this.myPorts.remove(port);
    }

    public boolean isValidIP(String ipAddress) {
        try {
            SubnetUtils util = new SubnetUtils(this.cidr);
            SubnetUtils.SubnetInfo info = util.getInfo();
            return info.isInRange(ipAddress);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isIPInUse(String ipAddress) {
        if (ipAddress.equals(this.gatewayIP) && !this.gatewayIPAssigned) {
            return false;
        }
        for (NeutronSubnet_IPAllocationPool pool : this.allocationPools) {
            if (!pool.contains(ipAddress)) continue;
            return false;
        }
        return true;
    }

    public String getLowAddr() {
        String ans = null;
        for (NeutronSubnet_IPAllocationPool pool : this.allocationPools) {
            if (ans == null) {
                ans = pool.getPoolStart();
                continue;
            }
            if (NeutronSubnet_IPAllocationPool.convert(pool.getPoolStart()) >= NeutronSubnet_IPAllocationPool.convert(ans)) continue;
            ans = pool.getPoolStart();
        }
        return ans;
    }

    public void allocateIP(String ipAddress) {
        Iterator<NeutronSubnet_IPAllocationPool> i = this.allocationPools.iterator();
        ArrayList<NeutronSubnet_IPAllocationPool> newList = new ArrayList<NeutronSubnet_IPAllocationPool>();
        while (i.hasNext()) {
            NeutronSubnet_IPAllocationPool pool = i.next();
            if (pool.getPoolEnd().equalsIgnoreCase(ipAddress) && pool.getPoolStart().equalsIgnoreCase(ipAddress)) continue;
            if (pool.contains(ipAddress)) {
                List<NeutronSubnet_IPAllocationPool> pools = pool.splitPool(ipAddress);
                newList.addAll(pools);
                continue;
            }
            newList.add(pool);
        }
        this.allocationPools = newList;
    }

    public void releaseIP(String ipAddress) {
        NeutronSubnet_IPAllocationPool lPool = null;
        NeutronSubnet_IPAllocationPool hPool = null;
        Iterator<NeutronSubnet_IPAllocationPool> i = this.allocationPools.iterator();
        long sIP = NeutronSubnet_IPAllocationPool.convert(ipAddress);
        while (i.hasNext()) {
            NeutronSubnet_IPAllocationPool pool = i.next();
            long lIP = NeutronSubnet_IPAllocationPool.convert(pool.getPoolStart());
            long hIP = NeutronSubnet_IPAllocationPool.convert(pool.getPoolEnd());
            if (sIP + 1L == lIP) {
                hPool = pool;
            }
            if (sIP - 1L != hIP) continue;
            lPool = pool;
        }
        if (lPool == null && hPool == null) {
            this.allocationPools.add(new NeutronSubnet_IPAllocationPool(ipAddress, ipAddress));
        }
        if (lPool == null && hPool != null) {
            hPool.setPoolStart(ipAddress);
        }
        if (lPool != null && hPool == null) {
            lPool.setPoolEnd(ipAddress);
        }
        if (lPool != null && hPool != null) {
            this.allocationPools.remove(lPool);
            this.allocationPools.remove(hPool);
            this.allocationPools.add(new NeutronSubnet_IPAllocationPool(lPool.getPoolStart(), hPool.getPoolEnd()));
        }
    }

    public void setGatewayIPAllocated() {
        this.gatewayIPAssigned = true;
    }

    public void resetGatewayIPAllocated() {
        this.gatewayIPAssigned = false;
    }

    public String toString() {
        return "NeutronSubnet [subnetUUID=" + this.subnetUUID + ", networkUUID=" + this.networkUUID + ", name=" + this.name + ", ipVersion=" + this.ipVersion + ", cidr=" + this.cidr + ", gatewayIP=" + this.gatewayIP + ", dnsNameservers=" + this.dnsNameservers + ", allocationPools=" + this.allocationPools + ", hostRoutes=" + this.hostRoutes + ", enableDHCP=" + this.enableDHCP + ", tenantID=" + this.tenantID + ", myPorts=" + this.myPorts + ", gatewayIPAssigned=" + this.gatewayIPAssigned + "]";
    }
}

