/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.networkconfig.neutron.NeutronRouter_Interface;
import org.opendaylight.controller.networkconfig.neutron.NeutronRouter_NetworkReference;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class NeutronRouter
extends ConfigurationObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id")
    String routerUUID;
    @XmlElement(name="name")
    String name;
    @XmlElement(defaultValue="true", name="admin_state_up")
    Boolean adminStateUp;
    @XmlElement(name="status")
    String status;
    @XmlElement(name="tenant_id")
    String tenantID;
    @XmlElement(name="external_gateway_info")
    NeutronRouter_NetworkReference externalGatewayInfo;
    HashMap<String, NeutronRouter_Interface> interfaces = new HashMap();

    public String getID() {
        return this.routerUUID;
    }

    public String getRouterUUID() {
        return this.routerUUID;
    }

    public void setRouterUUID(String routerUUID) {
        this.routerUUID = routerUUID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAdminStateUp() {
        if (this.adminStateUp == null) {
            return true;
        }
        return this.adminStateUp;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public void setAdminStateUp(Boolean newValue) {
        this.adminStateUp = newValue;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    public NeutronRouter_NetworkReference getExternalGatewayInfo() {
        return this.externalGatewayInfo;
    }

    public void setExternalGatewayInfo(NeutronRouter_NetworkReference externalGatewayInfo) {
        this.externalGatewayInfo = externalGatewayInfo;
    }

    public NeutronRouter extractFields(List<String> fields) {
        NeutronRouter ans = new NeutronRouter();
        for (String s : fields) {
            if (s.equals("id")) {
                ans.setRouterUUID(this.getRouterUUID());
            }
            if (s.equals("name")) {
                ans.setName(this.getName());
            }
            if (s.equals("admin_state_up")) {
                ans.setAdminStateUp(this.getAdminStateUp());
            }
            if (s.equals("status")) {
                ans.setStatus(this.getStatus());
            }
            if (s.equals("tenant_id")) {
                ans.setTenantID(this.getTenantID());
            }
            if (!s.equals("external_gateway_info")) continue;
            ans.setExternalGatewayInfo(this.getExternalGatewayInfo());
        }
        return ans;
    }

    public HashMap<String, NeutronRouter_Interface> getInterfaces() {
        return this.interfaces;
    }

    public void addInterface(String s, NeutronRouter_Interface i) {
        this.interfaces.put(s, i);
    }

    public void removeInterface(String s) {
        this.interfaces.remove(s);
    }

    public void initDefaults() {
        this.adminStateUp = true;
    }
}

