/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.networkconfig.neutron.NeutronFloatingIP;
import org.opendaylight.controller.networkconfig.neutron.Neutron_IPs;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class NeutronPort
extends ConfigurationObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id")
    String portUUID;
    @XmlElement(name="network_id")
    String networkUUID;
    @XmlElement(name="name")
    String name;
    @XmlElement(defaultValue="true", name="admin_state_up")
    Boolean adminStateUp;
    @XmlElement(name="status")
    String status;
    @XmlElement(name="mac_address")
    String macAddress;
    @XmlElement(name="fixed_ips")
    List<Neutron_IPs> fixedIPs;
    @XmlElement(name="device_id")
    String deviceID;
    @XmlElement(name="device_owner")
    String deviceOwner;
    @XmlElement(name="tenant_id")
    String tenantID;
    HashMap<String, NeutronFloatingIP> floatingIPMap = new HashMap();

    public String getID() {
        return this.portUUID;
    }

    public String getPortUUID() {
        return this.portUUID;
    }

    public void setPortUUID(String portUUID) {
        this.portUUID = portUUID;
    }

    public String getNetworkUUID() {
        return this.networkUUID;
    }

    public void setNetworkUUID(String networkUUID) {
        this.networkUUID = networkUUID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAdminStateUp() {
        if (this.adminStateUp == null) {
            return true;
        }
        return this.adminStateUp;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public void setAdminStateUp(Boolean newValue) {
        this.adminStateUp = newValue;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public List<Neutron_IPs> getFixedIPs() {
        return this.fixedIPs;
    }

    public void setFixedIPs(List<Neutron_IPs> fixedIPs) {
        this.fixedIPs = fixedIPs;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public String getDeviceOwner() {
        return this.deviceOwner;
    }

    public void setDeviceOwner(String deviceOwner) {
        this.deviceOwner = deviceOwner;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    public NeutronFloatingIP getFloatingIP(String key) {
        if (!this.floatingIPMap.containsKey(key)) {
            return null;
        }
        return this.floatingIPMap.get(key);
    }

    public void removeFloatingIP(String key) {
        this.floatingIPMap.remove(key);
    }

    public void addFloatingIP(String key, NeutronFloatingIP floatingIP) {
        if (!this.floatingIPMap.containsKey(key)) {
            this.floatingIPMap.put(key, floatingIP);
        }
    }

    public NeutronPort extractFields(List<String> fields) {
        NeutronPort ans = new NeutronPort();
        for (String s : fields) {
            if (s.equals("id")) {
                ans.setPortUUID(this.getPortUUID());
            }
            if (s.equals("network_id")) {
                ans.setNetworkUUID(this.getNetworkUUID());
            }
            if (s.equals("name")) {
                ans.setName(this.getName());
            }
            if (s.equals("admin_state_up")) {
                ans.setAdminStateUp(this.getAdminStateUp());
            }
            if (s.equals("status")) {
                ans.setStatus(this.getStatus());
            }
            if (s.equals("mac_address")) {
                ans.setMacAddress(this.getMacAddress());
            }
            if (s.equals("fixed_ips")) {
                ArrayList<Neutron_IPs> fixedIPs = new ArrayList<Neutron_IPs>();
                fixedIPs.addAll(this.getFixedIPs());
                ans.setFixedIPs(fixedIPs);
            }
            if (s.equals("device_id")) {
                ans.setDeviceID(this.getDeviceID());
            }
            if (s.equals("device_owner")) {
                ans.setDeviceOwner(this.getDeviceOwner());
            }
            if (!s.equals("tenant_id")) continue;
            ans.setTenantID(this.getTenantID());
        }
        return ans;
    }

    public void initDefaults() {
        this.adminStateUp = true;
        if (this.status == null) {
            this.status = "ACTIVE";
        }
        if (this.fixedIPs == null) {
            this.fixedIPs = new ArrayList<Neutron_IPs>();
        }
    }

    public boolean isBoundToFloatingIP(String fixedIP) {
        return this.floatingIPMap.containsKey(fixedIP);
    }

    public String toString() {
        return "NeutronPort [portUUID=" + this.portUUID + ", networkUUID=" + this.networkUUID + ", name=" + this.name + ", adminStateUp=" + this.adminStateUp + ", status=" + this.status + ", macAddress=" + this.macAddress + ", fixedIPs=" + this.fixedIPs + ", deviceID=" + this.deviceID + ", deviceOwner=" + this.deviceOwner + ", tenantID=" + this.tenantID + ", floatingIPMap=" + this.floatingIPMap + "]";
    }
}

