/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.networkconfig.neutron.NeutronPort;

@XmlRootElement(name="network")
@XmlAccessorType(value=XmlAccessType.NONE)
public class NeutronNetwork
extends ConfigurationObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id")
    String networkUUID;
    @XmlElement(name="name")
    String networkName;
    @XmlElement(defaultValue="true", name="admin_state_up")
    Boolean adminStateUp;
    @XmlElement(defaultValue="false", name="shared")
    Boolean shared;
    @XmlElement(name="tenant_id")
    String tenantID;
    @XmlElement(defaultValue="false", namespace="router", name="external")
    Boolean routerExternal;
    @XmlElement(defaultValue="flat", namespace="provider", name="network_type")
    String providerNetworkType;
    @XmlElement(namespace="provider", name="physical_network")
    String providerPhysicalNetwork;
    @XmlElement(namespace="provider", name="segmentation_id")
    String providerSegmentationID;
    @XmlElement(name="status")
    String status;
    @XmlElement(name="subnets")
    List<String> subnets;
    List<NeutronPort> myPorts = new ArrayList<NeutronPort>();

    public void initDefaults() {
        this.subnets = new ArrayList<String>();
        if (this.status == null) {
            this.status = "ACTIVE";
        }
        if (this.adminStateUp == null) {
            this.adminStateUp = true;
        }
        if (this.shared == null) {
            this.shared = false;
        }
        if (this.routerExternal == null) {
            this.routerExternal = false;
        }
        if (this.providerNetworkType == null) {
            this.providerNetworkType = "flat";
        }
    }

    public String getID() {
        return this.networkUUID;
    }

    public String getNetworkUUID() {
        return this.networkUUID;
    }

    public void setNetworkUUID(String networkUUID) {
        this.networkUUID = networkUUID;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public void setAdminStateUp(boolean newValue) {
        this.adminStateUp = newValue;
    }

    public boolean isShared() {
        return this.shared;
    }

    public Boolean getShared() {
        return this.shared;
    }

    public void setShared(boolean newValue) {
        this.shared = newValue;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    public boolean isRouterExternal() {
        return this.routerExternal;
    }

    public Boolean getRouterExternal() {
        return this.routerExternal;
    }

    public void setRouterExternal(boolean newValue) {
        this.routerExternal = newValue;
    }

    public String getProviderNetworkType() {
        return this.providerNetworkType;
    }

    public void setProviderNetworkType(String providerNetworkType) {
        this.providerNetworkType = providerNetworkType;
    }

    public String getProviderPhysicalNetwork() {
        return this.providerPhysicalNetwork;
    }

    public void setProviderPhysicalNetwork(String providerPhysicalNetwork) {
        this.providerPhysicalNetwork = providerPhysicalNetwork;
    }

    public String getProviderSegmentationID() {
        return this.providerSegmentationID;
    }

    public void setProviderSegmentationID(String providerSegmentationID) {
        this.providerSegmentationID = providerSegmentationID;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(List<String> subnets) {
        this.subnets = subnets;
    }

    public void addSubnet(String uuid) {
        this.subnets.add(uuid);
    }

    public void removeSubnet(String uuid) {
        this.subnets.remove(uuid);
    }

    public List<NeutronPort> getPortsOnNetwork() {
        return this.myPorts;
    }

    public void addPort(NeutronPort port) {
        this.myPorts.add(port);
    }

    public void removePort(NeutronPort port) {
        this.myPorts.remove(port);
    }

    public NeutronNetwork extractFields(List<String> fields) {
        NeutronNetwork ans = new NeutronNetwork();
        for (String s : fields) {
            if (s.equals("id")) {
                ans.setNetworkUUID(this.getNetworkUUID());
            }
            if (s.equals("name")) {
                ans.setNetworkName(this.getNetworkName());
            }
            if (s.equals("admin_state_up")) {
                ans.setAdminStateUp(this.adminStateUp);
            }
            if (s.equals("status")) {
                ans.setStatus(this.getStatus());
            }
            if (s.equals("subnets")) {
                ArrayList<String> subnetList = new ArrayList<String>();
                subnetList.addAll(this.getSubnets());
                ans.setSubnets(subnetList);
            }
            if (s.equals("shared")) {
                ans.setShared(this.shared);
            }
            if (!s.equals("tenant_id")) continue;
            ans.setTenantID(this.getTenantID());
        }
        return ans;
    }

    public String toString() {
        return "NeutronNetwork [networkUUID=" + this.networkUUID + ", networkName=" + this.networkName + ", adminStateUp=" + this.adminStateUp + ", shared=" + this.shared + ", tenantID=" + this.tenantID + ", routerExternal=" + this.routerExternal + ", providerNetworkType=" + this.providerNetworkType + ", providerPhysicalNetwork=" + this.providerPhysicalNetwork + ", providerSegmentationID=" + this.providerSegmentationID + ", status=" + this.status + ", subnets=" + this.subnets + ", myPorts=" + this.myPorts + "]";
    }
}

