/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.md.controller.topology.manager;

import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.sal.binding.api.AbstractBindingAwareProvider;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.md.controller.topology.manager.FlowCapableTopologyExporter;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowCapableTopologyProvider
extends AbstractBindingAwareProvider
implements AutoCloseable {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(FlowCapableTopologyProvider.class);
            return _logger;
        }
    }.apply();
    private DataProviderService _dataService;
    private NotificationProviderService _notificationService;
    private final FlowCapableTopologyExporter exporter = new Functions.Function0<FlowCapableTopologyExporter>(){

        public FlowCapableTopologyExporter apply() {
            FlowCapableTopologyExporter _flowCapableTopologyExporter = new FlowCapableTopologyExporter();
            return _flowCapableTopologyExporter;
        }
    }.apply();
    private Registration<NotificationListener> listenerRegistration;

    public DataProviderService getDataService() {
        return this._dataService;
    }

    public void setDataService(DataProviderService dataService) {
        this._dataService = dataService;
    }

    public NotificationProviderService getNotificationService() {
        return this._notificationService;
    }

    public void setNotificationService(NotificationProviderService notificationService) {
        this._notificationService = notificationService;
    }

    @Override
    public void close() {
        try {
            LOG.info("FlowCapableTopologyProvider stopped.");
            if (this.listenerRegistration != null) {
                this.listenerRegistration.close();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        Registration _registerNotificationListener;
        DataProviderService _sALService = (DataProviderService)session.getSALService(DataProviderService.class);
        this.setDataService(_sALService);
        NotificationProviderService _sALService_1 = (NotificationProviderService)session.getSALService(NotificationProviderService.class);
        this.setNotificationService(_sALService_1);
        DataProviderService _dataService = this.getDataService();
        this.exporter.setDataService(_dataService);
        this.exporter.start();
        NotificationProviderService _notificationService = this.getNotificationService();
        this.listenerRegistration = _registerNotificationListener = _notificationService.registerNotificationListener((NotificationListener)this.exporter);
    }
}

