/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.md.controller.topology.manager;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.List;
import java.util.concurrent.Future;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.binding.util.TypeSafeDataReader;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.md.controller.topology.manager.FlowCapableNodeMapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.FlowTopologyDiscoveryListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.Link;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.LinkDiscovered;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.LinkOverutilized;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.LinkRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.LinkUtilizationNormal;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.flow.capable.port.State;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.OpendaylightInventoryListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Destination;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Source;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.LinkKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPoint;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPointKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;

public class FlowCapableTopologyExporter
implements FlowTopologyDiscoveryListener,
OpendaylightInventoryListener {
    private TopologyKey topology = new Functions.Function0<TopologyKey>(){

        public TopologyKey apply() {
            TopologyId _topologyId = new TopologyId("flow:1");
            TopologyKey _topologyKey = new TopologyKey(_topologyId);
            return _topologyKey;
        }
    }.apply();
    private DataProviderService _dataService;

    public DataProviderService getDataService() {
        return this._dataService;
    }

    public void setDataService(DataProviderService dataService) {
        this._dataService = dataService;
    }

    public Future<RpcResult<TransactionStatus>> start() {
        Future _commit;
        TopologyBuilder _topologyBuilder;
        Future _xblockexpression = null;
        TopologyBuilder tb = _topologyBuilder = new TopologyBuilder();
        tb.setKey(this.topology);
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(NetworkTopology.class);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(Topology.class, (Identifier)this.topology);
        InstanceIdentifier path = (InstanceIdentifier)_child.toInstance();
        Topology top = tb.build();
        DataProviderService _dataService = this.getDataService();
        DataModificationTransaction it = _dataService.beginTransaction();
        it.putOperationalData((Object)path, (Object)top);
        _xblockexpression = _commit = it.commit();
        return _xblockexpression;
    }

    public void onNodeRemoved(NodeRemoved notification) {
        NodeRef _nodeRef = notification.getNodeRef();
        NodeKey _nodeKey = FlowCapableNodeMapping.getNodeKey(_nodeRef);
        NodeId _id = _nodeKey.getId();
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId nodeId = FlowCapableNodeMapping.toToplogyNodeId(_id);
        NodeRef _nodeRef_1 = notification.getNodeRef();
        InstanceIdentifier<Node> nodeInstance = this.toNodeIdentifier(_nodeRef_1);
        DataProviderService _dataService = this.getDataService();
        DataModificationTransaction it = _dataService.beginTransaction();
        it.removeOperationalData(nodeInstance);
        this.removeAffectedLinks(it, nodeId);
        it.commit();
    }

    public void onNodeUpdated(NodeUpdated notification) {
        boolean _notEquals;
        FlowCapableNodeUpdated fcnu = (FlowCapableNodeUpdated)notification.getAugmentation(FlowCapableNodeUpdated.class);
        boolean bl = _notEquals = !Objects.equal((Object)fcnu, null);
        if (_notEquals) {
            NodeId _id = notification.getId();
            org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId _toplogyNodeId = FlowCapableNodeMapping.toToplogyNodeId(_id);
            NodeRef _nodeRef = notification.getNodeRef();
            Node node = FlowCapableNodeMapping.toTopologyNode(_toplogyNodeId, _nodeRef);
            NodeId _id_1 = notification.getId();
            org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId _toplogyNodeId_1 = FlowCapableNodeMapping.toToplogyNodeId(_id_1);
            InstanceIdentifier<Node> path = this.nodePath(_toplogyNodeId_1);
            DataProviderService _dataService = this.getDataService();
            DataModificationTransaction it = _dataService.beginTransaction();
            it.putOperationalData(path, (Object)node);
            it.commit();
        }
    }

    public void onNodeConnectorRemoved(NodeConnectorRemoved notification) {
        NodeConnectorRef _nodeConnectorRef = notification.getNodeConnectorRef();
        InstanceIdentifier<TerminationPoint> tpInstance = this.toTerminationPointIdentifier(_nodeConnectorRef);
        NodeConnectorRef _nodeConnectorRef_1 = notification.getNodeConnectorRef();
        NodeConnectorKey _nodeConnectorKey = FlowCapableNodeMapping.getNodeConnectorKey(_nodeConnectorRef_1);
        NodeConnectorId _id = _nodeConnectorKey.getId();
        TpId tpId = FlowCapableNodeMapping.toTerminationPointId(_id);
        DataProviderService _dataService = this.getDataService();
        DataModificationTransaction it = _dataService.beginTransaction();
        it.removeOperationalData(tpInstance);
        this.removeAffectedLinks(it, tpId);
        it.commit();
    }

    public void onNodeConnectorUpdated(NodeConnectorUpdated notification) {
        boolean _notEquals;
        FlowCapableNodeConnectorUpdated fcncu = (FlowCapableNodeConnectorUpdated)notification.getAugmentation(FlowCapableNodeConnectorUpdated.class);
        boolean bl = _notEquals = !Objects.equal((Object)fcncu, null);
        if (_notEquals) {
            boolean _notEquals_1;
            NodeConnectorRef _nodeConnectorRef = notification.getNodeConnectorRef();
            NodeKey _nodeKey = FlowCapableNodeMapping.getNodeKey(_nodeConnectorRef);
            NodeId _id = _nodeKey.getId();
            org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId nodeId = FlowCapableNodeMapping.toToplogyNodeId(_id);
            NodeConnectorId _id_1 = notification.getId();
            TpId _terminationPointId = FlowCapableNodeMapping.toTerminationPointId(_id_1);
            NodeConnectorRef _nodeConnectorRef_1 = notification.getNodeConnectorRef();
            TerminationPoint point = FlowCapableNodeMapping.toTerminationPoint(_terminationPointId, _nodeConnectorRef_1);
            TerminationPointKey _key = point.getKey();
            TpId _tpId = _key.getTpId();
            InstanceIdentifier<TerminationPoint> path = this.tpPath(nodeId, _tpId);
            DataProviderService _dataService = this.getDataService();
            DataModificationTransaction it = _dataService.beginTransaction();
            it.putOperationalData(path, (Object)point);
            boolean _or = false;
            boolean _and = false;
            State _state = fcncu.getState();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_state, null);
            if (!_notEquals_1) {
                _and = false;
            } else {
                State _state_1 = fcncu.getState();
                Boolean _isLinkDown = _state_1.isLinkDown();
                boolean bl3 = _and = _notEquals_1 && _isLinkDown != false;
            }
            if (_and) {
                _or = true;
            } else {
                boolean _notEquals_2;
                boolean _and_1 = false;
                PortConfig _configuration = fcncu.getConfiguration();
                boolean bl4 = _notEquals_2 = !Objects.equal((Object)_configuration, null);
                if (!_notEquals_2) {
                    _and_1 = false;
                } else {
                    PortConfig _configuration_1 = fcncu.getConfiguration();
                    Boolean _isPORTDOWN = _configuration_1.isPORTDOWN();
                    _and_1 = _notEquals_2 && _isPORTDOWN != false;
                }
                boolean bl5 = _or = _and || _and_1;
            }
            if (_or) {
                TpId _tpId_1 = point.getTpId();
                this.removeAffectedLinks(it, _tpId_1);
            }
            it.commit();
        }
    }

    public void onLinkDiscovered(LinkDiscovered notification) {
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link link = FlowCapableNodeMapping.toTopologyLink((Link)notification);
        InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link> path = this.linkPath(link);
        DataProviderService _dataService = this.getDataService();
        DataModificationTransaction it = _dataService.beginTransaction();
        it.putOperationalData(path, (Object)link);
        it.commit();
    }

    public void onLinkOverutilized(LinkOverutilized notification) {
    }

    public void onLinkRemoved(LinkRemoved notification) {
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link _topologyLink = FlowCapableNodeMapping.toTopologyLink((Link)notification);
        InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link> path = this.linkPath(_topologyLink);
        DataProviderService _dataService = this.getDataService();
        DataModificationTransaction it = _dataService.beginTransaction();
        it.removeOperationalData(path);
        it.commit();
    }

    public void onLinkUtilizationNormal(LinkUtilizationNormal notification) {
    }

    public InstanceIdentifier<Node> toNodeIdentifier(NodeRef ref) {
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey _nodeKey;
        NodeKey invNodeKey = FlowCapableNodeMapping.getNodeKey(ref);
        NodeId _id = invNodeKey.getId();
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId _toplogyNodeId = FlowCapableNodeMapping.toToplogyNodeId(_id);
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey nodeKey = _nodeKey = new org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey(_toplogyNodeId);
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(NetworkTopology.class);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(Topology.class, (Identifier)this.topology);
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _child.child(Node.class, (Identifier)nodeKey);
        return (InstanceIdentifier)_child_1.toInstance();
    }

    public InstanceIdentifier<TerminationPoint> toTerminationPointIdentifier(NodeConnectorRef ref) {
        NodeKey invNodeKey = FlowCapableNodeMapping.getNodeKey(ref);
        NodeConnectorKey invNodeConnectorKey = FlowCapableNodeMapping.getNodeConnectorKey(ref);
        NodeId _id = invNodeKey.getId();
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId _toplogyNodeId = FlowCapableNodeMapping.toToplogyNodeId(_id);
        NodeConnectorId _id_1 = invNodeConnectorKey.getId();
        TpId _terminationPointId = FlowCapableNodeMapping.toTerminationPointId(_id_1);
        return this.tpPath(_toplogyNodeId, _terminationPointId);
    }

    private void removeAffectedLinks(DataModificationTransaction transaction, final org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId id) {
        boolean _tripleEquals;
        InstanceIdentifier.InstanceIdentifierBuilder _builder;
        InstanceIdentifier.InstanceIdentifierBuilder _child;
        InstanceIdentifier topologyPath;
        TypeSafeDataReader reader = TypeSafeDataReader.forReader((DataReader)transaction);
        Topology topologyData = (Topology)reader.readOperationalData(topologyPath = (InstanceIdentifier)(_child = (_builder = InstanceIdentifier.builder(NetworkTopology.class)).child(Topology.class, (Identifier)this.topology)).toInstance());
        boolean bl = _tripleEquals = topologyData == null;
        if (_tripleEquals) {
            return;
        }
        List _link = topologyData.getLink();
        FluentIterable _from = FluentIterable.from((Iterable)_link);
        Predicate<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link> _function = new Predicate<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link>(){

            public boolean apply(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link it) {
                boolean _or = false;
                Source _source = it.getSource();
                org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId _sourceNode = _source.getSourceNode();
                boolean _equals = Objects.equal((Object)_sourceNode, (Object)id);
                if (_equals) {
                    _or = true;
                } else {
                    Destination _destination = it.getDestination();
                    org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId _destNode = _destination.getDestNode();
                    boolean _equals_1 = Objects.equal((Object)_destNode, (Object)id);
                    _or = _equals || _equals_1;
                }
                return _or;
            }
        };
        FluentIterable _filter = _from.filter((Predicate)_function);
        Function<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link, InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link>> _function_1 = new Function<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link, InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link>>(){

            public InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link> apply(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link it) {
                InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(NetworkTopology.class);
                InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(Topology.class, (Identifier)FlowCapableTopologyExporter.this.topology);
                LinkKey _key = it.getKey();
                InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _child.child(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link.class, (Identifier)_key);
                InstanceIdentifier _instance = (InstanceIdentifier)_child_1.toInstance();
                return _instance;
            }
        };
        FluentIterable affectedLinkInstances = _filter.transform((Function)_function_1);
        for (InstanceIdentifier affectedLink : affectedLinkInstances) {
            transaction.removeOperationalData((Object)affectedLink);
        }
    }

    private void removeAffectedLinks(DataModificationTransaction transaction, final TpId id) {
        boolean _tripleEquals;
        InstanceIdentifier.InstanceIdentifierBuilder _builder;
        InstanceIdentifier.InstanceIdentifierBuilder _child;
        InstanceIdentifier topologyPath;
        TypeSafeDataReader reader = TypeSafeDataReader.forReader((DataReader)transaction);
        Topology topologyData = (Topology)reader.readOperationalData(topologyPath = (InstanceIdentifier)(_child = (_builder = InstanceIdentifier.builder(NetworkTopology.class)).child(Topology.class, (Identifier)this.topology)).toInstance());
        boolean bl = _tripleEquals = topologyData == null;
        if (_tripleEquals) {
            return;
        }
        List _link = topologyData.getLink();
        FluentIterable _from = FluentIterable.from((Iterable)_link);
        Predicate<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link> _function = new Predicate<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link>(){

            public boolean apply(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link it) {
                boolean _or = false;
                Source _source = it.getSource();
                TpId _sourceTp = _source.getSourceTp();
                boolean _equals = Objects.equal((Object)_sourceTp, (Object)id);
                if (_equals) {
                    _or = true;
                } else {
                    Destination _destination = it.getDestination();
                    TpId _destTp = _destination.getDestTp();
                    boolean _equals_1 = Objects.equal((Object)_destTp, (Object)id);
                    _or = _equals || _equals_1;
                }
                return _or;
            }
        };
        FluentIterable _filter = _from.filter((Predicate)_function);
        Function<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link, InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link>> _function_1 = new Function<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link, InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link>>(){

            public InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link> apply(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link it) {
                InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(NetworkTopology.class);
                InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(Topology.class, (Identifier)FlowCapableTopologyExporter.this.topology);
                LinkKey _key = it.getKey();
                InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _child.child(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link.class, (Identifier)_key);
                InstanceIdentifier _instance = (InstanceIdentifier)_child_1.toInstance();
                return _instance;
            }
        };
        FluentIterable affectedLinkInstances = _filter.transform((Function)_function_1);
        for (InstanceIdentifier affectedLink : affectedLinkInstances) {
            transaction.removeOperationalData((Object)affectedLink);
        }
    }

    private InstanceIdentifier<Node> nodePath(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId nodeId) {
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey _nodeKey;
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey nodeKey = _nodeKey = new org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey(nodeId);
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(NetworkTopology.class);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(Topology.class, (Identifier)this.topology);
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _child.child(Node.class, (Identifier)nodeKey);
        return (InstanceIdentifier)_child_1.toInstance();
    }

    private InstanceIdentifier<TerminationPoint> tpPath(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId nodeId, TpId tpId) {
        TerminationPointKey _terminationPointKey;
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey _nodeKey;
        org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey nodeKey = _nodeKey = new org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey(nodeId);
        TerminationPointKey tpKey = _terminationPointKey = new TerminationPointKey(tpId);
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(NetworkTopology.class);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(Topology.class, (Identifier)this.topology);
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _child.child(Node.class, (Identifier)nodeKey);
        InstanceIdentifier.InstanceIdentifierBuilder _child_2 = _child_1.child(TerminationPoint.class, (Identifier)tpKey);
        return (InstanceIdentifier)_child_2.toInstance();
    }

    private InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link> linkPath(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link link) {
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder(NetworkTopology.class);
        InstanceIdentifier.InstanceIdentifierBuilder _child = _builder.child(Topology.class, (Identifier)this.topology);
        LinkKey _key = link.getKey();
        InstanceIdentifier.InstanceIdentifierBuilder _child_1 = _child.child(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link.class, (Identifier)_key);
        InstanceIdentifier linkInstanceId = (InstanceIdentifier)_child_1.toInstance();
        return linkInstanceId;
    }
}

