/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.YangNode;

public class YangSchemaUtils {
    private static final Function<InstanceIdentifier.PathArgument, QName> QNAME_FROM_PATH_ARGUMENT = new Function<InstanceIdentifier.PathArgument, QName>(){

        public QName apply(InstanceIdentifier.PathArgument input) {
            if (input == null) {
                return null;
            }
            return input.getNodeType();
        }
    };

    private YangSchemaUtils() {
        throw new UnsupportedOperationException("Utility class.");
    }

    public static DataSchemaNode getSchemaNode(SchemaContext schema, InstanceIdentifier path) {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"YANG Schema must not be null.");
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Path must not be null.");
        return YangSchemaUtils.getSchemaNode(schema, (Iterable<QName>)FluentIterable.from((Iterable)path.getPath()).transform(QNAME_FROM_PATH_ARGUMENT));
    }

    public static DataSchemaNode getSchemaNode(SchemaContext schema, Iterable<QName> path) {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"YANG Schema must not be null.");
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Path must not be null.");
        if (!path.iterator().hasNext()) {
            return YangSchemaUtils.toRootDataNode(schema);
        }
        QName firstNode = path.iterator().next();
        Module previous = schema.findModuleByNamespaceAndRevision(firstNode.getNamespace(), firstNode.getRevision());
        Iterator<QName> iterator = path.iterator();
        while (iterator.hasNext()) {
            Preconditions.checkArgument((previous != null ? 1 : 0) != 0, (Object)"Supplied path does not resolve into valid schema node.");
            QName arg = iterator.next();
            DataSchemaNode currentNode = previous.getDataChildByName(arg);
            if (currentNode == null && previous instanceof DataNodeContainer) {
                currentNode = YangSchemaUtils.searchInChoices((DataNodeContainer)previous, arg);
            }
            if (currentNode instanceof DataNodeContainer) {
                previous = (DataNodeContainer)currentNode;
            } else if (currentNode instanceof LeafSchemaNode || currentNode instanceof LeafListSchemaNode) {
                Preconditions.checkArgument((!iterator.hasNext() ? 1 : 0) != 0, (Object)"Path nests inside leaf node, which is not allowed.");
                return currentNode;
            }
            Preconditions.checkState((currentNode != null ? 1 : 0) != 0, (String)"Current node should not be null for %s", (Object[])new Object[]{path});
        }
        Preconditions.checkState((boolean)(previous instanceof DataSchemaNode), (String)"Schema node for %s should be instance of DataSchemaNode. Found %s", (Object[])new Object[]{path, previous});
        return (DataSchemaNode)previous;
    }

    private static DataSchemaNode searchInChoices(DataNodeContainer node, QName arg) {
        Set children = node.getChildNodes();
        for (DataSchemaNode child : children) {
            ChoiceNode choiceNode;
            DataSchemaNode potential;
            if (!(child instanceof ChoiceNode) || (potential = YangSchemaUtils.searchInCases(choiceNode = (ChoiceNode)child, arg)) == null) continue;
            return potential;
        }
        return null;
    }

    private static DataSchemaNode searchInCases(ChoiceNode choiceNode, QName arg) {
        Set cases = choiceNode.getCases();
        for (ChoiceCaseNode caseNode : cases) {
            DataSchemaNode node = caseNode.getDataChildByName(arg);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private static ContainerSchemaNode toRootDataNode(SchemaContext schema) {
        return new NetconfDataRootNode(schema);
    }

    private static final class NetconfDataRootNode
    implements ContainerSchemaNode {
        public NetconfDataRootNode(SchemaContext schema) {
        }

        public YangNode getParent() {
            return null;
        }

        public Set<TypeDefinition<?>> getTypeDefinitions() {
            return null;
        }

        public Set<DataSchemaNode> getChildNodes() {
            return null;
        }

        public Set<GroupingDefinition> getGroupings() {
            return null;
        }

        public DataSchemaNode getDataChildByName(QName name) {
            return null;
        }

        public DataSchemaNode getDataChildByName(String name) {
            return null;
        }

        public Set<UsesNode> getUses() {
            return null;
        }

        public Set<AugmentationSchema> getAvailableAugmentations() {
            return null;
        }

        public boolean isAugmenting() {
            return false;
        }

        public boolean isAddedByUses() {
            return false;
        }

        public boolean isConfiguration() {
            return false;
        }

        public ConstraintDefinition getConstraints() {
            return null;
        }

        public QName getQName() {
            return null;
        }

        public SchemaPath getPath() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getReference() {
            return null;
        }

        public Status getStatus() {
            return null;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return null;
        }

        public boolean isPresenceContainer() {
            return false;
        }
    }
}

