/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.util;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;

public class YangDataUtils {
    public static Map<Map<QName, Object>, CompositeNode> toIndexMap(List<CompositeNode> nodes, List<QName> keys) {
        ConcurrentHashMap<Map<QName, Object>, CompositeNode> ret = new ConcurrentHashMap<Map<QName, Object>, CompositeNode>();
        for (CompositeNode node : nodes) {
            Map<QName, Object> key = YangDataUtils.getKeyMap(node, keys);
            ret.put(key, node);
        }
        return ret;
    }

    public static Map<QName, Object> getKeyMap(CompositeNode node, List<QName> keys) {
        HashMap<QName, Object> map = new HashMap<QName, Object>();
        for (QName key : keys) {
            SimpleNode keyNode = node.getFirstSimpleByName(QName.create((QName)node.getNodeType(), (String)key.getLocalName()));
            Preconditions.checkArgument((keyNode != null ? 1 : 0) != 0, (Object)"Node must contains all keys.");
            Object value = keyNode.getValue();
            map.put(key, value);
        }
        return map;
    }
}

