/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.sal.dom.broker.util.YangDataUtils;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.impl.CompositeNodeTOImpl;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class YangDataOperations {
    public static CompositeNode merge(DataSchemaNode schema, CompositeNode stored, CompositeNode modified, boolean config) {
        boolean _tripleEquals;
        boolean bl = _tripleEquals = stored == null;
        if (_tripleEquals) {
            return modified;
        }
        boolean _or = false;
        if (schema instanceof ListSchemaNode) {
            _or = true;
        } else {
            boolean bl2 = _or = schema instanceof ListSchemaNode || schema instanceof ContainerSchemaNode;
        }
        if (_or) {
            return YangDataOperations.mergeContainer((DataNodeContainer)schema, stored, modified, config);
        }
        IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Supplied node is not data node container.");
        throw _illegalArgumentException;
    }

    private static void checkConfigurational(DataSchemaNode node, boolean config) {
        if (config) {
            boolean _isConfiguration = node.isConfiguration();
            Preconditions.checkArgument((boolean)_isConfiguration, (Object)"Supplied composite node is not configurational.");
        }
    }

    private static Iterable<? extends Node<? extends Object>> _mergeMultiple(LeafSchemaNode node, List<Node<? extends Object>> original, List<Node<? extends Object>> modified, boolean configurational) {
        int _size = original.size();
        boolean _tripleEquals = _size == 1;
        Preconditions.checkArgument((boolean)_tripleEquals);
        int _size_1 = modified.size();
        boolean _tripleEquals_1 = _size_1 == 1;
        Preconditions.checkArgument((boolean)_tripleEquals_1);
        return modified;
    }

    private static Iterable<? extends Node<? extends Object>> _mergeMultiple(LeafListSchemaNode node, List<Node<? extends Object>> original, List<Node<? extends Object>> modified, boolean configurational) {
        return modified;
    }

    private static Iterable<? extends Node<? extends Object>> _mergeMultiple(ContainerSchemaNode node, List<Node<? extends Object>> original, List<Node<? extends Object>> modified, boolean configurational) {
        int _size = original.size();
        boolean _tripleEquals = _size == 1;
        Preconditions.checkArgument((boolean)_tripleEquals);
        int _size_1 = modified.size();
        boolean _tripleEquals_1 = _size_1 == 1;
        Preconditions.checkArgument((boolean)_tripleEquals_1);
        Node<? extends Object> _get = original.get(0);
        Node<? extends Object> _get_1 = modified.get(0);
        CompositeNode _merge = YangDataOperations.merge((DataSchemaNode)node, (CompositeNode)_get, (CompositeNode)_get_1, configurational);
        return Collections.singletonList(_merge);
    }

    private static Iterable<? extends Node<? extends Object>> _mergeMultiple(ListSchemaNode node, List<Node<? extends Object>> original, List<Node<? extends Object>> modified, boolean configurational) {
        ArrayList<CompositeNode> _arrayList;
        boolean _tripleEquals;
        boolean _or = false;
        List _keyDefinition = node.getKeyDefinition();
        boolean bl = _tripleEquals = _keyDefinition == null;
        if (_tripleEquals) {
            _or = true;
        } else {
            List _keyDefinition_1 = node.getKeyDefinition();
            boolean _isEmpty = _keyDefinition_1.isEmpty();
            boolean bl2 = _or = _tripleEquals || _isEmpty;
        }
        if (_or) {
            return modified;
        }
        List _keyDefinition_2 = node.getKeyDefinition();
        Map<Map<QName, Object>, CompositeNode> originalMap = YangDataUtils.toIndexMap(original, _keyDefinition_2);
        List _keyDefinition_3 = node.getKeyDefinition();
        Map<Map<QName, Object>, CompositeNode> modifiedMap = YangDataUtils.toIndexMap(modified, _keyDefinition_3);
        int _size = original.size();
        int _size_1 = modified.size();
        int _plus = _size + _size_1;
        ArrayList<CompositeNode> mergedNodes = _arrayList = new ArrayList<CompositeNode>(_plus);
        Set<Map.Entry<Map<QName, Object>, CompositeNode>> _entrySet = modifiedMap.entrySet();
        for (Map.Entry<Map<QName, Object>, CompositeNode> entry : _entrySet) {
            Map<QName, Object> _key = entry.getKey();
            CompositeNode originalEntry = originalMap.get(_key);
            boolean _notEquals = !Objects.equal((Object)originalEntry, null);
            if (!_notEquals) continue;
            Map<QName, Object> _key_1 = entry.getKey();
            originalMap.remove(_key_1);
            CompositeNode _value = entry.getValue();
            CompositeNode _merge = YangDataOperations.merge((DataSchemaNode)node, originalEntry, _value, configurational);
            mergedNodes.add(_merge);
        }
        Collection<CompositeNode> _values = originalMap.values();
        mergedNodes.addAll(_values);
        return mergedNodes;
    }

    private static CompositeNode mergeContainer(DataNodeContainer schema, CompositeNode stored, CompositeNode modified, boolean config) {
        HashSet _hashSet;
        ArrayList _arrayList;
        boolean _equals = Objects.equal((Object)stored, null);
        if (_equals) {
            return modified;
        }
        Preconditions.checkNotNull((Object)stored);
        Preconditions.checkNotNull((Object)modified);
        QName _nodeType = stored.getNodeType();
        QName _nodeType_1 = modified.getNodeType();
        boolean _equals_1 = Objects.equal((Object)_nodeType, (Object)_nodeType_1);
        Preconditions.checkArgument((boolean)_equals_1);
        List _children = stored.getChildren();
        int _size = _children.size();
        List _children_1 = modified.getChildren();
        int _size_1 = _children_1.size();
        int _plus = _size + _size_1;
        ArrayList mergedChildNodes = _arrayList = new ArrayList(_plus);
        Set _keySet = stored.keySet();
        HashSet toProcess = _hashSet = new HashSet(_keySet);
        Set _keySet_1 = modified.keySet();
        toProcess.addAll(_keySet_1);
        for (QName qname : toProcess) {
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            DataSchemaNode schemaChild = schema.getDataChildByName(qname);
            List storedChildren = (List)stored.get((Object)qname);
            List modifiedChildren = (List)modified.get((Object)qname);
            boolean _and = false;
            boolean bl = _tripleNotEquals = modifiedChildren != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _isEmpty = modifiedChildren.isEmpty();
                boolean _not = !_isEmpty;
                boolean bl2 = _and = _tripleNotEquals && _not;
            }
            if (_and) {
                boolean _tripleEquals;
                boolean _or = false;
                boolean _or_1 = false;
                boolean bl3 = _tripleEquals = storedChildren == null;
                if (_tripleEquals) {
                    _or_1 = true;
                } else {
                    boolean _isEmpty_1 = storedChildren.isEmpty();
                    boolean bl4 = _or_1 = _tripleEquals || _isEmpty_1;
                }
                if (_or_1) {
                    _or = true;
                } else {
                    boolean _tripleEquals_1 = schemaChild == null;
                    boolean bl5 = _or = _or_1 || _tripleEquals_1;
                }
                if (_or) {
                    mergedChildNodes.addAll(modifiedChildren);
                    continue;
                }
                Iterable<? extends Node<? extends Object>> _mergeMultiple = YangDataOperations.mergeMultiple(schemaChild, storedChildren, modifiedChildren, config);
                Iterables.addAll(mergedChildNodes, _mergeMultiple);
                continue;
            }
            boolean _and_1 = false;
            boolean bl6 = _tripleNotEquals_1 = storedChildren != null;
            if (!_tripleNotEquals_1) {
                _and_1 = false;
            } else {
                boolean _isEmpty_2 = storedChildren.isEmpty();
                boolean _not_1 = !_isEmpty_2;
                boolean bl7 = _and_1 = _tripleNotEquals_1 && _not_1;
            }
            if (!_and_1) continue;
            mergedChildNodes.addAll(storedChildren);
        }
        QName _nodeType_2 = stored.getNodeType();
        CompositeNodeTOImpl _compositeNodeTOImpl = new CompositeNodeTOImpl(_nodeType_2, null, mergedChildNodes);
        return _compositeNodeTOImpl;
    }

    private static Iterable<? extends Node<? extends Object>> mergeMultiple(DataSchemaNode node, List<Node<? extends Object>> original, List<Node<? extends Object>> modified, boolean configurational) {
        if (node instanceof ContainerSchemaNode) {
            return YangDataOperations._mergeMultiple((ContainerSchemaNode)node, original, modified, configurational);
        }
        if (node instanceof LeafListSchemaNode) {
            return YangDataOperations._mergeMultiple((LeafListSchemaNode)node, original, modified, configurational);
        }
        if (node instanceof LeafSchemaNode) {
            return YangDataOperations._mergeMultiple((LeafSchemaNode)node, original, modified, configurational);
        }
        if (node instanceof ListSchemaNode) {
            return YangDataOperations._mergeMultiple((ListSchemaNode)node, original, modified, configurational);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, original, modified, configurational).toString());
    }
}

