/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChange;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangeListener;
import org.opendaylight.controller.md.sal.common.impl.routing.RoutingUtils;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.RpcImplementation;
import org.opendaylight.controller.sal.core.api.RpcRegistrationListener;
import org.opendaylight.controller.sal.core.api.RpcRoutingContext;
import org.opendaylight.controller.sal.dom.broker.impl.SchemaContextProvider;
import org.opendaylight.controller.sal.dom.broker.spi.RpcRouter;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaAwareRpcBroker
implements RpcRouter,
Identifiable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAwareRpcBroker.class);
    private static final QName CONTEXT_REFERENCE = QName.create((String)"urn:opendaylight:yang:extension:yang-ext", (String)"2013-07-09", (String)"context-reference");
    private final ListenerRegistry<RpcRegistrationListener> rpcRegistrationListeners = new ListenerRegistry();
    private final ListenerRegistry<RouteChangeListener<RpcRoutingContext, InstanceIdentifier>> routeChangeListeners = new ListenerRegistry();
    private final String identifier;
    private final ConcurrentMap<QName, RpcImplementation> implementations = new ConcurrentHashMap<QName, RpcImplementation>();
    private RpcImplementation defaultImplementation;
    private SchemaContextProvider schemaProvider;

    public SchemaAwareRpcBroker(String identifier, SchemaContextProvider schemaProvider) {
        this.identifier = identifier;
        this.schemaProvider = schemaProvider;
    }

    public RpcImplementation getDefaultImplementation() {
        return this.defaultImplementation;
    }

    public void setDefaultImplementation(RpcImplementation defaultImplementation) {
        this.defaultImplementation = defaultImplementation;
    }

    public SchemaContextProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    public void setSchemaProvider(SchemaContextProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    @Override
    public Broker.RoutedRpcRegistration addRoutedRpcImplementation(QName rpcType, RpcImplementation implementation) {
        Preconditions.checkArgument((rpcType != null ? 1 : 0) != 0, (Object)"RPC Type should not be null");
        Preconditions.checkArgument((implementation != null ? 1 : 0) != 0, (Object)"RPC Implementatoin should not be null");
        return this.getOrCreateRoutedRpcRouter(rpcType).addRoutedRpcImplementation(rpcType, implementation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoutedRpcSelector getOrCreateRoutedRpcRouter(QName rpcType) {
        RoutedRpcSelector potential = this.getRoutedRpcRouter(rpcType);
        if (potential != null) {
            return potential;
        }
        ConcurrentMap<QName, RpcImplementation> concurrentMap = this.implementations;
        synchronized (concurrentMap) {
            potential = this.getRoutedRpcRouter(rpcType);
            if (potential != null) {
                return potential;
            }
            RpcDefinition definition = this.findRpcDefinition(rpcType);
            RoutingStrategy strategy = this.getRoutingStrategy(definition);
            Preconditions.checkState((boolean)(strategy instanceof RoutedRpcStrategy), (String)"Rpc %s is not routed.", (Object[])new Object[]{rpcType});
            potential = new RoutedRpcSelector((RoutedRpcStrategy)strategy, this);
            this.implementations.put(rpcType, potential);
            return potential;
        }
    }

    private RoutedRpcSelector getRoutedRpcRouter(QName rpcType) {
        RpcImplementation potential = (RpcImplementation)this.implementations.get(rpcType);
        if (potential != null) {
            Preconditions.checkState((boolean)(potential instanceof RoutedRpcSelector), (String)"Rpc %s is not routed.", (Object[])new Object[]{rpcType});
            return (RoutedRpcSelector)potential;
        }
        return null;
    }

    @Override
    public Broker.RpcRegistration addRpcImplementation(QName rpcType, RpcImplementation implementation) throws IllegalArgumentException {
        Preconditions.checkArgument((rpcType != null ? 1 : 0) != 0, (Object)"RPC Type should not be null");
        Preconditions.checkArgument((implementation != null ? 1 : 0) != 0, (Object)"RPC Implementatoin should not be null");
        Preconditions.checkState((!this.hasRpcImplementation(rpcType) ? 1 : 0) != 0, (Object)"Implementation already registered");
        RpcDefinition definition = this.findRpcDefinition(rpcType);
        Preconditions.checkArgument((!this.isRoutedRpc(definition) ? 1 : 0) != 0, (Object)"RPC Type must not be routed.");
        GlobalRpcRegistration reg = new GlobalRpcRegistration(rpcType, implementation, this);
        this.implementations.putIfAbsent(rpcType, implementation);
        return reg;
    }

    private boolean isRoutedRpc(RpcDefinition definition) {
        return this.getRoutingStrategy(definition) instanceof RoutedRpcStrategy;
    }

    public ListenerRegistration<RpcRegistrationListener> addRpcRegistrationListener(RpcRegistrationListener listener) {
        return this.rpcRegistrationListeners.register((EventListener)listener);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Set<QName> getSupportedRpcs() {
        return ImmutableSet.copyOf(this.implementations.keySet());
    }

    @Override
    public RpcResult<CompositeNode> invokeRpc(QName rpc, CompositeNode input) {
        return this.findRpcImplemention(rpc).invokeRpc(rpc, input);
    }

    private RpcImplementation findRpcImplemention(QName rpc) {
        Preconditions.checkArgument((rpc != null ? 1 : 0) != 0, (Object)"Rpc name should not be null");
        RpcImplementation potentialImpl = (RpcImplementation)this.implementations.get(rpc);
        if (potentialImpl != null) {
            return potentialImpl;
        }
        potentialImpl = this.defaultImplementation;
        Preconditions.checkState((potentialImpl != null ? 1 : 0) != 0, (Object)"Implementation is not available.");
        return potentialImpl;
    }

    private boolean hasRpcImplementation(QName rpc) {
        return this.implementations.containsKey(rpc);
    }

    private RpcDefinition findRpcDefinition(QName rpcType) {
        Preconditions.checkArgument((rpcType != null ? 1 : 0) != 0, (Object)"Rpc name must be supplied.");
        Preconditions.checkState((this.schemaProvider != null ? 1 : 0) != 0, (Object)"Schema Provider is not available.");
        SchemaContext ctx = this.schemaProvider.getSchemaContext();
        Preconditions.checkState((ctx != null ? 1 : 0) != 0, (Object)"YANG Schema Context is not available.");
        Module module = ctx.findModuleByNamespaceAndRevision(rpcType.getNamespace(), rpcType.getRevision());
        Preconditions.checkState((module != null ? 1 : 0) != 0, (Object)"YANG Module is not available.");
        return SchemaAwareRpcBroker.findRpcDefinition(rpcType, module.getRpcs());
    }

    private static RpcDefinition findRpcDefinition(QName rpcType, Set<RpcDefinition> rpcs) {
        Preconditions.checkState((rpcs != null ? 1 : 0) != 0, (Object)"Rpc schema is not available.");
        for (RpcDefinition rpc : rpcs) {
            if (!rpcType.equals((Object)rpc.getQName())) continue;
            return rpc;
        }
        throw new IllegalArgumentException("Supplied Rpc Type is not defined.");
    }

    private RoutingStrategy getRoutingStrategy(RpcDefinition rpc) {
        ContainerSchemaNode input = rpc.getInput();
        if (input != null) {
            for (DataSchemaNode schemaNode : input.getChildNodes()) {
                Optional<QName> context = this.getRoutingContext(schemaNode);
                if (!context.isPresent()) continue;
                return SchemaAwareRpcBroker.createRoutedStrategy(rpc, (QName)context.get(), schemaNode.getQName());
            }
        }
        return SchemaAwareRpcBroker.createGlobalStrategy(rpc);
    }

    private static RoutingStrategy createRoutedStrategy(RpcDefinition rpc, QName context, QName leafNode) {
        return new RoutedRpcStrategy(rpc.getQName(), context, leafNode);
    }

    private Optional<QName> getRoutingContext(DataSchemaNode schemaNode) {
        for (UnknownSchemaNode extension : schemaNode.getUnknownSchemaNodes()) {
            if (!CONTEXT_REFERENCE.equals((Object)extension.getNodeType())) continue;
            return Optional.fromNullable((Object)extension.getQName());
        }
        return Optional.absent();
    }

    private static RoutingStrategy createGlobalStrategy(RpcDefinition rpc) {
        GlobalRpcStrategy ret = new GlobalRpcStrategy(rpc.getQName());
        return ret;
    }

    private void remove(GlobalRpcRegistration registration) {
        this.implementations.remove(registration.getType(), (Object)registration);
    }

    private void notifyPathAnnouncement(QName context, QName identifier, InstanceIdentifier path) {
        RpcRoutingContext contextWrapped = RpcRoutingContext.create((QName)context, (QName)identifier);
        RouteChange change = RoutingUtils.announcementChange((Object)contextWrapped, (Object)path);
        for (ListenerRegistration routeListener : this.routeChangeListeners) {
            try {
                ((RouteChangeListener)routeListener.getInstance()).onRouteChange(change);
            }
            catch (Exception e) {
                LOG.error("Unhandled exception during invoking onRouteChange for {}", routeListener.getInstance(), (Object)e);
            }
        }
    }

    private void notifyPathWithdrawal(QName context, QName identifier, InstanceIdentifier path) {
        RpcRoutingContext contextWrapped = RpcRoutingContext.create((QName)context, (QName)identifier);
        RouteChange change = RoutingUtils.removalChange((Object)contextWrapped, (Object)path);
        for (ListenerRegistration routeListener : this.routeChangeListeners) {
            try {
                ((RouteChangeListener)routeListener.getInstance()).onRouteChange(change);
            }
            catch (Exception e) {
                LOG.error("Unhandled exception during invoking onRouteChange for {}", routeListener.getInstance(), (Object)e);
            }
        }
    }

    public <L extends RouteChangeListener<RpcRoutingContext, InstanceIdentifier>> ListenerRegistration<L> registerRouteChangeListener(L listener) {
        return this.routeChangeListeners.registerWithType(listener);
    }

    private static class RoutedRpcRegImpl
    extends AbstractObjectRegistration<RpcImplementation>
    implements Broker.RoutedRpcRegistration {
        private final QName type;
        private RoutedRpcSelector router;

        public RoutedRpcRegImpl(QName rpcType, RpcImplementation implementation, RoutedRpcSelector routedRpcSelector) {
            super((Object)implementation);
            this.type = rpcType;
            this.router = routedRpcSelector;
        }

        public void registerPath(QName context, InstanceIdentifier path) {
            this.router.addPath(context, path, this);
        }

        public void unregisterPath(QName context, InstanceIdentifier path) {
            this.router.removePath(context, path, this);
        }

        protected void removeRegistration() {
        }

        public QName getType() {
            return this.type;
        }
    }

    private static class GlobalRpcRegistration
    extends AbstractObjectRegistration<RpcImplementation>
    implements Broker.RpcRegistration {
        private final QName type;
        private SchemaAwareRpcBroker router;

        public GlobalRpcRegistration(QName type, RpcImplementation instance, SchemaAwareRpcBroker router) {
            super((Object)instance);
            this.type = type;
            this.router = router;
        }

        public QName getType() {
            return this.type;
        }

        protected void removeRegistration() {
            if (this.router != null) {
                this.router.remove(this);
                this.router = null;
            }
        }
    }

    private static class RoutedRpcSelector
    implements RpcImplementation,
    AutoCloseable,
    Identifiable<QName> {
        private final RoutedRpcStrategy strategy;
        private final Set<QName> supportedRpcs;
        private RpcImplementation defaultDelegate;
        private final ConcurrentMap<InstanceIdentifier, RoutedRpcRegImpl> implementations = new ConcurrentHashMap<InstanceIdentifier, RoutedRpcRegImpl>();
        private SchemaAwareRpcBroker router;

        public RoutedRpcSelector(RoutedRpcStrategy strategy, SchemaAwareRpcBroker router) {
            this.strategy = strategy;
            this.supportedRpcs = ImmutableSet.of((Object)strategy.getIdentifier());
            this.router = router;
        }

        public QName getIdentifier() {
            return this.strategy.getIdentifier();
        }

        @Override
        public void close() throws Exception {
        }

        public Set<QName> getSupportedRpcs() {
            return this.supportedRpcs;
        }

        public Broker.RoutedRpcRegistration addRoutedRpcImplementation(QName rpcType, RpcImplementation implementation) {
            return new RoutedRpcRegImpl(rpcType, implementation, this);
        }

        public RpcResult<CompositeNode> invokeRpc(QName rpc, CompositeNode input) {
            RoutedRpcRegImpl potentialReg;
            CompositeNode inputContainer = input.getFirstCompositeByName(QName.create((QName)rpc, (String)"input"));
            Preconditions.checkArgument((inputContainer != null ? 1 : 0) != 0, (Object)"Rpc payload must contain input element");
            SimpleNode routeContainer = inputContainer.getFirstSimpleByName(this.strategy.getLeaf());
            Preconditions.checkArgument((routeContainer != null ? 1 : 0) != 0, (String)"Leaf %s must be set with value", (Object[])new Object[]{this.strategy.getLeaf()});
            Object route = routeContainer.getValue();
            RpcImplementation potential = null;
            if (route != null && (potentialReg = (RoutedRpcRegImpl)((Object)this.implementations.get(route))) != null) {
                potential = (RpcImplementation)potentialReg.getInstance();
            }
            if (potential == null) {
                potential = this.defaultDelegate;
            }
            Preconditions.checkState((potential != null ? 1 : 0) != 0, (String)"No implementation is available for rpc:%s path:%s", (Object[])new Object[]{rpc, route});
            return potential.invokeRpc(rpc, input);
        }

        public void addPath(QName context, InstanceIdentifier path, RoutedRpcRegImpl routedRpcRegImpl) {
            RoutedRpcRegImpl previous = this.implementations.put(path, routedRpcRegImpl);
            if (previous == null) {
                this.router.notifyPathAnnouncement(context, this.strategy.getIdentifier(), path);
            }
        }

        public void removePath(QName context, InstanceIdentifier path, RoutedRpcRegImpl routedRpcRegImpl) {
            boolean removed = this.implementations.remove(path, (Object)routedRpcRegImpl);
            if (removed) {
                this.router.notifyPathWithdrawal(context, this.strategy.getIdentifier(), path);
            }
        }
    }

    private static class RoutedRpcStrategy
    extends RoutingStrategy {
        private final QName context;
        private final QName leaf;

        public RoutedRpcStrategy(QName identifier, QName ctx, QName leaf) {
            super(identifier);
            this.context = ctx;
            this.leaf = leaf;
        }

        public QName getContext() {
            return this.context;
        }

        public QName getLeaf() {
            return this.leaf;
        }
    }

    private static class GlobalRpcStrategy
    extends RoutingStrategy {
        public GlobalRpcStrategy(QName identifier) {
            super(identifier);
        }
    }

    private static abstract class RoutingStrategy
    implements Identifiable<QName> {
        private final QName identifier;

        public RoutingStrategy(QName identifier) {
            this.identifier = identifier;
        }

        public QName getIdentifier() {
            return this.identifier;
        }
    }
}

