/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.md.sal.common.impl.AbstractDataModification;
import org.opendaylight.controller.md.sal.common.impl.util.AbstractLockableDelegator;
import org.opendaylight.controller.sal.core.api.data.DataStore;
import org.opendaylight.controller.sal.dom.broker.util.YangDataOperations;
import org.opendaylight.controller.sal.dom.broker.util.YangSchemaUtils;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.CompositeNodeTOImpl;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaAwareDataStoreAdapter
extends AbstractLockableDelegator<DataStore>
implements DataStore,
SchemaServiceListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAwareDataStoreAdapter.class);
    private SchemaContext schema = null;
    private boolean validationEnabled = false;
    private DataReader<InstanceIdentifier, CompositeNode> reader = new MergeFirstLevelReader();
    private final Comparator<Map.Entry<InstanceIdentifier, CompositeNode>> preparationComparator = new Comparator<Map.Entry<InstanceIdentifier, CompositeNode>>(){

        @Override
        public int compare(Map.Entry<InstanceIdentifier, CompositeNode> o1, Map.Entry<InstanceIdentifier, CompositeNode> o2) {
            InstanceIdentifier o1Key = o1.getKey();
            InstanceIdentifier o2Key = o2.getKey();
            return Integer.compare(o1Key.getPath().size(), o2Key.getPath().size());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsConfigurationPath(InstanceIdentifier path) {
        try {
            this.getDelegateReadLock().lock();
            boolean bl = ((DataStore)this.getDelegate()).containsConfigurationPath(path);
            return bl;
        }
        finally {
            this.getDelegateReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsOperationalPath(InstanceIdentifier path) {
        try {
            this.getDelegateReadLock().lock();
            boolean bl = ((DataStore)this.getDelegate()).containsOperationalPath(path);
            return bl;
        }
        finally {
            this.getDelegateReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<InstanceIdentifier> getStoredConfigurationPaths() {
        try {
            this.getDelegateReadLock().lock();
            Iterable iterable = ((DataStore)this.getDelegate()).getStoredConfigurationPaths();
            return iterable;
        }
        finally {
            this.getDelegateReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<InstanceIdentifier> getStoredOperationalPaths() {
        try {
            this.getDelegateReadLock().lock();
            Iterable iterable = ((DataStore)this.getDelegate()).getStoredOperationalPaths();
            return iterable;
        }
        finally {
            this.getDelegateReadLock().unlock();
        }
    }

    public CompositeNode readConfigurationData(InstanceIdentifier path) {
        return (CompositeNode)this.reader.readConfigurationData((Object)path);
    }

    public CompositeNode readOperationalData(InstanceIdentifier path) {
        return (CompositeNode)this.reader.readOperationalData((Object)path);
    }

    public DataCommitHandler.DataCommitTransaction<InstanceIdentifier, CompositeNode> requestCommit(DataModification<InstanceIdentifier, CompositeNode> modification) {
        this.validateAgainstSchema(modification);
        NormalizedDataModification cleanedUp = this.prepareMergedTransaction(modification);
        cleanedUp.status = TransactionStatus.SUBMITED;
        return ((DataStore)this.retrieveDelegate()).requestCommit((DataModification)cleanedUp);
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    private void validateAgainstSchema(DataModification<InstanceIdentifier, CompositeNode> modification) {
        if (!this.validationEnabled) {
            return;
        }
        if (this.schema == null) {
            LOG.warn("Validation not performed for {}. Reason: YANG Schema not present.", modification.getIdentifier());
            return;
        }
    }

    protected void onDelegateChanged(DataStore oldDelegate, DataStore newDelegate) {
    }

    public void onGlobalContextUpdated(SchemaContext context) {
        this.schema = context;
    }

    @Override
    public void close() throws Exception {
        this.schema = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompositeNode mergeData(InstanceIdentifier path, CompositeNode stored, CompositeNode modified, boolean config) {
        long startTime = System.nanoTime();
        DataSchemaNode node = this.schemaNodeFor(path);
        CompositeNode compositeNode = YangDataOperations.merge(node, stored, modified, config);
        return compositeNode;
    }

    private DataSchemaNode schemaNodeFor(InstanceIdentifier path) {
        Preconditions.checkState((this.schema != null ? 1 : 0) != 0, (Object)"YANG Schema is not available");
        return YangSchemaUtils.getSchemaNode(this.schema, path);
    }

    private NormalizedDataModification prepareMergedTransaction(DataModification<InstanceIdentifier, CompositeNode> original) {
        NormalizedDataModification normalized = new NormalizedDataModification(original);
        for (Map.Entry entry : original.getUpdatedConfigurationData().entrySet()) {
            normalized.putConfigurationData((Path)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : original.getUpdatedOperationalData().entrySet()) {
            normalized.putOperationalData((Path)entry.getKey(), entry.getValue());
        }
        for (InstanceIdentifier instanceIdentifier : original.getRemovedConfigurationData()) {
            normalized.removeConfigurationData((Path)instanceIdentifier);
        }
        for (InstanceIdentifier instanceIdentifier : original.getRemovedOperationalData()) {
            normalized.removeOperationalData((Path)instanceIdentifier);
        }
        return normalized;
    }

    private class NormalizedDataModification
    extends AbstractDataModification<InstanceIdentifier, CompositeNode> {
        private Object identifier;
        private TransactionStatus status;

        public NormalizedDataModification(DataModification<InstanceIdentifier, CompositeNode> original) {
            super((DataReader)SchemaAwareDataStoreAdapter.this.getDelegate());
            this.identifier = original;
            this.status = TransactionStatus.NEW;
        }

        public Object getIdentifier() {
            return this.identifier;
        }

        public TransactionStatus getStatus() {
            return this.status;
        }

        public Future<RpcResult<TransactionStatus>> commit() {
            throw new UnsupportedOperationException("Commit should not be invoked on this");
        }

        protected CompositeNode mergeConfigurationData(InstanceIdentifier path, CompositeNode stored, CompositeNode modified) {
            return SchemaAwareDataStoreAdapter.this.mergeData(path, stored, modified, true);
        }

        protected CompositeNode mergeOperationalData(InstanceIdentifier path, CompositeNode stored, CompositeNode modified) {
            return SchemaAwareDataStoreAdapter.this.mergeData(path, stored, modified, false);
        }
    }

    private class MergeFirstLevelReader
    implements DataReader<InstanceIdentifier, CompositeNode> {
        private MergeFirstLevelReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompositeNode readConfigurationData(final InstanceIdentifier path) {
            SchemaAwareDataStoreAdapter.this.getDelegateReadLock().lock();
            try {
                CompositeNodeTOImpl compositeNodeTOImpl;
                if (path.getPath().isEmpty()) {
                    CompositeNode compositeNode = null;
                    return compositeNode;
                }
                QName qname = null;
                CompositeNode original = (CompositeNode)((DataStore)SchemaAwareDataStoreAdapter.this.getDelegate()).readConfigurationData((Object)path);
                ArrayList<Object> childNodes = new ArrayList<Object>();
                if (original != null) {
                    childNodes.addAll(original.getChildren());
                    qname = original.getNodeType();
                } else {
                    qname = ((InstanceIdentifier.PathArgument)path.getPath().get(path.getPath().size() - 1)).getNodeType();
                }
                FluentIterable directChildren = FluentIterable.from(SchemaAwareDataStoreAdapter.this.getStoredConfigurationPaths()).filter((Predicate)new Predicate<InstanceIdentifier>(){

                    public boolean apply(InstanceIdentifier input) {
                        int nesting;
                        return path.contains(input) && (nesting = input.getPath().size() - path.getPath().size()) == 1;
                    }
                });
                for (InstanceIdentifier instanceIdentifier : directChildren) {
                    childNodes.add(((DataStore)SchemaAwareDataStoreAdapter.this.getDelegate()).readConfigurationData((Object)instanceIdentifier));
                }
                if (original == null && childNodes.isEmpty()) {
                    compositeNodeTOImpl = null;
                    return compositeNodeTOImpl;
                }
                compositeNodeTOImpl = new CompositeNodeTOImpl(qname, null, childNodes);
                return compositeNodeTOImpl;
            }
            finally {
                SchemaAwareDataStoreAdapter.this.getDelegateReadLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompositeNode readOperationalData(final InstanceIdentifier path) {
            SchemaAwareDataStoreAdapter.this.getDelegateReadLock().lock();
            try {
                CompositeNodeTOImpl compositeNodeTOImpl;
                if (path.getPath().isEmpty()) {
                    CompositeNode compositeNode = null;
                    return compositeNode;
                }
                QName qname = null;
                CompositeNode original = (CompositeNode)((DataStore)SchemaAwareDataStoreAdapter.this.getDelegate()).readOperationalData((Object)path);
                ArrayList<Object> childNodes = new ArrayList<Object>();
                if (original != null) {
                    childNodes.addAll(original.getChildren());
                    qname = original.getNodeType();
                } else {
                    qname = ((InstanceIdentifier.PathArgument)path.getPath().get(path.getPath().size() - 1)).getNodeType();
                }
                FluentIterable directChildren = FluentIterable.from(SchemaAwareDataStoreAdapter.this.getStoredOperationalPaths()).filter((Predicate)new Predicate<InstanceIdentifier>(){

                    public boolean apply(InstanceIdentifier input) {
                        int nesting;
                        return path.contains(input) && (nesting = input.getPath().size() - path.getPath().size()) == 1;
                    }
                });
                for (InstanceIdentifier instanceIdentifier : directChildren) {
                    childNodes.add(((DataStore)SchemaAwareDataStoreAdapter.this.getDelegate()).readOperationalData((Object)instanceIdentifier));
                }
                if (original == null && childNodes.isEmpty()) {
                    compositeNodeTOImpl = null;
                    return compositeNodeTOImpl;
                }
                compositeNodeTOImpl = new CompositeNodeTOImpl(qname, null, childNodes);
                return compositeNodeTOImpl;
            }
            finally {
                SchemaAwareDataStoreAdapter.this.getDelegateReadLock().unlock();
            }
        }
    }
}

