/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import org.opendaylight.controller.sal.core.api.notify.NotificationListener;
import org.opendaylight.controller.sal.dom.broker.spi.NotificationRouter;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationRouterImpl
implements NotificationRouter {
    private static Logger log = LoggerFactory.getLogger(NotificationRouterImpl.class);
    private Multimap<QName, Registration<NotificationListener>> listeners = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    private void sendNotification(CompositeNode notification) {
        QName type = notification.getNodeType();
        Collection toNotify = this.listeners.get((Object)type);
        log.trace("Publishing notification " + type);
        if (toNotify == null) {
            return;
        }
        for (Registration listener : toNotify) {
            try {
                ((NotificationListener)listener.getInstance()).onNotification(notification);
            }
            catch (Exception e) {
                log.error("Uncaught exception in NotificationListener", (Throwable)e);
            }
        }
    }

    @Override
    public void publish(CompositeNode notification) {
        this.sendNotification(notification);
    }

    @Override
    public Registration<NotificationListener> addNotificationListener(QName notification, NotificationListener listener) {
        ListenerRegistration ret = new ListenerRegistration(notification, listener);
        return ret;
    }

    private class ListenerRegistration
    extends AbstractObjectRegistration<NotificationListener> {
        final QName type;

        public ListenerRegistration(QName type, NotificationListener instance) {
            super((Object)instance);
            this.type = type;
        }

        protected void removeRegistration() {
            NotificationRouterImpl.this.listeners.remove((Object)this.type, (Object)this);
        }
    }
}

