/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.controller.sal.core.api.data.DataStore;
import org.opendaylight.controller.sal.dom.broker.impl.HashMapDataStoreTransaction;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;

public class HashMapDataStore
implements DataStore,
AutoCloseable {
    private final Map<InstanceIdentifier, CompositeNode> configuration = new Functions.Function0<Map<InstanceIdentifier, CompositeNode>>(){

        public Map<InstanceIdentifier, CompositeNode> apply() {
            ConcurrentHashMap<InstanceIdentifier, CompositeNode> _concurrentHashMap = new ConcurrentHashMap<InstanceIdentifier, CompositeNode>();
            return _concurrentHashMap;
        }
    }.apply();
    private final Map<InstanceIdentifier, CompositeNode> operational = new Functions.Function0<Map<InstanceIdentifier, CompositeNode>>(){

        public Map<InstanceIdentifier, CompositeNode> apply() {
            ConcurrentHashMap<InstanceIdentifier, CompositeNode> _concurrentHashMap = new ConcurrentHashMap<InstanceIdentifier, CompositeNode>();
            return _concurrentHashMap;
        }
    }.apply();

    public boolean containsConfigurationPath(InstanceIdentifier path) {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("TODO: auto-generated method stub");
        throw _unsupportedOperationException;
    }

    public boolean containsOperationalPath(InstanceIdentifier path) {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("TODO: auto-generated method stub");
        throw _unsupportedOperationException;
    }

    public Iterable<InstanceIdentifier> getStoredConfigurationPaths() {
        Set<InstanceIdentifier> _keySet = this.configuration.keySet();
        return _keySet;
    }

    public Iterable<InstanceIdentifier> getStoredOperationalPaths() {
        Set<InstanceIdentifier> _keySet = this.operational.keySet();
        return _keySet;
    }

    public CompositeNode readConfigurationData(InstanceIdentifier path) {
        CompositeNode _get = this.configuration.get(path);
        return _get;
    }

    public CompositeNode readOperationalData(InstanceIdentifier path) {
        CompositeNode _get = this.operational.get(path);
        return _get;
    }

    public DataCommitHandler.DataCommitTransaction<InstanceIdentifier, CompositeNode> requestCommit(DataModification<InstanceIdentifier, CompositeNode> modification) {
        HashMapDataStoreTransaction _hashMapDataStoreTransaction = new HashMapDataStoreTransaction(modification, this);
        return _hashMapDataStoreTransaction;
    }

    public RpcResult<Void> rollback(HashMapDataStoreTransaction transaction) {
        Set _emptySet = Collections.emptySet();
        return Rpcs.getRpcResult((boolean)true, null, _emptySet);
    }

    public RpcResult<Void> finish(HashMapDataStoreTransaction transaction) {
        DataModification<InstanceIdentifier, CompositeNode> modification = transaction.getModification();
        Map _updatedConfigurationData = modification.getUpdatedConfigurationData();
        this.configuration.putAll(_updatedConfigurationData);
        Map _updatedOperationalData = modification.getUpdatedOperationalData();
        this.operational.putAll(_updatedOperationalData);
        Set _removedConfigurationData = modification.getRemovedConfigurationData();
        for (InstanceIdentifier removal : _removedConfigurationData) {
            this.remove(this.configuration, removal);
        }
        Set _removedOperationalData = modification.getRemovedOperationalData();
        for (InstanceIdentifier removal_1 : _removedOperationalData) {
            this.remove(this.operational, removal_1);
        }
        Set _emptySet = Collections.emptySet();
        return Rpcs.getRpcResult((boolean)true, null, _emptySet);
    }

    public void remove(Map<InstanceIdentifier, CompositeNode> map, InstanceIdentifier identifier) {
        HashSet<InstanceIdentifier> _hashSet;
        HashSet<InstanceIdentifier> affected = _hashSet = new HashSet<InstanceIdentifier>();
        Set<InstanceIdentifier> _keySet = map.keySet();
        for (InstanceIdentifier path : _keySet) {
            boolean _contains = identifier.contains(path);
            if (!_contains) continue;
            affected.add(path);
        }
        for (InstanceIdentifier pathToRemove : affected) {
            map.remove(pathToRemove);
        }
    }

    @Override
    public void close() {
    }
}

