/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.controller.sal.core.api.data.DataStore;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;

public class DataStoreStatsWrapper
implements Delegator<DataStore>,
DataStore {
    private final DataStore delegate;
    private AtomicLong cfgReadCount = new AtomicLong();
    private AtomicLong cfgReadTimeTotal = new AtomicLong();
    private AtomicLong operReadCount = new AtomicLong();
    private AtomicLong operReadTimeTotal = new AtomicLong();
    private AtomicLong requestCommitCount = new AtomicLong();
    private AtomicLong requestCommitTimeTotal = new AtomicLong();

    public DataStoreStatsWrapper(DataStore store) {
        this.delegate = store;
    }

    public DataStore getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeNode readConfigurationData(InstanceIdentifier path) {
        this.cfgReadCount.incrementAndGet();
        long startTime = System.nanoTime();
        try {
            CompositeNode compositeNode = (CompositeNode)this.delegate.readConfigurationData((Object)path);
            return compositeNode;
        }
        finally {
            long endTime = System.nanoTime();
            long runTime = endTime - startTime;
            this.cfgReadTimeTotal.addAndGet(runTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeNode readOperationalData(InstanceIdentifier path) {
        this.operReadCount.incrementAndGet();
        long startTime = System.nanoTime();
        try {
            CompositeNode compositeNode = (CompositeNode)this.delegate.readOperationalData((Object)path);
            return compositeNode;
        }
        finally {
            long endTime = System.nanoTime();
            long runTime = endTime - startTime;
            this.operReadTimeTotal.addAndGet(runTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCommitHandler.DataCommitTransaction<InstanceIdentifier, CompositeNode> requestCommit(DataModification<InstanceIdentifier, CompositeNode> modification) {
        this.requestCommitCount.incrementAndGet();
        long startTime = System.nanoTime();
        try {
            DataCommitHandler.DataCommitTransaction dataCommitTransaction = this.delegate.requestCommit(modification);
            return dataCommitTransaction;
        }
        finally {
            long endTime = System.nanoTime();
            long runTime = endTime - startTime;
            this.requestCommitTimeTotal.addAndGet(runTime);
        }
    }

    public boolean containsConfigurationPath(InstanceIdentifier path) {
        return this.delegate.containsConfigurationPath(path);
    }

    public Iterable<InstanceIdentifier> getStoredConfigurationPaths() {
        return this.delegate.getStoredConfigurationPaths();
    }

    public Iterable<InstanceIdentifier> getStoredOperationalPaths() {
        return this.delegate.getStoredOperationalPaths();
    }

    public boolean containsOperationalPath(InstanceIdentifier path) {
        return this.delegate.containsOperationalPath(path);
    }

    public final long getConfigurationReadCount() {
        return this.cfgReadCount.get();
    }

    public final long getOperationalReadCount() {
        return this.operReadCount.get();
    }

    public final long getRequestCommitCount() {
        return this.requestCommitCount.get();
    }

    public final double getConfigurationReadTotalTime() {
        return (double)this.cfgReadTimeTotal.get() / 1000.0;
    }

    public final double getOperationalReadTotalTime() {
        return (double)this.operReadTimeTotal.get() / 1000.0;
    }

    public final double getRequestCommitTotalTime() {
        return (double)this.requestCommitTimeTotal.get() / 1000.0;
    }

    public final double getConfigurationReadAverageTime() {
        long readCount = this.cfgReadCount.get();
        if (readCount == 0L) {
            return 0.0;
        }
        return this.getConfigurationReadTotalTime() / (double)readCount;
    }

    public final double getOperationalReadAverageTime() {
        long readCount = this.operReadCount.get();
        if (readCount == 0L) {
            return 0.0;
        }
        return this.getOperationalReadTotalTime() / (double)readCount;
    }

    public final double getRequestCommitAverageTime() {
        long count = this.requestCommitCount.get();
        if (count == 0L) {
            return 0.0;
        }
        return this.getRequestCommitTotalTime() / (double)count;
    }
}

