/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.opendaylight.controller.md.sal.common.impl.routing.AbstractDataReadRouter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.CompositeNodeTOImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReaderRouter
extends AbstractDataReadRouter<InstanceIdentifier, CompositeNode> {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(DataReaderRouter.class);
            return _logger;
        }
    }.apply();
    private static final URI NETCONF_NAMESPACE = new Functions.Function0<URI>(){

        public URI apply() {
            URI _create = URI.create("urn:ietf:params:xml:ns:netconf:base:1.0");
            return _create;
        }
    }.apply();
    private static final QName NETCONF_DATA = new Functions.Function0<QName>(){

        public QName apply() {
            QName _qName = new QName(NETCONF_NAMESPACE, "data");
            return _qName;
        }
    }.apply();

    protected CompositeNode merge(InstanceIdentifier path, Iterable<CompositeNode> data) {
        ArrayList<Object> _arrayList_1;
        HashMap _hashMap;
        ArrayList<? extends Node<? extends Object>> _arrayList;
        List _path = path.getPath();
        InstanceIdentifier.PathArgument pathArgument = (InstanceIdentifier.PathArgument)IterableExtensions.last((Iterable)_path);
        boolean empty = true;
        QName _nodeType = null;
        if (pathArgument != null) {
            _nodeType = pathArgument.getNodeType();
        }
        QName name = _nodeType;
        ArrayList<? extends Node<? extends Object>> nodes = _arrayList = new ArrayList<Node<? extends Object>>();
        HashMap keyNodes = _hashMap = new HashMap();
        Iterator<CompositeNode> iterator = data.iterator();
        for (CompositeNode dataBit : data) {
            try {
                boolean _notEquals;
                boolean _and = false;
                boolean bl = _notEquals = !Objects.equal((Object)pathArgument, null);
                if (!_notEquals) {
                    _and = false;
                } else {
                    boolean _notEquals_1 = !Objects.equal((Object)dataBit, null);
                    boolean bl2 = _and = _notEquals && _notEquals_1;
                }
                if (_and) {
                    empty = false;
                    Map<QName, SimpleNode<? extends Object>> keyNodesLocal = this.getKeyNodes(pathArgument, dataBit);
                    Set<Map.Entry<QName, SimpleNode<? extends Object>>> _entrySet = keyNodesLocal.entrySet();
                    Collection<? extends Node<? extends Object>> _childrenWithout = this.childrenWithout(dataBit, _entrySet);
                    nodes.addAll(_childrenWithout);
                    continue;
                }
                boolean _notEquals_2 = !Objects.equal((Object)dataBit, null);
                if (!_notEquals_2) continue;
                empty = false;
                List _children = dataBit.getChildren();
                nodes.addAll(_children);
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalStateException) {
                    IllegalStateException e = (IllegalStateException)_t;
                    LOG.error("BUG: Readed data for path {} was invalid", (Object)path, (Object)e);
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        if (empty) {
            return null;
        }
        boolean _equals = Objects.equal((Object)pathArgument, null);
        if (_equals) {
            CompositeNodeTOImpl _compositeNodeTOImpl = new CompositeNodeTOImpl(NETCONF_DATA, null, nodes);
            return _compositeNodeTOImpl;
        }
        ArrayList<Object> finalNodes = _arrayList_1 = new ArrayList<Object>();
        Collection _values = keyNodes.values();
        finalNodes.addAll(_values);
        finalNodes.addAll(nodes);
        CompositeNodeTOImpl _compositeNodeTOImpl_1 = new CompositeNodeTOImpl(name, null, finalNodes);
        return _compositeNodeTOImpl_1;
    }

    protected Map<QName, SimpleNode<? extends Object>> _getKeyNodes(InstanceIdentifier.PathArgument argument, CompositeNode node) {
        return Collections.emptyMap();
    }

    protected Map<QName, SimpleNode<? extends Object>> _getKeyNodes(InstanceIdentifier.NodeIdentifierWithPredicates argument, CompositeNode node) {
        HashMap<QName, SimpleNode<? extends Object>> _hashMap;
        HashMap<QName, SimpleNode<? extends Object>> ret = _hashMap = new HashMap<QName, SimpleNode<? extends Object>>();
        Map _keyValues = argument.getKeyValues();
        Set _entrySet = _keyValues.entrySet();
        for (Map.Entry keyValue : _entrySet) {
            boolean _tripleEquals;
            boolean _tripleNotEquals;
            QName _key = (QName)keyValue.getKey();
            List simpleNode = node.getSimpleNodesByName(_key);
            boolean _and = false;
            boolean bl = _tripleNotEquals = simpleNode != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _isEmpty = simpleNode.isEmpty();
                boolean _not = !_isEmpty;
                boolean bl2 = _and = _tripleNotEquals && _not;
            }
            if (_and) {
                int _size = simpleNode.size();
                boolean _lessEqualsThan = _size <= 1;
                QName _key_1 = (QName)keyValue.getKey();
                Preconditions.checkState((boolean)_lessEqualsThan, (String)"Only one simple node for key $s is allowed in node $s", (Object[])new Object[]{_key_1, node});
                SimpleNode _get = (SimpleNode)simpleNode.get(0);
                Object _value = _get.getValue();
                Object _value_1 = keyValue.getValue();
                boolean _equals = Objects.equal((Object)_value, _value_1);
                Preconditions.checkState((boolean)_equals, (Object)"Key node must equals to instance identifier value");
                QName _key_2 = (QName)keyValue.getKey();
                SimpleNode _get_1 = (SimpleNode)simpleNode.get(0);
                ret.put(_key_2, (SimpleNode<? extends Object>)_get_1);
            }
            QName _key_3 = (QName)keyValue.getKey();
            List compositeNode = node.getCompositesByName(_key_3);
            boolean _or = false;
            boolean bl3 = _tripleEquals = compositeNode == null;
            if (_tripleEquals) {
                _or = true;
            } else {
                boolean _isEmpty_1 = compositeNode.isEmpty();
                _or = _tripleEquals || _isEmpty_1;
            }
            Preconditions.checkState((boolean)_or, (Object)"Key node must be Simple Node, not composite node.");
        }
        return ret;
    }

    public Collection<? extends Node<? extends Object>> childrenWithout(CompositeNode node, Set<Map.Entry<QName, SimpleNode<? extends Object>>> entries) {
        ArrayList<Node> _arrayList;
        boolean _isEmpty = entries.isEmpty();
        if (_isEmpty) {
            return node.getChildren();
        }
        ArrayList<Node> filteredNodes = _arrayList = new ArrayList<Node>();
        List _children = node.getChildren();
        for (Node scannedNode : _children) {
            QName _nodeType = scannedNode.getNodeType();
            boolean _contains = entries.contains(_nodeType);
            boolean _not = !_contains;
            if (!_not) continue;
            filteredNodes.add(scannedNode);
        }
        return filteredNodes;
    }

    public Map<QName, SimpleNode<? extends Object>> getKeyNodes(InstanceIdentifier.PathArgument argument, CompositeNode node) {
        if (argument instanceof InstanceIdentifier.NodeIdentifierWithPredicates) {
            return this._getKeyNodes((InstanceIdentifier.NodeIdentifierWithPredicates)argument, node);
        }
        if (argument != null) {
            return this._getKeyNodes(argument, node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(argument, node).toString());
    }
}

