/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.BrokerService;
import org.opendaylight.controller.sal.core.api.Consumer;
import org.opendaylight.controller.sal.core.api.Provider;
import org.opendaylight.controller.sal.core.api.notify.NotificationListener;
import org.opendaylight.controller.sal.core.api.notify.NotificationPublishService;
import org.opendaylight.controller.sal.core.api.notify.NotificationService;
import org.opendaylight.controller.sal.core.spi.BrokerModule;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationModule
implements BrokerModule {
    private static Logger log = LoggerFactory.getLogger(NotificationModule.class);
    private Multimap<QName, NotificationListener> listeners = HashMultimap.create();
    private static final Set<Class<? extends BrokerService>> PROVIDED_SERVICE_TYPE = ImmutableSet.of(NotificationService.class, NotificationPublishService.class);
    private static final Set<Class<? extends Consumer.ConsumerFunctionality>> SUPPORTED_CONSUMER_FUNCTIONALITY = ImmutableSet.of(NotificationListener.class, NotificationListener.class);

    public Set<Class<? extends BrokerService>> getProvidedServices() {
        return PROVIDED_SERVICE_TYPE;
    }

    public Set<Class<? extends Consumer.ConsumerFunctionality>> getSupportedConsumerFunctionality() {
        return SUPPORTED_CONSUMER_FUNCTIONALITY;
    }

    public <T extends BrokerService> T getServiceForSession(Class<T> service, Broker.ConsumerSession session) {
        if (NotificationPublishService.class.equals(service) && session instanceof Broker.ProviderSession) {
            NotificationPublishService ret = this.newNotificationPublishService(session);
            return (T)ret;
        }
        if (NotificationService.class.equals(service)) {
            NotificationService ret = this.newNotificationConsumerService(session);
            return (T)ret;
        }
        throw new IllegalArgumentException("The requested session-specific service is not provided by this module.");
    }

    private void sendNotification(CompositeNode notification) {
        QName type = notification.getNodeType();
        Collection toNotify = this.listeners.get((Object)type);
        log.trace("Publishing notification " + type);
        if (toNotify == null) {
            return;
        }
        for (NotificationListener listener : toNotify) {
            try {
                listener.onNotification(notification);
            }
            catch (Exception e) {
                log.error("Uncaught exception in NotificationListener", (Throwable)e);
            }
        }
    }

    private NotificationService newNotificationConsumerService(Broker.ConsumerSession session) {
        return new NotificationConsumerSessionImpl();
    }

    private NotificationPublishService newNotificationPublishService(Broker.ConsumerSession session) {
        return new NotificationProviderSessionImpl();
    }

    public Set<Class<? extends Provider.ProviderFunctionality>> getSupportedProviderFunctionality() {
        return Collections.emptySet();
    }

    private class NotificationProviderSessionImpl
    extends NotificationConsumerSessionImpl
    implements NotificationPublishService {
        private NotificationProviderSessionImpl() {
        }

        public void sendNotification(CompositeNode notification) {
            this.checkSessionState();
            if (notification == null) {
                throw new IllegalArgumentException("Notification must not be null.");
            }
            NotificationModule.this.sendNotification(notification);
        }

        public void publish(CompositeNode notification) {
            this.sendNotification(notification);
        }
    }

    private class NotificationConsumerSessionImpl
    implements NotificationService {
        private Multimap<QName, NotificationListener> consumerListeners = HashMultimap.create();
        private boolean closed = false;

        private NotificationConsumerSessionImpl() {
        }

        public Registration<NotificationListener> addNotificationListener(QName notification, NotificationListener listener) {
            this.checkSessionState();
            if (notification == null) {
                throw new IllegalArgumentException("Notification type must not be null.");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null.");
            }
            this.consumerListeners.put((Object)notification, (Object)listener);
            NotificationModule.this.listeners.put((Object)notification, (Object)listener);
            log.trace("Registered listener for notification: " + notification);
            return null;
        }

        public void removeNotificationListener(QName notification, NotificationListener listener) {
            this.checkSessionState();
            if (notification == null) {
                throw new IllegalArgumentException("Notification type must not be null.");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null.");
            }
            this.consumerListeners.remove((Object)notification, (Object)listener);
            NotificationModule.this.listeners.remove((Object)notification, (Object)listener);
        }

        public void closeSession() {
            this.closed = true;
            Map toRemove = this.consumerListeners.asMap();
            for (Map.Entry entry : toRemove.entrySet()) {
                NotificationModule.this.listeners.remove(entry.getKey(), entry.getValue());
            }
        }

        protected void checkSessionState() {
            if (this.closed) {
                throw new IllegalStateException("Session is closed");
            }
        }
    }
}

