/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import com.google.common.base.Preconditions;
import java.util.EventListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.sal.core.api.data.DataProviderService;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionInstance;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionService;
import org.opendaylight.controller.sal.dom.broker.MountPointImpl;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;

public class MountPointManagerImpl
implements MountProvisionService {
    private DataProviderService _dataBroker;
    private final ListenerRegistry<MountProvisionService.MountProvisionListener> listeners = new Functions.Function0<ListenerRegistry<MountProvisionService.MountProvisionListener>>(){

        public ListenerRegistry<MountProvisionService.MountProvisionListener> apply() {
            ListenerRegistry _create = ListenerRegistry.create();
            return _create;
        }
    }.apply();
    private ConcurrentMap<InstanceIdentifier, MountPointImpl> mounts = new Functions.Function0<ConcurrentMap<InstanceIdentifier, MountPointImpl>>(){

        public ConcurrentMap<InstanceIdentifier, MountPointImpl> apply() {
            ConcurrentHashMap<InstanceIdentifier, MountPointImpl> _concurrentHashMap = new ConcurrentHashMap<InstanceIdentifier, MountPointImpl>();
            return _concurrentHashMap;
        }
    }.apply();

    public DataProviderService getDataBroker() {
        return this._dataBroker;
    }

    public void setDataBroker(DataProviderService dataBroker) {
        this._dataBroker = dataBroker;
    }

    public MountProvisionInstance createMountPoint(InstanceIdentifier path) {
        MountPointImpl _mountPointImpl;
        boolean _containsKey = this.mounts.containsKey(path);
        boolean _not = !_containsKey;
        Preconditions.checkState((boolean)_not, (Object)"Mount already created");
        MountPointImpl mount = _mountPointImpl = new MountPointImpl(path);
        this.registerMountPoint(mount);
        this.mounts.put(path, mount);
        this.notifyMountCreated(path);
        return mount;
    }

    public void notifyMountCreated(InstanceIdentifier identifier) {
        for (ListenerRegistration listener : this.listeners) {
            MountProvisionService.MountProvisionListener _instance = (MountProvisionService.MountProvisionListener)listener.getInstance();
            _instance.onMountPointCreated(identifier);
        }
    }

    public Object registerMountPoint(MountPointImpl impl) {
        return null;
    }

    public ListenerRegistration<MountProvisionService.MountProvisionListener> registerProvisionListener(MountProvisionService.MountProvisionListener listener) {
        ListenerRegistration _register = this.listeners.register((EventListener)listener);
        return _register;
    }

    public MountProvisionInstance createOrGetMountPoint(InstanceIdentifier path) {
        boolean _tripleEquals;
        MountPointImpl mount = (MountPointImpl)this.mounts.get(path);
        boolean bl = _tripleEquals = mount == null;
        if (_tripleEquals) {
            return this.createMountPoint(path);
        }
        return mount;
    }

    public MountProvisionInstance getMountPoint(InstanceIdentifier path) {
        MountPointImpl _get = (MountPointImpl)this.mounts.get(path);
        return _get;
    }
}

