/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.common.api.RegistrationListener;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandlerRegistration;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangeListener;
import org.opendaylight.controller.sal.common.DataStoreIdentifier;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.RpcImplementation;
import org.opendaylight.controller.sal.core.api.RpcRegistrationListener;
import org.opendaylight.controller.sal.core.api.RpcRoutingContext;
import org.opendaylight.controller.sal.core.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.core.api.data.DataProviderService;
import org.opendaylight.controller.sal.core.api.data.DataValidator;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionInstance;
import org.opendaylight.controller.sal.core.api.notify.NotificationListener;
import org.opendaylight.controller.sal.dom.broker.DataBrokerImpl;
import org.opendaylight.controller.sal.dom.broker.impl.NotificationRouterImpl;
import org.opendaylight.controller.sal.dom.broker.impl.SchemaAwareRpcBroker;
import org.opendaylight.controller.sal.dom.broker.impl.SchemaContextProvider;
import org.opendaylight.controller.sal.dom.broker.spi.NotificationRouter;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class MountPointImpl
implements MountProvisionInstance,
SchemaContextProvider {
    private final SchemaAwareRpcBroker rpcs;
    private final DataBrokerImpl dataReader;
    private final NotificationRouter notificationRouter;
    private final DataReader<InstanceIdentifier, CompositeNode> readWrapper;
    private final InstanceIdentifier mountPath;
    private SchemaContext schemaContext;

    public MountPointImpl(InstanceIdentifier path) {
        this.mountPath = path;
        this.rpcs = new SchemaAwareRpcBroker(path.toString(), this);
        this.dataReader = new DataBrokerImpl();
        this.notificationRouter = new NotificationRouterImpl();
        this.readWrapper = new ReadWrapper();
    }

    public InstanceIdentifier getMountPath() {
        return this.mountPath;
    }

    public DataReader<InstanceIdentifier, CompositeNode> getReadWrapper() {
        return this.readWrapper;
    }

    public void publish(CompositeNode notification) {
        this.notificationRouter.publish(notification);
    }

    public Registration<NotificationListener> addNotificationListener(QName notification, NotificationListener listener) {
        return this.notificationRouter.addNotificationListener(notification, listener);
    }

    public CompositeNode readConfigurationData(InstanceIdentifier path) {
        return (CompositeNode)this.dataReader.readConfigurationData((Path)path);
    }

    public CompositeNode readOperationalData(InstanceIdentifier path) {
        return (CompositeNode)this.dataReader.readOperationalData((Path)path);
    }

    public Registration<DataReader<InstanceIdentifier, CompositeNode>> registerOperationalReader(InstanceIdentifier path, DataReader<InstanceIdentifier, CompositeNode> reader) {
        return this.dataReader.registerOperationalReader(path, reader);
    }

    public Registration<DataReader<InstanceIdentifier, CompositeNode>> registerConfigurationReader(InstanceIdentifier path, DataReader<InstanceIdentifier, CompositeNode> reader) {
        return this.dataReader.registerConfigurationReader(path, reader);
    }

    public Broker.RoutedRpcRegistration addRoutedRpcImplementation(QName rpcType, RpcImplementation implementation) {
        return this.rpcs.addRoutedRpcImplementation(rpcType, implementation);
    }

    public Broker.RpcRegistration addRpcImplementation(QName rpcType, RpcImplementation implementation) throws IllegalArgumentException {
        return this.rpcs.addRpcImplementation(rpcType, implementation);
    }

    public Set<QName> getSupportedRpcs() {
        return this.rpcs.getSupportedRpcs();
    }

    public RpcResult<CompositeNode> invokeRpc(QName rpc, CompositeNode input) {
        return this.rpcs.invokeRpc(rpc, input);
    }

    public ListenerRegistration<RpcRegistrationListener> addRpcRegistrationListener(RpcRegistrationListener listener) {
        return this.rpcs.addRpcRegistrationListener(listener);
    }

    public Future<RpcResult<CompositeNode>> rpc(QName type, CompositeNode input) {
        return null;
    }

    public DataModificationTransaction beginTransaction() {
        return this.dataReader.beginTransaction();
    }

    public ListenerRegistration<org.opendaylight.controller.sal.core.api.data.DataChangeListener> registerDataChangeListener(InstanceIdentifier path, org.opendaylight.controller.sal.core.api.data.DataChangeListener listener) {
        return this.dataReader.registerDataChangeListener((Path)path, (DataChangeListener)listener);
    }

    public void sendNotification(CompositeNode notification) {
        this.publish(notification);
    }

    public Registration<DataCommitHandler<InstanceIdentifier, CompositeNode>> registerCommitHandler(InstanceIdentifier path, DataCommitHandler<InstanceIdentifier, CompositeNode> commitHandler) {
        return this.dataReader.registerCommitHandler((Path)path, commitHandler);
    }

    public void removeRefresher(DataStoreIdentifier store, DataProviderService.DataRefresher refresher) {
    }

    public void addRefresher(DataStoreIdentifier store, DataProviderService.DataRefresher refresher) {
    }

    public void addValidator(DataStoreIdentifier store, DataValidator validator) {
    }

    public void removeValidator(DataStoreIdentifier store, DataValidator validator) {
    }

    @Override
    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public void setSchemaContext(SchemaContext schemaContext) {
        this.schemaContext = schemaContext;
    }

    public ListenerRegistration<RegistrationListener<DataCommitHandlerRegistration<InstanceIdentifier, CompositeNode>>> registerCommitHandlerListener(RegistrationListener<DataCommitHandlerRegistration<InstanceIdentifier, CompositeNode>> commitHandlerListener) {
        return this.dataReader.registerCommitHandlerListener(commitHandlerListener);
    }

    public <L extends RouteChangeListener<RpcRoutingContext, InstanceIdentifier>> ListenerRegistration<L> registerRouteChangeListener(L listener) {
        return this.rpcs.registerRouteChangeListener(listener);
    }

    class ReadWrapper
    implements DataReader<InstanceIdentifier, CompositeNode> {
        ReadWrapper() {
        }

        private InstanceIdentifier shortenPath(InstanceIdentifier path) {
            InstanceIdentifier ret = null;
            if (MountPointImpl.this.mountPath.contains(path)) {
                List newArgs = path.getPath().subList(MountPointImpl.this.mountPath.getPath().size(), path.getPath().size());
                ret = new InstanceIdentifier(newArgs);
            }
            return ret;
        }

        public CompositeNode readConfigurationData(InstanceIdentifier path) {
            InstanceIdentifier newPath = this.shortenPath(path);
            if (newPath == null) {
                return null;
            }
            return MountPointImpl.this.readConfigurationData(newPath);
        }

        public CompositeNode readOperationalData(InstanceIdentifier path) {
            InstanceIdentifier newPath = this.shortenPath(path);
            if (newPath == null) {
                return null;
            }
            return MountPointImpl.this.readOperationalData(newPath);
        }
    }
}

