/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.controller.sal.dom.broker.impl.SchemaContextProvider;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.concepts.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaServiceListener;
import org.opendaylight.yangtools.yang.parser.impl.util.URLSchemaContextResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalBundleScanningSchemaServiceImpl
implements SchemaContextProvider,
SchemaService,
ServiceTrackerCustomizer<SchemaServiceListener, SchemaServiceListener>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GlobalBundleScanningSchemaServiceImpl.class);
    private ListenerRegistry<SchemaServiceListener> listeners;
    private BundleContext context;
    private BundleScanner scanner = new BundleScanner();
    private BundleTracker<ImmutableSet<Registration<URL>>> bundleTracker;
    private final URLSchemaContextResolver contextResolver = new URLSchemaContextResolver();
    private ServiceTracker<SchemaServiceListener, SchemaServiceListener> listenerTracker;
    private boolean starting = true;

    public ListenerRegistry<SchemaServiceListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(ListenerRegistry<SchemaServiceListener> listeners) {
        this.listeners = listeners;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public void start() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0);
        if (this.listeners == null) {
            this.listeners = new ListenerRegistry();
        }
        this.listenerTracker = new ServiceTracker(this.context, SchemaServiceListener.class, (ServiceTrackerCustomizer)this);
        this.bundleTracker = new BundleTracker(this.context, 96, (BundleTrackerCustomizer)this.scanner);
        this.bundleTracker.open();
        this.listenerTracker.open();
        this.starting = false;
        this.tryToUpdateSchemaContext();
    }

    @Override
    public SchemaContext getSchemaContext() {
        return this.getGlobalContext();
    }

    public SchemaContext getGlobalContext() {
        return (SchemaContext)this.contextResolver.getSchemaContext().orNull();
    }

    public void addModule(Module module) {
        throw new UnsupportedOperationException();
    }

    public SchemaContext getSessionContext() {
        throw new UnsupportedOperationException();
    }

    public void removeModule(Module module) {
        throw new UnsupportedOperationException();
    }

    public ListenerRegistration<SchemaServiceListener> registerSchemaServiceListener(SchemaServiceListener listener) {
        return this.listeners.register((EventListener)listener);
    }

    @Override
    public void close() throws Exception {
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
        }
        if (this.listenerTracker != null) {
            this.listenerTracker.close();
        }
    }

    private void updateContext(SchemaContext snapshot) {
        Object[] services = this.listenerTracker.getServices();
        if (services != null) {
            for (Object rawListener : services) {
                SchemaServiceListener listener = (SchemaServiceListener)rawListener;
                try {
                    listener.onGlobalContextUpdated(snapshot);
                }
                catch (Exception e) {
                    logger.error("Exception occured during invoking listener", (Throwable)e);
                }
            }
        }
        for (ListenerRegistration listener : this.listeners) {
            try {
                ((SchemaServiceListener)listener.getInstance()).onGlobalContextUpdated(snapshot);
            }
            catch (Exception e) {
                logger.error("Exception occured during invoking listener", (Throwable)e);
            }
        }
    }

    public SchemaServiceListener addingService(ServiceReference<SchemaServiceListener> reference) {
        SchemaServiceListener listener = (SchemaServiceListener)this.context.getService(reference);
        SchemaContext _ctxContext = this.getGlobalContext();
        if (this.getContext() != null && _ctxContext != null) {
            listener.onGlobalContextUpdated(_ctxContext);
        }
        return listener;
    }

    public synchronized void tryToUpdateSchemaContext() {
        if (this.starting) {
            return;
        }
        Optional schema = this.contextResolver.tryToUpdateSchemaContext();
        if (schema.isPresent()) {
            this.updateContext((SchemaContext)schema.get());
        }
    }

    public void modifiedService(ServiceReference<SchemaServiceListener> reference, SchemaServiceListener service) {
    }

    public void removedService(ServiceReference<SchemaServiceListener> reference, SchemaServiceListener service) {
        this.context.ungetService(reference);
    }

    private class BundleScanner
    implements BundleTrackerCustomizer<ImmutableSet<Registration<URL>>> {
        private BundleScanner() {
        }

        public ImmutableSet<Registration<URL>> addingBundle(Bundle bundle, BundleEvent event) {
            if (bundle.getBundleId() == 0L) {
                return ImmutableSet.of();
            }
            Enumeration enumeration = bundle.findEntries("META-INF/yang", "*.yang", false);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            while (enumeration != null && enumeration.hasMoreElements()) {
                Registration reg = GlobalBundleScanningSchemaServiceImpl.this.contextResolver.registerSource((URL)enumeration.nextElement());
                builder.add((Object)reg);
            }
            ImmutableSet urls = builder.build();
            if (urls.isEmpty()) {
                return urls;
            }
            GlobalBundleScanningSchemaServiceImpl.this.tryToUpdateSchemaContext();
            return urls;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, ImmutableSet<Registration<URL>> object) {
            logger.debug("Modified bundle {} {} {}", new Object[]{bundle, event, object});
        }

        public synchronized void removedBundle(Bundle bundle, BundleEvent event, ImmutableSet<Registration<URL>> urls) {
            for (Registration url : urls) {
                try {
                    url.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            GlobalBundleScanningSchemaServiceImpl.this.tryToUpdateSchemaContext();
        }
    }
}

