/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataBroker;
import org.opendaylight.controller.sal.common.DataStoreIdentifier;
import org.opendaylight.controller.sal.core.api.data.DataChangeListener;
import org.opendaylight.controller.sal.core.api.data.DataProviderService;
import org.opendaylight.controller.sal.core.api.data.DataValidator;
import org.opendaylight.controller.sal.dom.broker.DataTransactionImpl;
import org.opendaylight.controller.sal.dom.broker.impl.DataReaderRouter;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;

public class DataBrokerImpl
extends AbstractDataBroker<InstanceIdentifier, CompositeNode, DataChangeListener>
implements DataProviderService,
AutoCloseable {
    private AtomicLong nextTransaction = new AtomicLong();
    private final AtomicLong createdTransactionsCount = new AtomicLong();

    public DataBrokerImpl() {
        this.setDataReadRouter(new DataReaderRouter());
        this.setExecutor((ExecutorService)MoreExecutors.sameThreadExecutor());
    }

    public AtomicLong getCreatedTransactionsCount() {
        return this.createdTransactionsCount;
    }

    public DataTransactionImpl beginTransaction() {
        String transactionId = "DOM-" + this.nextTransaction.getAndIncrement();
        this.createdTransactionsCount.getAndIncrement();
        return new DataTransactionImpl(transactionId, this);
    }

    public Registration<DataReader<InstanceIdentifier, CompositeNode>> registerConfigurationReader(InstanceIdentifier path, DataReader<InstanceIdentifier, CompositeNode> reader) {
        return this.getDataReadRouter().registerConfigurationReader((Path)path, reader);
    }

    public Registration<DataReader<InstanceIdentifier, CompositeNode>> registerOperationalReader(InstanceIdentifier path, DataReader<InstanceIdentifier, CompositeNode> reader) {
        return this.getDataReadRouter().registerOperationalReader((Path)path, reader);
    }

    @Deprecated
    public void addValidator(DataStoreIdentifier store, DataValidator validator) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public void removeValidator(DataStoreIdentifier store, DataValidator validator) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public void addRefresher(DataStoreIdentifier store, DataProviderService.DataRefresher refresher) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public void removeRefresher(DataStoreIdentifier store, DataProviderService.DataRefresher refresher) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Override
    public void close() throws Exception {
    }
}

