/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import com.google.common.base.Objects;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.Collection;
import java.util.concurrent.Future;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.BrokerService;
import org.opendaylight.controller.sal.core.api.Consumer;
import org.opendaylight.controller.sal.dom.broker.BrokerImpl;
import org.opendaylight.controller.sal.dom.broker.osgi.AbstractBrokerServiceProxy;
import org.opendaylight.controller.sal.dom.broker.osgi.ProxyFactory;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConsumerContextImpl
implements Broker.ConsumerSession {
    private final Consumer _consumer;
    private BrokerImpl _broker;
    private final ClassToInstanceMap<BrokerService> instantiatedServices = new Functions.Function0<ClassToInstanceMap<BrokerService>>(){

        public ClassToInstanceMap<BrokerService> apply() {
            MutableClassToInstanceMap _create = MutableClassToInstanceMap.create();
            return _create;
        }
    }.apply();
    private boolean closed = false;
    private BundleContext context;

    public Consumer getConsumer() {
        return this._consumer;
    }

    public BrokerImpl getBroker() {
        return this._broker;
    }

    public void setBroker(BrokerImpl broker) {
        this._broker = broker;
    }

    public ConsumerContextImpl(Consumer consumer, BundleContext ctx) {
        this._consumer = consumer;
        this.context = ctx;
    }

    public Future<RpcResult<CompositeNode>> rpc(QName rpc, CompositeNode input) {
        BrokerImpl _broker = this.getBroker();
        return _broker.invokeRpc(rpc, input);
    }

    public <T extends BrokerService> T getService(Class<T> service) {
        boolean _notEquals_1;
        boolean _notEquals;
        BrokerService localProxy = (BrokerService)this.instantiatedServices.getInstance(service);
        boolean bl = _notEquals = !Objects.equal((Object)localProxy, null);
        if (_notEquals) {
            return (T)localProxy;
        }
        ServiceReference serviceRef = this.context.getServiceReference(service);
        boolean _equals = Objects.equal((Object)serviceRef, null);
        if (_equals) {
            return null;
        }
        BrokerService serviceImpl = (BrokerService)this.context.getService(serviceRef);
        BrokerService ret = ProxyFactory.createProxy(serviceRef, serviceImpl);
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)ret, null);
        if (_notEquals_1) {
            this.instantiatedServices.putInstance(service, (Object)ret);
        }
        return (T)ret;
    }

    public void close() {
        try {
            Collection toStop = this.instantiatedServices.values();
            this.closed = true;
            for (BrokerService brokerService : toStop) {
                if (!(brokerService instanceof AbstractBrokerServiceProxy)) continue;
                ((AutoCloseable)brokerService).close();
            }
            BrokerImpl _broker = this.getBroker();
            _broker.consumerSessionClosed(this);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

