/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangeListener;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Consumer;
import org.opendaylight.controller.sal.core.api.Provider;
import org.opendaylight.controller.sal.core.api.RpcImplementation;
import org.opendaylight.controller.sal.core.api.RpcProvisionRegistry;
import org.opendaylight.controller.sal.core.api.RpcRegistrationListener;
import org.opendaylight.controller.sal.core.api.RpcRoutingContext;
import org.opendaylight.controller.sal.dom.broker.ConsumerContextImpl;
import org.opendaylight.controller.sal.dom.broker.ProviderContextImpl;
import org.opendaylight.controller.sal.dom.broker.spi.RpcRouter;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerImpl
implements Broker,
RpcProvisionRegistry,
AutoCloseable {
    private static final Logger log = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(BrokerImpl.class);
            return _logger;
        }
    }.apply();
    private final Set<ConsumerContextImpl> sessions = new Functions.Function0<Set<ConsumerContextImpl>>(){

        public Set<ConsumerContextImpl> apply() {
            HashSet _hashSet = new HashSet();
            Set<ConsumerContextImpl> _synchronizedSet = Collections.synchronizedSet(_hashSet);
            return _synchronizedSet;
        }
    }.apply();
    private final Set<ProviderContextImpl> providerSessions = new Functions.Function0<Set<ProviderContextImpl>>(){

        public Set<ProviderContextImpl> apply() {
            HashSet _hashSet = new HashSet();
            Set<ProviderContextImpl> _synchronizedSet = Collections.synchronizedSet(_hashSet);
            return _synchronizedSet;
        }
    }.apply();
    private ExecutorService _executor = new Functions.Function0<ExecutorService>(){

        public ExecutorService apply() {
            ExecutorService _newFixedThreadPool = Executors.newFixedThreadPool(5);
            return _newFixedThreadPool;
        }
    }.apply();
    private BundleContext _bundleContext;
    private AutoCloseable _deactivator;
    private RpcRouter _router;

    public ExecutorService getExecutor() {
        return this._executor;
    }

    public void setExecutor(ExecutorService executor) {
        this._executor = executor;
    }

    public BundleContext getBundleContext() {
        return this._bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public AutoCloseable getDeactivator() {
        return this._deactivator;
    }

    public void setDeactivator(AutoCloseable deactivator) {
        this._deactivator = deactivator;
    }

    public RpcRouter getRouter() {
        return this._router;
    }

    public void setRouter(RpcRouter router) {
        this._router = router;
    }

    public Broker.ConsumerSession registerConsumer(Consumer consumer, BundleContext ctx) {
        this.checkPredicates(consumer);
        String _plus = "Registering consumer " + consumer;
        log.trace(_plus);
        ConsumerContextImpl session = this.newSessionFor(consumer, ctx);
        consumer.onSessionInitiated((Broker.ConsumerSession)session);
        this.sessions.add(session);
        return session;
    }

    public Broker.ProviderSession registerProvider(Provider provider, BundleContext ctx) {
        this.checkPredicates(provider);
        ProviderContextImpl session = this.newSessionFor(provider, ctx);
        provider.onSessionInitiated((Broker.ProviderSession)session);
        this.providerSessions.add(session);
        return session;
    }

    protected Future<RpcResult<CompositeNode>> invokeRpc(final QName rpc, final CompositeNode input) {
        ExecutorService _executor = this.getExecutor();
        Functions.Function0<RpcResult> _function = new Functions.Function0<RpcResult>(){

            public RpcResult apply() {
                RpcRouter _router = BrokerImpl.this.getRouter();
                RpcResult<CompositeNode> _invokeRpc = _router.invokeRpc(rpc, input);
                return _invokeRpc;
            }
        };
        Future<RpcResult<CompositeNode>> result = _executor.submit(new Callable<RpcResult<CompositeNode>>((Functions.Function0)_function){
            final /* synthetic */ Functions.Function0 val$_function;
            {
                this.val$_function = function0;
            }

            @Override
            public RpcResult<CompositeNode> call() {
                return (RpcResult)this.val$_function.apply();
            }
        });
        return result;
    }

    private void checkPredicates(Provider prov) {
        boolean _equals = Objects.equal((Object)prov, null);
        if (_equals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Provider should not be null.");
            throw _illegalArgumentException;
        }
        for (ProviderContextImpl session : this.providerSessions) {
            Provider _provider = session.getProvider();
            boolean _equals_1 = prov.equals(_provider);
            if (!_equals_1) continue;
            IllegalStateException _illegalStateException = new IllegalStateException("Provider already registered");
            throw _illegalStateException;
        }
    }

    private void checkPredicates(Consumer cons) {
        boolean _equals = Objects.equal((Object)cons, null);
        if (_equals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Consumer should not be null.");
            throw _illegalArgumentException;
        }
        for (ConsumerContextImpl session : this.sessions) {
            Consumer _consumer = session.getConsumer();
            boolean _equals_1 = cons.equals(_consumer);
            if (!_equals_1) continue;
            IllegalStateException _illegalStateException = new IllegalStateException("Consumer already registered");
            throw _illegalStateException;
        }
    }

    private ConsumerContextImpl newSessionFor(Consumer provider, BundleContext ctx) {
        ConsumerContextImpl _consumerContextImpl;
        ConsumerContextImpl ret = _consumerContextImpl = new ConsumerContextImpl(provider, ctx);
        ret.setBroker(this);
        return ret;
    }

    private ProviderContextImpl newSessionFor(Provider provider, BundleContext ctx) {
        ProviderContextImpl _providerContextImpl;
        ProviderContextImpl ret = _providerContextImpl = new ProviderContextImpl(provider, ctx);
        ret.setBroker(this);
        return ret;
    }

    protected void consumerSessionClosed(ConsumerContextImpl consumerContextImpl) {
        this.sessions.remove(consumerContextImpl);
        this.providerSessions.remove(consumerContextImpl);
    }

    @Override
    public void close() throws Exception {
        AutoCloseable _deactivator = this.getDeactivator();
        if (_deactivator != null) {
            _deactivator.close();
        }
    }

    public Broker.RpcRegistration addRpcImplementation(QName rpcType, RpcImplementation implementation) throws IllegalArgumentException {
        RpcRouter _router = this.getRouter();
        Broker.RpcRegistration _addRpcImplementation = _router.addRpcImplementation(rpcType, implementation);
        return _addRpcImplementation;
    }

    public Broker.RoutedRpcRegistration addRoutedRpcImplementation(QName rpcType, RpcImplementation implementation) {
        RpcRouter _router = this.getRouter();
        Broker.RoutedRpcRegistration _addRoutedRpcImplementation = _router.addRoutedRpcImplementation(rpcType, implementation);
        return _addRoutedRpcImplementation;
    }

    public ListenerRegistration<RpcRegistrationListener> addRpcRegistrationListener(RpcRegistrationListener listener) {
        RpcRouter _router = this.getRouter();
        return _router.addRpcRegistrationListener(listener);
    }

    public <L extends RouteChangeListener<RpcRoutingContext, InstanceIdentifier>> ListenerRegistration<L> registerRouteChangeListener(L listener) {
        RpcRouter _router = this.getRouter();
        return _router.registerRouteChangeListener(listener);
    }
}

