/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.sal.core.api.RpcProvisionRegistry;
import org.opendaylight.controller.sal.core.api.data.DataBrokerService;
import org.opendaylight.controller.sal.core.api.data.DataProviderService;
import org.opendaylight.controller.sal.core.api.data.DataStore;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionService;
import org.opendaylight.controller.sal.core.api.mount.MountService;
import org.opendaylight.controller.sal.dom.broker.BrokerImpl;
import org.opendaylight.controller.sal.dom.broker.DataBrokerImpl;
import org.opendaylight.controller.sal.dom.broker.MountPointManagerImpl;
import org.opendaylight.controller.sal.dom.broker.impl.SchemaAwareDataStoreAdapter;
import org.opendaylight.controller.sal.dom.broker.impl.SchemaAwareRpcBroker;
import org.opendaylight.controller.sal.dom.broker.impl.SchemaContextProvider;
import org.opendaylight.controller.sal.dom.broker.impl.SchemaContextProviders;
import org.opendaylight.controller.sal.dom.broker.spi.RpcRouter;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class BrokerConfigActivator
implements AutoCloseable {
    private static final InstanceIdentifier ROOT = new Functions.Function0<InstanceIdentifier>(){

        public InstanceIdentifier apply() {
            InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder();
            InstanceIdentifier _instance = (InstanceIdentifier)_builder.toInstance();
            return _instance;
        }
    }.apply();
    private DataBrokerImpl _dataService;
    private ServiceRegistration<DataBrokerService> dataReg;
    private ServiceRegistration<DataProviderService> dataProviderReg;
    private ServiceRegistration<MountService> mountReg;
    private ServiceRegistration<MountProvisionService> mountProviderReg;
    private SchemaService schemaService;
    private ServiceRegistration<RpcProvisionRegistry> rpcProvisionRegistryReg;
    private MountPointManagerImpl mountService;
    private SchemaAwareDataStoreAdapter wrappedStore;

    public DataBrokerImpl getDataService() {
        return this._dataService;
    }

    public void setDataService(DataBrokerImpl dataService) {
        this._dataService = dataService;
    }

    public void start(BrokerImpl broker, DataStore store, BundleContext context) {
        ServiceRegistration _registerService_4;
        ServiceRegistration _registerService_3;
        ServiceRegistration _registerService_2;
        MountPointManagerImpl _mountPointManagerImpl;
        SchemaAwareDataStoreAdapter _schemaAwareDataStoreAdapter;
        ServiceRegistration _registerService_1;
        ServiceRegistration _registerService;
        SchemaService _service;
        Hashtable _hashtable;
        Hashtable emptyProperties = _hashtable = new Hashtable();
        broker.setBundleContext(context);
        ServiceReference serviceRef = context.getServiceReference(SchemaService.class);
        this.schemaService = _service = (SchemaService)context.getService(serviceRef);
        SchemaContextProvider _fromSchemaService = SchemaContextProviders.fromSchemaService(this.schemaService);
        SchemaAwareRpcBroker _schemaAwareRpcBroker = new SchemaAwareRpcBroker("/", _fromSchemaService);
        broker.setRouter(_schemaAwareRpcBroker);
        DataBrokerImpl _dataBrokerImpl = new DataBrokerImpl();
        this.setDataService(_dataBrokerImpl);
        DataBrokerImpl _dataService = this.getDataService();
        ExecutorService _executor = broker.getExecutor();
        _dataService.setExecutor(_executor);
        DataBrokerImpl _dataService_1 = this.getDataService();
        this.dataReg = _registerService = context.registerService(DataBrokerService.class, (Object)_dataService_1, emptyProperties);
        DataBrokerImpl _dataService_2 = this.getDataService();
        this.dataProviderReg = _registerService_1 = context.registerService(DataProviderService.class, (Object)_dataService_2, emptyProperties);
        this.wrappedStore = _schemaAwareDataStoreAdapter = new SchemaAwareDataStoreAdapter();
        this.wrappedStore.changeDelegate(store);
        this.wrappedStore.setValidationEnabled(false);
        context.registerService(SchemaServiceListener.class, (Object)this.wrappedStore, emptyProperties);
        DataBrokerImpl _dataService_3 = this.getDataService();
        _dataService_3.registerConfigurationReader(ROOT, (DataReader<InstanceIdentifier, CompositeNode>)this.wrappedStore);
        DataBrokerImpl _dataService_4 = this.getDataService();
        _dataService_4.registerCommitHandler((Path)ROOT, (DataCommitHandler)this.wrappedStore);
        DataBrokerImpl _dataService_5 = this.getDataService();
        _dataService_5.registerOperationalReader(ROOT, (DataReader<InstanceIdentifier, CompositeNode>)this.wrappedStore);
        this.mountService = _mountPointManagerImpl = new MountPointManagerImpl();
        DataBrokerImpl _dataService_6 = this.getDataService();
        this.mountService.setDataBroker(_dataService_6);
        this.mountReg = _registerService_2 = context.registerService(MountService.class, (Object)this.mountService, emptyProperties);
        this.mountProviderReg = _registerService_3 = context.registerService(MountProvisionService.class, (Object)this.mountService, emptyProperties);
        RpcRouter _router = broker.getRouter();
        this.rpcProvisionRegistryReg = _registerService_4 = context.registerService(RpcProvisionRegistry.class, (Object)_router, emptyProperties);
    }

    @Override
    public void close() {
        if (this.dataReg != null) {
            this.dataReg.unregister();
        }
        if (this.dataProviderReg != null) {
            this.dataProviderReg.unregister();
        }
        if (this.mountReg != null) {
            this.mountReg.unregister();
        }
        if (this.mountProviderReg != null) {
            this.mountProviderReg.unregister();
        }
        if (this.rpcProvisionRegistryReg != null) {
            this.rpcProvisionRegistryReg.unregister();
        }
    }
}

