/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.dom.impl;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.AbstractSchemaServiceImplSingletonModule;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.controller.sal.dom.broker.GlobalBundleScanningSchemaServiceImpl;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class SchemaServiceImplSingletonModule
extends AbstractSchemaServiceImplSingletonModule {
    BundleContext bundleContext;

    public SchemaServiceImplSingletonModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public SchemaServiceImplSingletonModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, SchemaServiceImplSingletonModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public boolean canReuseInstance(AbstractSchemaServiceImplSingletonModule oldModule) {
        return true;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public AutoCloseable createInstance() {
        ServiceReference ref = this.getBundleContext().getServiceReference(SchemaService.class);
        if (ref != null) {
            return new GlobalSchemaServiceProxy(this.getBundleContext(), (ServiceReference<SchemaService>)ref);
        }
        GlobalBundleScanningSchemaServiceImpl newInstance = new GlobalBundleScanningSchemaServiceImpl();
        newInstance.setContext(this.getBundleContext());
        newInstance.start();
        return newInstance;
    }

    public class GlobalSchemaServiceProxy
    implements AutoCloseable,
    SchemaService,
    Delegator<SchemaService> {
        private BundleContext bundleContext;
        private ServiceReference<SchemaService> reference;
        private SchemaService delegate;

        public GlobalSchemaServiceProxy(BundleContext bundleContext, ServiceReference<SchemaService> ref) {
            this.bundleContext = bundleContext;
            this.reference = ref;
            this.delegate = (SchemaService)bundleContext.getService(this.reference);
        }

        @Override
        public void close() throws Exception {
            if (this.delegate != null) {
                this.delegate = null;
                this.bundleContext.ungetService(this.reference);
                this.reference = null;
                this.bundleContext = null;
            }
        }

        public void addModule(Module arg0) {
            this.delegate.addModule(arg0);
        }

        public SchemaContext getGlobalContext() {
            return this.delegate.getGlobalContext();
        }

        public SchemaContext getSessionContext() {
            return this.delegate.getSessionContext();
        }

        public ListenerRegistration<SchemaServiceListener> registerSchemaServiceListener(SchemaServiceListener arg0) {
            return this.delegate.registerSchemaServiceListener(arg0);
        }

        public void removeModule(Module arg0) {
            this.delegate.removeModule(arg0);
        }

        public SchemaService getDelegate() {
            return this.delegate;
        }
    }
}

