/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.dom.impl;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.AbstractDomBrokerImplModule;
import org.opendaylight.controller.config.yang.md.sal.dom.statistics.DomBrokerRuntimeMXBeanImpl;
import org.opendaylight.controller.sal.core.api.data.DataStore;
import org.opendaylight.controller.sal.dom.broker.BrokerConfigActivator;
import org.opendaylight.controller.sal.dom.broker.BrokerImpl;
import org.osgi.framework.BundleContext;

public final class DomBrokerImplModule
extends AbstractDomBrokerImplModule {
    private BundleContext bundleContext;

    public DomBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public DomBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, DomBrokerImplModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.getDataStore() != null ? 1 : 0) != 0, (Object)"Data Store needs to be provided for DomBroker");
    }

    @Override
    public AutoCloseable createInstance() {
        BrokerImpl broker = new BrokerImpl();
        BrokerConfigActivator activator = new BrokerConfigActivator();
        DataStore store = this.getDataStoreDependency();
        activator.start(broker, store, this.getBundleContext());
        DomBrokerRuntimeMXBeanImpl domBrokerRuntimeMXBean = new DomBrokerRuntimeMXBeanImpl(activator.getDataService());
        this.getRootRuntimeBeanRegistratorWrapper().register(domBrokerRuntimeMXBean);
        return broker;
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

