/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.dom.impl;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.md.sal.dom.DataStoreServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.HashMapDataStoreModuleMXBean;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.HashMapDataStoreRuntimeRegistrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHashMapDataStoreModule
implements Module,
HashMapDataStoreModuleMXBean,
DataStoreServiceInterface,
RuntimeBeanRegistratorAwareModule {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHashMapDataStoreModule.class);
    private final AbstractHashMapDataStoreModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    private final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private HashMapDataStoreRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;

    public AbstractHashMapDataStoreModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractHashMapDataStoreModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractHashMapDataStoreModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = oldInstance;
        this.oldModule = oldModule;
    }

    public HashMapDataStoreRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new HashMapDataStoreRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.customValidation();
    }

    protected void customValidation() {
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean canReuseInstance(AbstractHashMapDataStoreModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public abstract AutoCloseable createInstance();

    public boolean isSame(AbstractHashMapDataStoreModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractHashMapDataStoreModule that = (AbstractHashMapDataStoreModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

