/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.dom.impl;

import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.md.sal.dom.BrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.DataStoreServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.DomBrokerImplModuleMXBean;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.DomBrokerImplRuntimeRegistrator;
import org.opendaylight.controller.sal.core.api.data.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDomBrokerImplModule
implements Module,
DomBrokerImplModuleMXBean,
BrokerServiceInterface,
RuntimeBeanRegistratorAwareModule {
    protected final JmxAttribute dataStoreJmxAttribute = new JmxAttribute("DataStore");
    private ObjectName dataStore;
    private static final Logger logger = LoggerFactory.getLogger(AbstractDomBrokerImplModule.class);
    private final AbstractDomBrokerImplModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    private final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private DomBrokerImplRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private DataStore dataStoreDependency;

    public AbstractDomBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractDomBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractDomBrokerImplModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = oldInstance;
        this.oldModule = oldModule;
    }

    @Override
    public ObjectName getDataStore() {
        return this.dataStore;
    }

    @Override
    @RequireInterface(value=DataStoreServiceInterface.class)
    public void setDataStore(ObjectName dataStore) {
        this.dataStore = dataStore;
    }

    public DomBrokerImplRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new DomBrokerImplRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(DataStoreServiceInterface.class, this.dataStore, this.dataStoreJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final DataStore getDataStoreDependency() {
        return this.dataStoreDependency;
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            this.dataStoreDependency = (DataStore)this.dependencyResolver.resolveInstance(DataStore.class, this.dataStore, this.dataStoreJmxAttribute);
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean canReuseInstance(AbstractDomBrokerImplModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public abstract AutoCloseable createInstance();

    public boolean isSame(AbstractDomBrokerImplModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        return this.dataStoreDependency == other.dataStoreDependency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDomBrokerImplModule that = (AbstractDomBrokerImplModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

