/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ToasterBuilder {
    private DisplayString _toasterManufacturer;
    private DisplayString _toasterModelNumber;
    private Toaster.ToasterStatus _toasterStatus;
    private Map<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>> augmentation = new HashMap<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>>();

    public DisplayString getToasterManufacturer() {
        return this._toasterManufacturer;
    }

    public DisplayString getToasterModelNumber() {
        return this._toasterModelNumber;
    }

    public Toaster.ToasterStatus getToasterStatus() {
        return this._toasterStatus;
    }

    public <E extends Augmentation<Toaster>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ToasterBuilder setToasterManufacturer(DisplayString value) {
        if (value != null) {
            boolean isValidLength = false;
            ArrayList<Range> lengthConstraints = new ArrayList<Range>();
            lengthConstraints.add(Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(255)));
            for (Range r : lengthConstraints) {
                if (!r.contains((Comparable)Integer.valueOf(value.getValue().length()))) continue;
                isValidLength = true;
            }
            if (!isValidLength) {
                throw new IllegalArgumentException(String.format("Invalid length: {}, expected: {}.", value, lengthConstraints));
            }
        }
        this._toasterManufacturer = value;
        return this;
    }

    public ToasterBuilder setToasterModelNumber(DisplayString value) {
        if (value != null) {
            boolean isValidLength = false;
            ArrayList<Range> lengthConstraints = new ArrayList<Range>();
            lengthConstraints.add(Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(255)));
            for (Range r : lengthConstraints) {
                if (!r.contains((Comparable)Integer.valueOf(value.getValue().length()))) continue;
                isValidLength = true;
            }
            if (!isValidLength) {
                throw new IllegalArgumentException(String.format("Invalid length: {}, expected: {}.", value, lengthConstraints));
            }
        }
        this._toasterModelNumber = value;
        return this;
    }

    public ToasterBuilder setToasterStatus(Toaster.ToasterStatus value) {
        this._toasterStatus = value;
        return this;
    }

    public ToasterBuilder addAugmentation(Class<? extends Augmentation<Toaster>> augmentationType, Augmentation<Toaster> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Toaster build() {
        return new ToasterImpl(this);
    }

    private static final class ToasterImpl
    implements Toaster {
        private final DisplayString _toasterManufacturer;
        private final DisplayString _toasterModelNumber;
        private final Toaster.ToasterStatus _toasterStatus;
        private Map<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>> augmentation = new HashMap<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>>();

        public Class<Toaster> getImplementedInterface() {
            return Toaster.class;
        }

        private ToasterImpl(ToasterBuilder builder) {
            this._toasterManufacturer = builder.getToasterManufacturer();
            this._toasterModelNumber = builder.getToasterModelNumber();
            this._toasterStatus = builder.getToasterStatus();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public DisplayString getToasterManufacturer() {
            return this._toasterManufacturer;
        }

        @Override
        public DisplayString getToasterModelNumber() {
            return this._toasterModelNumber;
        }

        @Override
        public Toaster.ToasterStatus getToasterStatus() {
            return this._toasterStatus;
        }

        public <E extends Augmentation<Toaster>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._toasterManufacturer == null ? 0 : this._toasterManufacturer.hashCode());
            result = 31 * result + (this._toasterModelNumber == null ? 0 : this._toasterModelNumber.hashCode());
            result = 31 * result + (this._toasterStatus == null ? 0 : this._toasterStatus.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ToasterImpl other = (ToasterImpl)obj;
            if (this._toasterManufacturer == null ? other._toasterManufacturer != null : !this._toasterManufacturer.equals(other._toasterManufacturer)) {
                return false;
            }
            if (this._toasterModelNumber == null ? other._toasterModelNumber != null : !this._toasterModelNumber.equals(other._toasterModelNumber)) {
                return false;
            }
            if (this._toasterStatus == null ? other._toasterStatus != null : !this._toasterStatus.equals((Object)other._toasterStatus)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Toaster [_toasterManufacturer=");
            builder.append(this._toasterManufacturer);
            builder.append(", _toasterModelNumber=");
            builder.append(this._toasterModelNumber);
            builder.append(", _toasterStatus=");
            builder.append((Object)this._toasterStatus);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

