/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.persist.impl;

import java.util.Set;
import org.opendaylight.controller.netconf.client.NetconfClient;
import org.opendaylight.controller.netconf.client.NetconfClientDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);

    public static boolean isSubset(NetconfClient netconfClient, Set<String> expectedCaps) {
        return Util.isSubset(netconfClient.getCapabilities(), expectedCaps);
    }

    private static boolean isSubset(Set<String> currentCapabilities, Set<String> expectedCaps) {
        for (String exCap : expectedCaps) {
            if (currentCapabilities.contains(exCap)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeClientAndDispatcher(NetconfClient client) {
        NetconfClientDispatcher dispatcher = client.getNetconfClientDispatcher();
        Exception fromClient = null;
        try {
            client.close();
        }
        catch (Exception e) {
            fromClient = e;
        }
        finally {
            try {
                dispatcher.close();
            }
            catch (Exception e) {
                if (fromClient != null) {
                    e.addSuppressed(fromClient);
                }
                throw new RuntimeException("Error closing temporary client ", e);
            }
        }
    }
}

