/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.persist.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.config.persist.api.Persister;
import org.opendaylight.controller.config.persist.api.PropertiesProvider;
import org.opendaylight.controller.config.persist.api.StorageAdapter;
import org.opendaylight.controller.netconf.persist.impl.PropertiesProviderAdapterImpl;
import org.opendaylight.controller.netconf.persist.impl.osgi.PropertiesProviderBaseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersisterAggregator
implements Persister {
    private static final Logger logger = LoggerFactory.getLogger(PersisterAggregator.class);
    private final List<PersisterWithConfiguration> persisterWithConfigurations;

    private static PersisterWithConfiguration loadConfiguration(String index, PropertiesProviderBaseImpl propertiesProvider) {
        String classKey = index + "." + "storageAdapterClass";
        String storageAdapterClass = propertiesProvider.getProperty(classKey);
        if (storageAdapterClass == null || storageAdapterClass.equals("")) {
            throw new IllegalStateException("No persister is defined in " + propertiesProvider.getFullKeyForReporting(classKey) + " property. Persister is not operational");
        }
        try {
            Class<?> clazz = Class.forName(storageAdapterClass);
            boolean implementsCorrectIfc = StorageAdapter.class.isAssignableFrom(clazz);
            if (!implementsCorrectIfc) {
                throw new IllegalArgumentException("Storage adapter " + clazz + " does not implement " + StorageAdapter.class);
            }
            StorageAdapter storageAdapter = (StorageAdapter)StorageAdapter.class.cast(clazz.newInstance());
            boolean readOnly = false;
            String readOnlyProperty = propertiesProvider.getProperty(index + "." + "readonly");
            if (readOnlyProperty != null && readOnlyProperty.equals("true")) {
                readOnly = true;
            }
            PropertiesProviderAdapterImpl innerProvider = new PropertiesProviderAdapterImpl(propertiesProvider, index);
            Persister storage = storageAdapter.instantiate((PropertiesProvider)innerProvider);
            return new PersisterWithConfiguration(storage, readOnly);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable to instantiate storage adapter from " + storageAdapterClass, e);
        }
    }

    public PersisterAggregator(List<PersisterWithConfiguration> persisterWithConfigurations) {
        this.persisterWithConfigurations = persisterWithConfigurations;
    }

    public static PersisterAggregator createFromProperties(PropertiesProviderBaseImpl propertiesProvider) {
        ArrayList<PersisterWithConfiguration> persisterWithConfigurations = new ArrayList<PersisterWithConfiguration>();
        String prefixes = propertiesProvider.getProperty("active");
        if (!prefixes.isEmpty()) {
            String[] keys;
            for (String index : keys = prefixes.split(",")) {
                persisterWithConfigurations.add(PersisterAggregator.loadConfiguration(index, propertiesProvider));
            }
        }
        logger.debug("Initialized persister with following adapters {}", persisterWithConfigurations);
        return new PersisterAggregator(persisterWithConfigurations);
    }

    public void persistConfig(ConfigSnapshotHolder holder) throws IOException {
        for (PersisterWithConfiguration persisterWithConfiguration : this.persisterWithConfigurations) {
            if (persisterWithConfiguration.readOnly) continue;
            logger.debug("Calling {}.persistConfig", (Object)persisterWithConfiguration.storage);
            persisterWithConfiguration.storage.persistConfig(holder);
        }
    }

    public List<ConfigSnapshotHolder> loadLastConfigs() {
        ListIterator<PersisterWithConfiguration> li = this.persisterWithConfigurations.listIterator(this.persisterWithConfigurations.size());
        while (li.hasPrevious()) {
            PersisterWithConfiguration persisterWithConfiguration = li.previous();
            List configs = null;
            try {
                configs = persisterWithConfiguration.storage.loadLastConfigs();
            }
            catch (IOException e) {
                throw new RuntimeException("Error while calling loadLastConfig on " + persisterWithConfiguration, e);
            }
            if (configs.isEmpty()) continue;
            logger.debug("Found non empty configs using {}:{}", (Object)persisterWithConfiguration, (Object)configs);
            return configs;
        }
        logger.debug("No non-empty list of configuration snapshots found");
        return Collections.emptyList();
    }

    @VisibleForTesting
    List<PersisterWithConfiguration> getPersisterWithConfigurations() {
        return this.persisterWithConfigurations;
    }

    public void close() {
        RuntimeException lastException = null;
        for (PersisterWithConfiguration persisterWithConfiguration : this.persisterWithConfigurations) {
            try {
                persisterWithConfiguration.storage.close();
            }
            catch (RuntimeException e) {
                logger.error("Error while closing {}", (Object)persisterWithConfiguration.storage, (Object)e);
                if (lastException == null) {
                    lastException = e;
                    continue;
                }
                lastException.addSuppressed(e);
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    public String toString() {
        return "PersisterAggregator{persisterWithConfigurations=" + this.persisterWithConfigurations + '}';
    }

    public static class PersisterWithConfiguration {
        private final Persister storage;
        private final boolean readOnly;

        public PersisterWithConfiguration(Persister storage, boolean readOnly) {
            this.storage = storage;
            this.readOnly = readOnly;
        }

        @VisibleForTesting
        public Persister getStorage() {
            return this.storage;
        }

        @VisibleForTesting
        public boolean isReadOnly() {
            return this.readOnly;
        }

        public String toString() {
            return "PersisterWithConfiguration{storage=" + this.storage + ", readOnly=" + this.readOnly + '}';
        }
    }
}

