/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.flows.web;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.opendaylight.controller.forwardingrulesmanager.FlowConfig;
import org.opendaylight.controller.forwardingrulesmanager.IForwardingRulesManager;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.sal.core.Description;
import org.opendaylight.controller.sal.core.Name;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.Switch;
import org.opendaylight.controller.switchmanager.SwitchConfig;
import org.opendaylight.controller.web.DaylightWebUtil;
import org.opendaylight.controller.web.IDaylightWeb;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"})
public class Flows
implements IDaylightWeb {
    private static final UserLevel AUTH_LEVEL = UserLevel.CONTAINERUSER;
    private static final String WEB_NAME = "Flows";
    private static final String WEB_ID = "flows";
    private static final short WEB_ORDER = 2;
    private final Gson gson;

    public Flows() {
        ServiceHelper.registerGlobalService(IDaylightWeb.class, (Object)this, null);
        this.gson = new Gson();
    }

    public String getWebName() {
        return WEB_NAME;
    }

    public String getWebId() {
        return WEB_ID;
    }

    public short getWebOrder() {
        return 2;
    }

    public boolean isAuthorized(UserLevel userLevel) {
        return userLevel.ordinal() <= AUTH_LEVEL.ordinal();
    }

    @RequestMapping(value={"/main"})
    @ResponseBody
    public Map<String, Object> getFlows(HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        Privilege privilege = DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this);
        if (privilege == Privilege.NONE) {
            return null;
        }
        IForwardingRulesManager frm = (IForwardingRulesManager)ServiceHelper.getInstance(IForwardingRulesManager.class, (String)containerName, (Object)this);
        if (frm == null) {
            return null;
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            return null;
        }
        List staticFlowList = frm.getStaticFlows();
        HashSet flowSet = new HashSet();
        for (FlowConfig flowConfig : staticFlowList) {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("flow", flowConfig);
            entry.put("name", flowConfig.getName());
            Node node = flowConfig.getNode();
            entry.put("node", this.getNodeDesc(node, switchManager));
            entry.put("nodeId", node.toString());
            flowSet.add(entry);
        }
        HashMap<String, Object> output = new HashMap<String, Object>(2);
        output.put(WEB_ID, flowSet);
        output.put("privilege", privilege);
        return output;
    }

    @RequestMapping(value={"/node-ports"})
    @ResponseBody
    public Map<String, Object> getNodePorts(HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) == Privilege.NONE) {
            return null;
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            return null;
        }
        HashMap<String, Object> nodes = new HashMap<String, Object>();
        for (Switch node : switchManager.getNetworkDevices()) {
            HashMap<String, String> port = new HashMap<String, String>();
            Set nodeConnectorSet = node.getNodeConnectors();
            if (nodeConnectorSet != null) {
                for (NodeConnector nodeConnector : nodeConnectorSet) {
                    String nodeConnectorName = ((Name)switchManager.getNodeConnectorProp(nodeConnector, "name")).getValue();
                    port.put(nodeConnector.getID().toString(), nodeConnectorName + "(" + nodeConnector.getNodeConnectorIDString() + ")");
                }
            }
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("ports", port);
            entry.put("name", this.getNodeDesc(node.getNode(), switchManager));
            nodes.put(node.getNode().toString(), entry);
        }
        return nodes;
    }

    @RequestMapping(value={"/node-flows"})
    @ResponseBody
    public Map<String, Object> getNodeFlows(HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) == Privilege.NONE) {
            return null;
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            return null;
        }
        IForwardingRulesManager frm = (IForwardingRulesManager)ServiceHelper.getInstance(IForwardingRulesManager.class, (String)containerName, (Object)this);
        if (frm == null) {
            return null;
        }
        HashMap<String, Object> nodes = new HashMap<String, Object>();
        for (Switch sw : switchManager.getNetworkDevices()) {
            Node node = sw.getNode();
            List flows = frm.getStaticFlows(node);
            String nodeDesc = node.toString();
            SwitchConfig config = switchManager.getSwitchConfig(node.toString());
            if (config != null && config.getProperty("description") != null) {
                nodeDesc = ((Description)config.getProperty("description")).getValue();
            }
            nodes.put(nodeDesc, flows.size());
        }
        return nodes;
    }

    @RequestMapping(value={"/flow"}, method={RequestMethod.POST})
    @ResponseBody
    public String actionFlow(@RequestParam(required=true) String action, @RequestParam(required=false) String body, @RequestParam(required=true) String nodeId, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return "Operation not authorized";
        }
        IForwardingRulesManager frm = (IForwardingRulesManager)ServiceHelper.getInstance(IForwardingRulesManager.class, (String)containerName, (Object)this);
        if (frm == null) {
            return null;
        }
        FlowConfig flow = (FlowConfig)this.gson.fromJson(body, FlowConfig.class);
        Node node = Node.fromString((String)nodeId);
        flow.setNode(node);
        Status result = new Status(StatusCode.BADREQUEST, "Invalid request");
        if (action.equals("add")) {
            result = frm.addStaticFlow(flow);
            if (result.isSuccess()) {
                DaylightWebUtil.auditlog((String)"Flow Entry", (String)userName, (String)"added", (String)(flow.getName() + " on Node " + DaylightWebUtil.getNodeDesc((Node)node, (String)containerName, (Object)this)), (String)containerName);
            }
        } else if (action.equals("edit") && (result = frm.modifyStaticFlow(flow)).isSuccess()) {
            DaylightWebUtil.auditlog((String)"Flow Entry", (String)userName, (String)"updated", (String)(flow.getName() + " on Node " + DaylightWebUtil.getNodeDesc((Node)node, (String)containerName, (Object)this)), (String)containerName);
        }
        return result.isSuccess() ? StatusCode.SUCCESS.toString() : result.getDescription();
    }

    @RequestMapping(value={"/flow/{nodeId}/{name:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public String removeFlow(@PathVariable(value="nodeId") String nodeId, @PathVariable(value="name") String name, @RequestParam(required=true) String action, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return "Operation not authorized";
        }
        IForwardingRulesManager frm = (IForwardingRulesManager)ServiceHelper.getInstance(IForwardingRulesManager.class, (String)containerName, (Object)this);
        if (frm == null) {
            return null;
        }
        Status result = null;
        Node node = Node.fromString((String)nodeId);
        if (node == null) {
            return null;
        }
        if (action.equals("remove")) {
            result = frm.removeStaticFlow(name, node);
            if (result.isSuccess()) {
                DaylightWebUtil.auditlog((String)"Flow Entry", (String)userName, (String)"removed", (String)(name + " on Node " + DaylightWebUtil.getNodeDesc((Node)node, (String)containerName, (Object)this)), (String)containerName);
            }
        } else if (action.equals("toggle")) {
            result = frm.toggleStaticFlowStatus(name, node);
            if (result.isSuccess()) {
                DaylightWebUtil.auditlog((String)"Flow Entry", (String)userName, (String)"toggled", (String)(name + " on Node " + DaylightWebUtil.getNodeDesc((Node)node, (String)containerName, (Object)this)), (String)containerName);
            }
        } else {
            result = new Status(StatusCode.BADREQUEST, "Unknown action");
        }
        return result.isSuccess() ? StatusCode.SUCCESS.toString() : result.getDescription();
    }

    @RequestMapping(value={"/flow/deleteFlows"}, method={RequestMethod.POST})
    @ResponseBody
    public String removeSelectedFlows(@RequestParam(required=false) String body, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return "Operation not authorized";
        }
        IForwardingRulesManager frm = (IForwardingRulesManager)ServiceHelper.getInstance(IForwardingRulesManager.class, (String)containerName, (Object)this);
        if (frm == null) {
            return "Forwarding Rules Manager is not available";
        }
        List flowList = new ArrayList();
        flowList = (List)this.gson.fromJson(body, flowList.getClass());
        Status result = new Status(StatusCode.BADREQUEST, "Invalid request");
        String status = "";
        for (Map flowEntry : flowList) {
            Node node = Node.fromString((String)((String)flowEntry.get("node")));
            result = frm.removeStaticFlow((String)flowEntry.get("name"), node);
            if (result.isSuccess()) {
                DaylightWebUtil.auditlog((String)"Flow Entry", (String)userName, (String)"removed", (String)((String)flowEntry.get("name") + " on Node " + DaylightWebUtil.getNodeDesc((Node)node, (String)containerName, (Object)this)), (String)containerName);
                continue;
            }
            status = (String)flowEntry.get("name") + ", " + status;
        }
        if (!status.equals("")) {
            return "Could not remove " + status.substring(0, status.length() - 2) + " Flow(s)";
        }
        return "Success";
    }

    private String getNodeDesc(Node node, ISwitchManager switchManager) {
        Description desc = (Description)switchManager.getNodeProp(node, "description");
        String description = desc == null ? "" : desc.getValue();
        return description.isEmpty() || description.equalsIgnoreCase("none") ? node.toString() : description;
    }
}

